/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.utils.TaskFluent;
import org.kie.internal.task.api.InternalTaskService;

@Service
@ApplicationScoped
public class TaskOperationsServiceImpl
implements TaskOperationsService {
    @Inject
    private InternalTaskService internalTaskService;
    @Inject
    private UserTaskService taskService;
    @Inject
    private RuntimeDataService runtimeDataService;

    public long addQuickTask(String taskName, int priority, Date dueDate, List<String> users, List<String> groups, String identity, boolean start, boolean claim) {
        TaskFluent taskFluent = new TaskFluent().setName(taskName).setPriority(priority).setDueDate(dueDate);
        for (String user : users) {
            taskFluent.addPotentialUser(user);
        }
        for (String group : groups) {
            taskFluent.addPotentialGroup(group);
        }
        taskFluent.setAdminUser("Administrator");
        taskFluent.setAdminGroup("Administrators");
        long taskId = this.internalTaskService.addTask(taskFluent.getTask(), new HashMap());
        if (start) {
            this.taskService.start(Long.valueOf(taskId), identity);
        }
        if (claim) {
            this.taskService.claim(Long.valueOf(taskId), identity);
        }
        return taskId;
    }

    public void updateTask(long taskId, int priority, List<String> taskDescription, Date dueDate) {
        this.taskService.setPriority(Long.valueOf(taskId), priority);
        if (taskDescription != null) {
            this.taskService.setDescription(Long.valueOf(taskId), taskDescription.get(0));
        }
        if (dueDate != null) {
            this.taskService.setExpirationDate(Long.valueOf(taskId), dueDate);
        }
    }
}

