/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ht.backend.server.AuditTaskSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.CommentSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.TaskEventSummaryHelper;
import org.jbpm.console.ng.ht.backend.server.TaskSummaryHelper;
import org.jbpm.console.ng.ht.model.AuditTaskSummary;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.Day;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.impl.factories.TaskFactory;
import org.jbpm.services.task.query.QueryFilterImpl;
import org.jbpm.services.task.utils.TaskFluent;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.InternalTaskService;

@Service
@ApplicationScoped
public class TaskServiceEntryPointImpl
implements TaskServiceEntryPoint {
    @Inject
    private InternalTaskService internalTaskService;
    @Inject
    private UserTaskService taskService;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private TaskAuditService taskAuditService;

    @PostConstruct
    public void init() {
        this.taskAuditService.setTaskService((TaskService)this.internalTaskService);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<String> status, Date from, int offset, int count) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : status) {
            statuses.add(Status.valueOf((String)s));
        }
        List<TaskSummary> taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilterImpl qf = new QueryFilterImpl("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", offset, count);
            taskSummaries = TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses, (QueryFilter)qf));
        } else {
            QueryFilterImpl qf = new QueryFilterImpl(offset, count);
            taskSummaries = TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses, (QueryFilter)qf));
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<String> status, Date from, int offset, int count) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : status) {
            statuses.add(Status.valueOf((String)s));
        }
        List<TaskSummary> taskSummaries = TaskSummaryHelper.adaptCollection(this.runtimeDataService.getTasksOwnedByStatus(userId, statuses, (QueryFilter)new QueryFilterImpl(offset, count)));
        return taskSummaries;
    }

    public Map<Long, List<String>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        Map potentialOwnersForTaskIds = this.internalTaskService.getPotentialOwnersForTaskIds(taskIds);
        HashMap<Long, List<String>> potentialOwnersForTaskIdsSimple = new HashMap<Long, List<String>>();
        for (Long taskId : potentialOwnersForTaskIds.keySet()) {
            List orgEntities = (List)potentialOwnersForTaskIds.get(taskId);
            ArrayList<String> orgEntitiesSimple = new ArrayList<String>(orgEntities.size());
            for (OrganizationalEntity entity : orgEntities) {
                if (entity instanceof Group) {
                    orgEntitiesSimple.add("Group:" + entity.getId());
                    continue;
                }
                if (!(entity instanceof User)) continue;
                orgEntitiesSimple.add("User:" + entity.getId());
            }
            potentialOwnersForTaskIdsSimple.put(taskId, orgEntitiesSimple);
        }
        return potentialOwnersForTaskIdsSimple;
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, List<String> strStatuses, Date dateFrom, Date dateTo) {
        LocalDate dayFrom = new LocalDate((Object)dateFrom);
        LocalDate dayTo = new LocalDate((Object)dateTo);
        LocalDate today = new LocalDate();
        int nrOfDaysTotal = this.getNumberOfDaysWithinDateRange(dayFrom, dayTo);
        Map<LocalDate, List<TaskSummary>> tasksByDay = this.createDaysMapAndInitWithEmptyListForEachDay(dayFrom, nrOfDaysTotal);
        List<TaskSummary> taskSummaries = this.adaptTaskSummaryCollection(this.runtimeDataService.getTasksOwnedByStatus(userId, this.convertStatuses(strStatuses), (QueryFilter)new QueryFilterImpl(0, 0)));
        this.fillDaysMapWithTasksBasedOnExpirationDate(tasksByDay, taskSummaries, today);
        return this.transformLocalDatesToDays(tasksByDay);
    }

    private void fillDaysMapWithTasksBasedOnExpirationDate(Map<LocalDate, List<TaskSummary>> tasksByDay, List<TaskSummary> taskSummaries, LocalDate today) {
        for (TaskSummary taskSummary : taskSummaries) {
            LocalDate expDate = taskSummary.getExpirationTime() == null ? today : new LocalDate((Object)taskSummary.getExpirationTime());
            if (tasksByDay.get(expDate) == null) continue;
            tasksByDay.get(expDate).add(taskSummary);
        }
    }

    private Map<LocalDate, List<TaskSummary>> createDaysMapAndInitWithEmptyListForEachDay(LocalDate dayFrom, int nrOfDaysTotal) {
        LinkedHashMap<LocalDate, List<TaskSummary>> tasksByDay = new LinkedHashMap<LocalDate, List<TaskSummary>>();
        for (int i = 0; i < nrOfDaysTotal; ++i) {
            tasksByDay.put(dayFrom.plusDays(i), new ArrayList());
        }
        return tasksByDay;
    }

    private int getNumberOfDaysWithinDateRange(LocalDate dayFrom, LocalDate dayTo) {
        Days daysBetween = Days.daysBetween((ReadablePartial)dayFrom, (ReadablePartial)dayTo);
        return daysBetween.getDays() + 1;
    }

    private List<Status> convertStatuses(List<String> strStatuses) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String s : strStatuses) {
            statuses.add(Status.valueOf((String)s));
        }
        return statuses;
    }

    List<TaskSummary> adaptTaskSummaryCollection(List<org.kie.api.task.model.TaskSummary> taskSummaries) {
        return TaskSummaryHelper.adaptCollection(taskSummaries);
    }

    private Map<Day, List<TaskSummary>> transformLocalDatesToDays(Map<LocalDate, List<TaskSummary>> tasksByLocalDate) {
        LinkedHashMap<Day, List<TaskSummary>> tasksByDay = new LinkedHashMap<Day, List<TaskSummary>>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("EEEE dd");
        for (Map.Entry<LocalDate, List<TaskSummary>> entry : tasksByLocalDate.entrySet()) {
            Date dayDate = entry.getKey().toDateTimeAtStartOfDay().toDate();
            tasksByDay.put(new Day(dayDate, dayFormat.format(dayDate)), entry.getValue());
        }
        return tasksByDay;
    }

    public Map<Day, List<TaskSummary>> getTasksAssignedAsPotentialOwnerFromDateToDateByDays(String userId, List<String> strStatuses, Date from, int nrOfDaysTotal) {
        Date toDate = this.getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(from, nrOfDaysTotal);
        return this.getTasksAssignedAsPotentialOwnerFromDateToDateByDays(userId, strStatuses, from, toDate);
    }

    public Map<Day, List<TaskSummary>> getTasksAssignedAsPotentialOwnerFromDateToDateByDays(String userId, List<String> strStatuses, Date dateFrom, Date dateTo) {
        LocalDate dayFrom = new LocalDate((Object)dateFrom);
        LocalDate dayTo = new LocalDate((Object)dateTo);
        LocalDate today = new LocalDate();
        int nrOfDaysTotal = this.getNumberOfDaysWithinDateRange(dayFrom, dayTo);
        Map<LocalDate, List<TaskSummary>> tasksByDay = this.createDaysMapAndInitWithEmptyListForEachDay(dayFrom, nrOfDaysTotal);
        List<TaskSummary> taskSummaries = this.adaptTaskSummaryCollection(this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus(userId, this.convertStatuses(strStatuses), (QueryFilter)new QueryFilterImpl(0, 0)));
        this.fillDaysMapWithTasksBasedOnExpirationDate(tasksByDay, taskSummaries, today);
        return this.transformLocalDatesToDays(tasksByDay);
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, List<String> strStatuses, Date from, int nrOfDaysTotal) {
        Date toDate = this.getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(from, nrOfDaysTotal);
        return this.getTasksOwnedFromDateToDateByDays(userId, strStatuses, from, toDate);
    }

    private Date getEndDateBasedOnStartDateAndNumberOfDaysBetweenThem(Date from, int nrOfDaysTotal) {
        return new LocalDate(from.getTime()).plusDays(nrOfDaysTotal - 1).toDateMidnight().toDate();
    }

    public Map<Day, List<TaskSummary>> getTasksOwnedFromDateToDateByDays(String userId, Date from, Date to) {
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("InProgress");
        statuses.add("Reserved");
        statuses.add("Created");
        return this.getTasksOwnedFromDateToDateByDays(userId, statuses, from, to);
    }

    public List<TaskSummary> getTasksAssignedByGroup(String userId, String groupId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(groupId);
        List tasksAssignedAsPotentialOwner = this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, groupIds, (QueryFilter)new QueryFilterImpl(0, 0));
        ArrayList<org.kie.api.task.model.TaskSummary> taskForGroup = new ArrayList<org.kie.api.task.model.TaskSummary>();
        for (org.kie.api.task.model.TaskSummary ts : tasksAssignedAsPotentialOwner) {
            if (!ts.getPotentialOwners().contains(groupId)) continue;
            taskForGroup.add(ts);
        }
        return TaskSummaryHelper.adaptCollection(taskForGroup);
    }

    public long addTask(String taskString, Map<String, Object> inputs, Map<String, Object> templateVars) {
        Task task = TaskFactory.evalTask((String)taskString, templateVars);
        return this.internalTaskService.addTask(task, inputs);
    }

    public long addQuickTask(String taskName, int priority, Date dueDate, List<String> users, List<String> groups, String identity, boolean start, boolean claim) {
        TaskFluent taskFluent = new TaskFluent().setName(taskName).setPriority(priority).setDueDate(dueDate);
        for (String user : users) {
            taskFluent.addPotentialUser(user);
        }
        for (String group : groups) {
            taskFluent.addPotentialGroup(group);
        }
        taskFluent.setAdminUser("Administrator");
        taskFluent.setAdminGroup("Administrators");
        long taskId = this.internalTaskService.addTask(taskFluent.getTask(), new HashMap());
        if (start) {
            this.taskService.start(Long.valueOf(taskId), identity);
        }
        if (claim) {
            this.taskService.claim(Long.valueOf(taskId), identity);
        }
        return taskId;
    }

    public long addTaskAndStart(String taskString, Map<String, Object> inputs, String userId, Map<String, Object> templateVars) {
        long taskId = this.addTask(taskString, inputs, templateVars);
        this.taskService.start(Long.valueOf(taskId), userId);
        return taskId;
    }

    public long addTaskAndClaimAndStart(String taskString, Map<String, Object> inputs, String userId, Map<String, Object> templateVars) {
        long taskId = this.addTask(taskString, inputs, templateVars);
        this.taskService.claim(Long.valueOf(taskId), userId);
        this.taskService.start(Long.valueOf(taskId), userId);
        return taskId;
    }

    public void start(long taskId, String user) {
        this.taskService.start(Long.valueOf(taskId), user);
    }

    public void startBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.start(taskId, user);
        }
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.taskService.forward(Long.valueOf(taskId), userId, targetEntityId);
    }

    public void delegate(long taskId, String userId, String targetEntityId) {
        this.taskService.delegate(Long.valueOf(taskId), userId, targetEntityId);
    }

    public void complete(long taskId, String user, Map<String, Object> params) {
        try {
            this.taskService.complete(Long.valueOf(taskId), user, params);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void claim(long taskId, String user) {
        this.taskService.claim(Long.valueOf(taskId), user);
    }

    public void release(long taskId, String user) {
        this.taskService.release(Long.valueOf(taskId), user);
    }

    public void setPriority(long taskId, int priority) {
        this.taskService.setPriority(Long.valueOf(taskId), priority);
    }

    public void setTaskNames(long taskId, String taskName) {
        this.taskService.setName(Long.valueOf(taskId), taskName);
    }

    public void setExpirationDate(long taskId, Date date) {
        this.taskService.setExpirationDate(Long.valueOf(taskId), date);
    }

    public void setDescriptions(long taskId, String description) {
        this.taskService.setDescription(Long.valueOf(taskId), description);
    }

    public TaskSummary getTaskDetails(long taskId) {
        Task task = this.internalTaskService.getTaskById(taskId);
        if (task != null) {
            List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
            ArrayList<String> potOwnersString = null;
            if (potentialOwners != null) {
                potOwnersString = new ArrayList<String>(potentialOwners.size());
                for (OrganizationalEntity e : potentialOwners) {
                    potOwnersString.add(e.getId());
                }
            }
            return new TaskSummary(task.getId().longValue(), task.getName(), task.getDescription(), task.getTaskData().getStatus().name(), task.getPriority(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : "", task.getTaskData().getCreatedBy() != null ? task.getTaskData().getCreatedBy().getId() : "", task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), (long)((int)task.getTaskData().getParentId()));
        }
        return null;
    }

    public long saveContent(long taskId, Map<String, Object> values) {
        return this.addContent(taskId, values);
    }

    public long addContent(long taskId, Map<String, Object> values) {
        return this.taskService.saveContent(Long.valueOf(taskId), values);
    }

    public void deleteContent(long taskId, long contentId) {
        this.taskService.deleteContent(Long.valueOf(taskId), Long.valueOf(contentId));
    }

    public Map<String, Object> getContentListByTaskId(long taskId) {
        Map inputContent = this.taskService.getTaskInputContentByTaskId(Long.valueOf(taskId));
        if (inputContent == null) {
            return new HashMap<String, Object>();
        }
        return inputContent;
    }

    public Map<String, Object> getTaskOutputContentByTaskId(long taskId) {
        Map outputContent = this.taskService.getTaskOutputContentByTaskId(Long.valueOf(taskId));
        if (outputContent == null) {
            return new HashMap<String, Object>();
        }
        return outputContent;
    }

    public long addComment(long taskId, String text, String addedBy, Date addedOn) {
        return this.taskService.addComment(Long.valueOf(taskId), text, addedBy, addedOn);
    }

    public void deleteComment(long taskId, long commentId) {
        this.taskService.deleteComment(Long.valueOf(taskId), Long.valueOf(commentId));
    }

    public List<CommentSummary> getAllCommentsByTaskId(long taskId) {
        return CommentSummaryHelper.adaptCollection(this.taskService.getCommentsByTaskId(Long.valueOf(taskId)));
    }

    public CommentSummary getCommentById(long taskId, long commentId) {
        return CommentSummaryHelper.adapt(this.taskService.getCommentById(Long.valueOf(taskId), Long.valueOf(commentId)));
    }

    public void updateSimpleTaskDetails(long taskId, String taskName, int priority, String taskDescription, Date dueDate) {
        this.setPriority(taskId, priority);
        this.setTaskNames(taskId, taskName);
        this.setDescriptions(taskId, taskDescription);
        this.setExpirationDate(taskId, dueDate);
    }

    public void claimBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.claim(taskId, user);
            this.taskService.start(taskId, user);
        }
    }

    public void completeBatch(List<Long> taskIds, String user, Map<String, Object> params) {
        for (Long taskId : taskIds) {
            this.taskService.complete(taskId, user, params);
        }
    }

    public void releaseBatch(List<Long> taskIds, String user) {
        for (Long taskId : taskIds) {
            this.taskService.release(taskId, user);
        }
    }

    public Boolean existInDatabase(long taskId) {
        return this.runtimeDataService.getTaskById(Long.valueOf(taskId)) != null;
    }

    public List<TaskEventSummary> getAllTaskEvents(long taskId, String filter) {
        return TaskEventSummaryHelper.adaptCollection(this.taskAuditService.getAllTaskEvents(taskId, (QueryFilter)new QueryFilterImpl(0, 0)));
    }

    public List<TaskEventSummary> getAllTaskEventsByProcessInstanceId(long processInstanceId, String filter) {
        return TaskEventSummaryHelper.adaptCollection(this.taskAuditService.getAllTaskEventsByProcessInstanceId(processInstanceId, (QueryFilter)new QueryFilterImpl(0, 0)));
    }

    public List<AuditTaskSummary> getAllAuditTasks(String filter) {
        return AuditTaskSummaryHelper.adaptCollection(this.taskAuditService.getAllAuditTasks((QueryFilter)new QueryFilterImpl(0, 0)));
    }

    public List<AuditTaskSummary> getAllAuditTasksByUser(String userId, String filter) {
        return AuditTaskSummaryHelper.adaptCollection(this.taskAuditService.getAllAuditTasksByUser(userId, (QueryFilter)new QueryFilterImpl(0, 0)));
    }
}

