/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.util;

import com.google.gwt.junit.client.GWTTestCase;
import java.util.Date;
import org.jbpm.console.ng.gc.client.util.DateRange;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.junit.Test;

public class GwtTestDateUtils
extends GWTTestCase {
    public String getModuleName() {
        return "org.jbpm.console.ng.ht.JbpmConsoleNGHumanTasksClient";
    }

    @Test
    public void testCreateDateWithDefaultFormat() {
        Date date = DateUtils.createDate((String)"2013-05-01");
        System.out.println(date);
        GwtTestDateUtils.assertEquals((int)2013, (int)(date.getYear() + 1900));
        GwtTestDateUtils.assertEquals((int)5, (int)(date.getMonth() + 1));
        GwtTestDateUtils.assertEquals((int)1, (int)date.getDate());
    }

    @Test
    public void testCreateMalformedDateWithDefaultFormat() {
        try {
            DateUtils.createDate((String)"2013-kk-05");
            GwtTestDateUtils.fail((String)"IllegalArgumentException expected for malformed input!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWeekRange() {
        Date date = DateUtils.createDate((String)"2013-05-01");
        DateRange weekRange = DateUtils.getWorkWeekDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-04-29"), (Object)weekRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-05-03"), (Object)weekRange.getEndDate());
        date = DateUtils.createDate((String)"2013-01-02");
        weekRange = DateUtils.getWorkWeekDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2012-12-31"), (Object)weekRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-01-04"), (Object)weekRange.getEndDate());
        date = DateUtils.createDate((String)"2012-12-31");
        weekRange = DateUtils.getWorkWeekDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2012-12-31"), (Object)weekRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-01-04"), (Object)weekRange.getEndDate());
        date = DateUtils.createDate((String)"2012-12-31");
        weekRange = DateUtils.getWeekDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2012-12-31"), (Object)weekRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-01-06"), (Object)weekRange.getEndDate());
        date = DateUtils.createDate((String)"2013-09-01");
        weekRange = DateUtils.getWeekDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-08-26"), (Object)weekRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-09-01"), (Object)weekRange.getEndDate());
    }

    @Test
    public void testGetMonthRange() {
        Date date = DateUtils.createDate((String)"2013-04-25");
        DateRange monthRange = DateUtils.getMonthDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-04-01"), (Object)monthRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-04-30"), (Object)monthRange.getEndDate());
        date = DateUtils.createDate((String)"2013-12-31");
        monthRange = DateUtils.getMonthDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-12-01"), (Object)monthRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-12-31"), (Object)monthRange.getEndDate());
        date = DateUtils.createDate((String)"2013-01-01");
        monthRange = DateUtils.getMonthDateRange((Date)date);
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-01-01"), (Object)monthRange.getStartDate());
        GwtTestDateUtils.assertEquals((Object)DateUtils.createDate((String)"2013-01-31"), (Object)monthRange.getEndDate());
    }

    @Test
    public void testIsDateInRange() {
        Date date = DateUtils.createDate((String)"2013-05-15");
        DateRange dateRange = new DateRange(DateUtils.createDate((String)"2013-05-15"), DateUtils.createDate((String)"2013-05-15"), 0);
        GwtTestDateUtils.assertTrue((boolean)DateUtils.isDateInRange((Date)date, (DateRange)dateRange));
        date = DateUtils.createDate((String)"2013-05-15");
        dateRange = new DateRange(DateUtils.createDate((String)"2013-05-15"), DateUtils.createDate((String)"2014-05-19"), 0);
        GwtTestDateUtils.assertTrue((boolean)DateUtils.isDateInRange((Date)date, (DateRange)dateRange));
        date = DateUtils.createDate((String)"2013-05-15");
        dateRange = new DateRange(DateUtils.createDate((String)"2013-05-13"), DateUtils.createDate((String)"2013-05-15"), 0);
        GwtTestDateUtils.assertTrue((boolean)DateUtils.isDateInRange((Date)date, (DateRange)dateRange));
    }

    @Test
    public void testCompareDates() {
        Date date2;
        Date date1 = DateUtils.createDate((String)"2013-04-15");
        GwtTestDateUtils.assertTrue((DateUtils.compareDates((Date)date1, (Date)(date2 = DateUtils.createDate((String)"2013-04-15"))) == 0 ? 1 : 0) != 0);
        date1 = DateUtils.createDate((String)"2013-04-15");
        date1.setHours(8);
        date1.setMinutes(15);
        date2 = DateUtils.createDate((String)"2013-04-15");
        date2.setHours(10);
        date2.setMinutes(20);
        GwtTestDateUtils.assertTrue((DateUtils.compareDates((Date)date1, (Date)date2) == 0 ? 1 : 0) != 0);
        date1 = DateUtils.createDate((String)"2013-04-15");
        date2 = DateUtils.createDate((String)"2013-04-18");
        GwtTestDateUtils.assertTrue((DateUtils.compareDates((Date)date1, (Date)date2) == -1 ? 1 : 0) != 0);
        GwtTestDateUtils.assertTrue((DateUtils.compareDates((Date)date2, (Date)date1) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAreDatesEqual() {
        Date date1 = DateUtils.createDate((String)"2013-04-15");
        Date date2 = DateUtils.createDate((String)"2013-04-15");
        GwtTestDateUtils.assertTrue((boolean)DateUtils.areDatesEqual((Date)date1, (Date)date2));
        date1 = DateUtils.createDate((String)"2013-04-15");
        date1.setHours(8);
        date1.setMinutes(15);
        date2 = DateUtils.createDate((String)"2013-04-15");
        date2.setHours(10);
        date2.setMinutes(20);
        GwtTestDateUtils.assertTrue((boolean)DateUtils.areDatesEqual((Date)date1, (Date)date2));
        date1 = DateUtils.createDate((String)"2013-04-15");
        date2 = DateUtils.createDate((String)"2013-04-18");
        GwtTestDateUtils.assertFalse((boolean)DateUtils.areDatesEqual((Date)date1, (Date)date2));
    }

    @Test
    public void testGetSameOrClosestDateInPreviousMonth() {
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-02-28"), DateUtils.createDate((String)"2013-01-28"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-06-15"), DateUtils.createDate((String)"2013-05-15"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-03-31"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-03-30"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-03-29"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2013-05-31"), DateUtils.createDate((String)"2013-04-30"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2016-03-31"), DateUtils.createDate((String)"2016-02-29"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2016-03-30"), DateUtils.createDate((String)"2016-02-29"));
        this.getAndAssertSameOrClosestDateInPreviousMonth(DateUtils.createDate((String)"2016-03-29"), DateUtils.createDate((String)"2016-02-29"));
    }

    @Test
    public void testGetSameOrClosestDateInNextMonth() {
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-01-12"), DateUtils.createDate((String)"2013-02-12"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-12-01"), DateUtils.createDate((String)"2014-01-01"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-01-28"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-01-29"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-01-30"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-01-31"), DateUtils.createDate((String)"2013-02-28"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2013-03-31"), DateUtils.createDate((String)"2013-04-30"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2016-01-29"), DateUtils.createDate((String)"2016-02-29"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2016-01-30"), DateUtils.createDate((String)"2016-02-29"));
        this.getAndAssertSameOrClosestDateInNextMonth(DateUtils.createDate((String)"2016-01-31"), DateUtils.createDate((String)"2016-02-29"));
    }

    private void getAndAssertSameOrClosestDateInNextMonth(Date date, Date expectedDate) {
        Date resultDate = DateUtils.getSameOrClosestDateInNextMonth((Date)date);
        GwtTestDateUtils.assertTrue((String)("Expected " + expectedDate + ", got " + resultDate), (boolean)DateUtils.areDatesEqual((Date)resultDate, (Date)expectedDate));
    }

    private void getAndAssertSameOrClosestDateInPreviousMonth(Date date, Date expectedDate) {
        Date resultDate = DateUtils.getSameOrClosestDateInPreviousMonth((Date)date);
        GwtTestDateUtils.assertTrue((String)("Expected " + expectedDate + ", got " + resultDate), (boolean)DateUtils.areDatesEqual((Date)resultDate, (Date)expectedDate));
    }
}

