/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskcomments;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.SimplePager;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskCommentsService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class TaskCommentsPresenter {
    @Inject
    private TaskCommentsView view;
    @Inject
    private User identity;
    private long currentTaskId = 0L;
    @Inject
    Caller<TaskCommentsService> taskCommentsServices;
    private ListDataProvider<CommentSummary> dataProvider = new ListDataProvider();

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public ListDataProvider<CommentSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshComments() {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<List<CommentSummary>>(){

            public void callback(List<CommentSummary> comments) {
                TaskCommentsPresenter.this.dataProvider.getList().clear();
                TaskCommentsPresenter.this.dataProvider.getList().addAll(comments);
                if (comments.size() > 0) {
                    TaskCommentsPresenter.this.view.getDataGrid().setHeight("350px");
                    TaskCommentsPresenter.this.view.getPager().setVisible(true);
                }
                TaskCommentsPresenter.this.dataProvider.refresh();
                TaskCommentsPresenter.this.view.getDataGrid().redraw();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getAllCommentsByTaskId(this.currentTaskId);
    }

    public void addTaskComment(String text, Date addedOn) {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.getNewTaskCommentTextArea().setText("");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).addComment(this.currentTaskId, text, this.identity.getIdentifier(), addedOn);
    }

    public void removeTaskComment(long commentId) {
        ((TaskCommentsService)this.taskCommentsServices.call((RemoteCallback)new RemoteCallback<Long>(){

            public void callback(Long response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.getNewTaskCommentTextArea().setText("");
                TaskCommentsPresenter.this.view.displayNotification("Comment Deleted!");
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).deleteComment(this.currentTaskId, commentId);
    }

    public void addDataDisplay(HasData<CommentSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshComments();
        this.view.getDataGrid().redraw();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshComments();
            this.view.getDataGrid().redraw();
        }
    }

    public static interface TaskCommentsView
    extends IsWidget {
        public void init(TaskCommentsPresenter var1);

        public TextArea getNewTaskCommentTextArea();

        public Button addCommentButton();

        public DataGrid<CommentSummary> getDataGrid();

        public SimplePager getPager();

        public void displayNotification(String var1);
    }
}

