/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskadmin;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskAdminViewImpl.html")
public class TaskAdminViewImpl
extends Composite
implements TaskAdminPresenter.TaskAdminView {
    private TaskAdminPresenter presenter;
    @Inject
    @DataField
    public ControlLabel adminDetailsAccordionLabel;
    @Inject
    @DataField
    public Label adminUserOrGroupLabel;
    @Inject
    @DataField
    public Label adminUsersGroupsControlsLabel;
    @Inject
    @DataField
    public TextBox adminUserOrGroupText;
    @Inject
    @DataField
    public Button adminForwardButton;
    @Inject
    @DataField
    public Label adminUsersGroupsControlsPanel;
    @Inject
    @DataField
    public ControlLabel reminderDetailsAccordionLabel;
    @Inject
    @DataField
    public Label actualOwnerLabel;
    @Inject
    @DataField
    public Label actualOwnerPanel;
    @Inject
    @DataField
    public Button adminReminderButton;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    @Override
    public void init(TaskAdminPresenter presenter) {
        this.presenter = presenter;
        this.adminUserOrGroupLabel.setText(this.constants.Delegate_User());
        this.adminDetailsAccordionLabel.add((Widget)new HTMLPanel(this.constants.Details()));
        this.adminForwardButton.setText(this.constants.Forward());
        this.adminUsersGroupsControlsLabel.setText(this.constants.Potential_Owners());
        this.adminUsersGroupsControlsPanel.setStyleName("");
        this.reminderDetailsAccordionLabel.add((Widget)new HTMLPanel(this.constants.Reminder_Details()));
        this.actualOwnerLabel.setText(this.constants.Actual_Owner());
        this.actualOwnerPanel.setStyleName("");
        this.adminReminderButton.setText(this.constants.Reminder());
    }

    @EventHandler(value={"adminForwardButton"})
    public void adminForwardButton(ClickEvent e) {
        String userOrGroup = this.adminUserOrGroupText.getText();
        if (!userOrGroup.equals("")) {
            this.presenter.forwardTask(userOrGroup);
            this.adminForwardButton.setEnabled(false);
        } else {
            this.displayNotification("Please enter a user or a group to delegate the task");
        }
    }

    @EventHandler(value={"adminReminderButton"})
    public void adminReminderButton(ClickEvent e) {
        this.presenter.reminder();
    }

    public Label getUsersGroupsControlsPanel() {
        return this.adminUsersGroupsControlsPanel;
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public Button getForwardButton() {
        return this.adminForwardButton;
    }

    @Override
    public TextBox getUserOrGroupText() {
        return this.adminUserOrGroupText;
    }

    @Override
    public Button getReminderButton() {
        return this.adminReminderButton;
    }

    public Label getActualOwnerPanel() {
        return this.actualOwnerPanel;
    }
}

