/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskcomments;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.SimplePager;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import java.util.Comparator;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.CommentSummary;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskCommentsViewImpl.html")
public class TaskCommentsViewImpl
extends Composite
implements TaskCommentsPresenter.TaskCommentsView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private TaskCommentsPresenter presenter;
    @Inject
    @DataField
    public ControlLabel commentsAccordionLabel;
    @Inject
    @DataField
    public TextArea newTaskCommentTextArea;
    @Inject
    @DataField
    public Label newTaskCommentLabel;
    @Inject
    @DataField
    public Button addCommentButton;
    @Inject
    @DataField
    public DataGrid<CommentSummary> commentsListGrid;
    @Inject
    @DataField
    public SimplePager pager;
    @Inject
    @DataField
    public FlowPanel listContainer;
    @Inject
    private Event<NotificationEvent> notification;
    private ColumnSortEvent.ListHandler<CommentSummary> sortHandler;
    private static final int COMMENTS_PER_PAGE = 6;

    @Override
    public void clearCommentInput() {
        this.newTaskCommentTextArea.setText("");
    }

    @Override
    public void redrawDataGrid() {
        this.commentsListGrid.redraw();
    }

    public void init(TaskCommentsPresenter presenter) {
        this.presenter = presenter;
        this.listContainer.add(this.commentsListGrid);
        this.listContainer.add((Widget)this.pager);
        this.commentsAccordionLabel.add((Widget)new HTMLPanel(this.constants.Add_Comment()));
        this.commentsListGrid.setHeight("350px");
        this.commentsListGrid.setEmptyTableWidget((Widget)new HTMLPanel(this.constants.No_Comments_For_This_Task()));
        this.sortHandler = new ColumnSortEvent.ListHandler(presenter.getDataProvider().getList());
        this.commentsListGrid.addColumnSortHandler(this.sortHandler);
        this.initTableColumns();
        presenter.addDataDisplay((HasData<CommentSummary>)this.commentsListGrid);
        this.pager.setDisplay(this.commentsListGrid);
        this.pager.setPageSize(6);
        this.adjustDisplayForListOfSize(1);
        this.newTaskCommentTextArea.setWidth("300px");
        this.addCommentButton.setText(this.constants.Add_Comment());
        this.newTaskCommentLabel.setText(this.constants.Comment());
    }

    @Override
    public void adjustDisplayForListOfSize(int size) {
        if (size > 6) {
            this.pager.setVisible(true);
        } else {
            this.pager.setVisible(false);
        }
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(ClickEvent e) {
        this.presenter.addTaskComment(this.newTaskCommentTextArea.getText());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void initTableColumns() {
        Column<CommentSummary, String> addedByColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                int first = c.getAddedBy().indexOf(39);
                int last = c.getAddedBy().lastIndexOf(39);
                return c.getAddedBy().substring(first + 1, last);
            }
        };
        addedByColumn.setSortable(false);
        this.commentsListGrid.addColumn((Column)addedByColumn, this.constants.Added_By());
        this.commentsListGrid.setColumnWidth((Column)addedByColumn, "100px");
        Column<CommentSummary, String> addedAtColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                return format.format(c.getAddedAt());
            }
        };
        addedAtColumn.setSortable(true);
        addedAtColumn.setDefaultSortAscending(true);
        this.commentsListGrid.addColumn((Column)addedAtColumn, this.constants.At());
        this.sortHandler.setComparator((Column)addedAtColumn, (Comparator)new Comparator<CommentSummary>(){

            @Override
            public int compare(CommentSummary o1, CommentSummary o2) {
                return o1.getAddedAt().compareTo(o2.getAddedAt());
            }
        });
        Column<CommentSummary, String> commentTextColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary object) {
                return object.getText();
            }
        };
        addedByColumn.setSortable(false);
        this.commentsListGrid.addColumn((Column)commentTextColumn, this.constants.Comment());
        LinkedList<DeleteCommentActionHasCell> cells = new LinkedList<DeleteCommentActionHasCell>();
        cells.add(new DeleteCommentActionHasCell(this.constants.Delete(), new ActionCell.Delegate<CommentSummary>(){

            public void execute(CommentSummary comment) {
                TaskCommentsViewImpl.this.presenter.removeTaskComment(comment.getId());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<CommentSummary, CommentSummary> actionsColumn = new Column<CommentSummary, CommentSummary>((Cell)cell){

            public CommentSummary getValue(CommentSummary object) {
                return object;
            }
        };
        this.commentsListGrid.addColumn((Column)actionsColumn, "");
    }

    private class DeleteCommentActionHasCell
    implements HasCell<CommentSummary, CommentSummary> {
        private ActionCell<CommentSummary> cell;

        public DeleteCommentActionHasCell(String text, ActionCell.Delegate<CommentSummary> delegate) {
            this.cell = new ActionCell<CommentSummary>(text, delegate){

                public void render(Cell.Context context, CommentSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + TaskCommentsViewImpl.this.constants.Delete() + "'>" + TaskCommentsViewImpl.this.constants.Delete() + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<CommentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<CommentSummary, CommentSummary> getFieldUpdater() {
            return null;
        }

        public CommentSummary getValue(CommentSummary object) {
            return object;
        }
    }
}

