/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskprocesscontext;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextBox;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.model.events.TaskStyleEvent;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class TaskProcessContextPresenter {
    @Inject
    private PlaceManager placeManager;
    @Inject
    TaskProcessContextView view;
    @Inject
    private Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected;
    @Inject
    private Caller<TaskQueryService> taskQueryService;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Event<TaskStyleEvent> taskStyleEvent;
    private long currentTaskId = 0L;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void goToProcessInstanceDetails() {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary processInstance) {
                TaskProcessContextPresenter.this.placeManager.goTo("Process Instances");
                TaskProcessContextPresenter.this.processInstanceSelected.fire((Object)new ProcessInstancesWithDetailsRequestEvent(processInstance.getDeploymentId(), processInstance.getProcessInstanceId(), processInstance.getProcessId(), processInstance.getProcessName(), processInstance.getState()));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessInstanceById(Long.parseLong(this.view.getProcessInstanceIdText().getText()));
    }

    public void refreshProcessContextOfTask() {
        ((TaskQueryService)this.taskQueryService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null) {
                    TaskProcessContextPresenter.this.view.getProcessInstanceIdText().setText("None");
                    TaskProcessContextPresenter.this.view.getProcessIdText().setText("None");
                    TaskProcessContextPresenter.this.view.getpIDetailsButton().setEnabled(false);
                    return;
                }
                if (details.getStatus().equals("Completed")) {
                    TaskProcessContextPresenter.this.view.getProcessInstanceIdText().setEnabled(false);
                }
                TaskProcessContextPresenter.this.view.getProcessIdText().setEnabled(false);
                if (details.getProcessInstanceId() == -1L) {
                    TaskProcessContextPresenter.this.view.getProcessInstanceIdText().setText("None");
                    TaskProcessContextPresenter.this.view.getProcessIdText().setText("None");
                    TaskProcessContextPresenter.this.view.getpIDetailsButton().setEnabled(false);
                } else {
                    TaskProcessContextPresenter.this.view.getProcessInstanceIdText().setText(String.valueOf(details.getProcessInstanceId()));
                    TaskProcessContextPresenter.this.view.getProcessIdText().setText(details.getProcessId());
                    TaskProcessContextPresenter.this.view.getpIDetailsButton().setEnabled(true);
                }
                TaskProcessContextPresenter.this.view.getProcessInstanceIdText().setEnabled(false);
                TaskProcessContextPresenter.this.changeStyleRow(details.getTaskId());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new TaskKey(Long.valueOf(this.currentTaskId)));
    }

    private void changeStyleRow(long idTask) {
        this.taskStyleEvent.fire((Object)new TaskStyleEvent(Long.valueOf(idTask)));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshProcessContextOfTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshProcessContextOfTask();
        }
    }

    public static interface TaskProcessContextView
    extends IsWidget {
        public void init(TaskProcessContextPresenter var1);

        public TextBox getProcessInstanceIdText();

        public TextBox getProcessIdText();

        public Button getpIDetailsButton();

        public void displayNotification(String var1);
    }
}

