/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.ht.client.editors.quicknewtask.QuickNewTaskPopup;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="DataSet Tasks List")
public class DataSetTasksListGridPresenter
extends AbstractScreenListPresenter<TaskSummary> {
    @Inject
    private DataSetTaskListView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Caller<TaskLifeCycleService> taskOperationsService;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private QuickNewTaskPopup quickNewTaskPopup;
    @Inject
    private ErrorPopupPresenter errorPopup;
    public Button menuActionsButton;
    private PopupPanel popup = new PopupPanel(true);
    public Button menuRefreshButton = new Button();
    public Button menuResetTabsButton = new Button();
    private final List<MenuItem> items = new ArrayList<MenuItem>();

    public DataSetTasksListGridPresenter() {
        this.dataProvider = new AsyncDataProvider<TaskSummary>(){

            protected void onRangeChanged(HasData<TaskSummary> display) {
                DataSetTasksListGridPresenter.this.view.showBusyIndicator(DataSetTasksListGridPresenter.this.constants.Loading());
                Range visibleRange = DataSetTasksListGridPresenter.this.view.getListGrid().getVisibleRange();
                DataSetTasksListGridPresenter.this.getData(visibleRange);
            }
        };
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            if (currentTableSettings != null) {
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                GWT.log((String)("-----taskList getData " + columnSortList.size() + "currentTableSettings table name " + currentTableSettings.getTableName()));
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("createdOn");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), new DataSetReadyCallback(){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null) {
                            ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myTasksFromDataSet.add(new TaskSummary(DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "taskId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "name", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "description", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnIntValue(dataSet, "priority", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "actualOwner", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "createdBy", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "createdOn", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "activationTime", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnDateValue(dataSet, "dueDate", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "processSessionId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnStringValue(dataSet, "deploymentId", i), DataSetTasksListGridPresenter.this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentId", i).longValue()));
                            }
                            PageResponse taskSummaryPageResponse = new PageResponse();
                            taskSummaryPageResponse.setPageRowList(myTasksFromDataSet);
                            taskSummaryPageResponse.setStartRowIndex(visibleRange.getStart());
                            taskSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                            taskSummaryPageResponse.setTotalRowSizeExact(true);
                            if (visibleRange.getStart() + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                                taskSummaryPageResponse.setLastPage(true);
                            } else {
                                taskSummaryPageResponse.setLastPage(false);
                            }
                            DataSetTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
                        }
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                    }

                    public void notFound() {
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                        DataSetTasksListGridPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmHumanTasks ] ");
                        GWT.log((String)"DataSet with UUID [  jbpmHumanTasks ] not found.");
                    }

                    public boolean onError(ClientRuntimeError error) {
                        DataSetTasksListGridPresenter.this.view.hideBusyIndicator();
                        error.getThrowable().printStackTrace();
                        DataSetTasksListGridPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmHumanTasks ] error: " + error.getThrowable());
                        GWT.log((String)"DataSet with UUID [  jbpmHumanTasks ] error: ", (Throwable)error.getThrowable());
                        return false;
                    }
                });
            } else {
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            GWT.log((String)"Error looking up dataset with UUID [ jbpmHumanTasks ]");
        }
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSetting(tableSettings);
        this.refreshGrid();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List() + "DB";
    }

    @WorkbenchPartView
    public UberView<DataSetTasksListGridPresenter> getView() {
        return this.view;
    }

    public void releaseTask(Long taskId, String userId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification("Task Released");
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).release(taskId.longValue(), userId);
    }

    public void claimTask(Long taskId, String userId, String deploymentId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DataSetTasksListGridPresenter.this.view.displayNotification("Task Claimed");
                DataSetTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DataSetTasksListGridPresenter.this.errorPopup.showMessage("Unexpected error encountered : " + throwable.getMessage());
                return true;
            }
        })).claim(taskId.longValue(), userId, deploymentId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        GWT.log((String)("get menus DatasetTasklist presenter " + this.autoRefreshSeconds));
        this.setupButtons();
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Task()).respondsWith(new Command(){

            public void execute() {
                DataSetTasksListGridPresenter.this.quickNewTaskPopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetTasksListGridPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetTasksListGridPresenter.this.refreshGrid();
                            }
                        });
                        return DataSetTasksListGridPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTaskListGridPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DataSetTasksListGridPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTaskListGridPresenter#menuActionsButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetTasksListGridPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetTasksListGridPresenter.this.view.restoreTabs();
                            }
                        });
                        return DataSetTasksListGridPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTaskListGridPresenter#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void setupButtons() {
        this.menuActionsButton = new Button();
        this.createRefreshToggleButton(this.menuActionsButton);
        this.menuRefreshButton.setIcon(IconType.REFRESH);
        this.menuRefreshButton.setSize(ButtonSize.MINI);
        this.menuRefreshButton.setTitle(Constants.INSTANCE.Refresh());
        this.menuResetTabsButton.setIcon(IconType.TH_LIST);
        this.menuResetTabsButton.setSize(ButtonSize.MINI);
        this.menuResetTabsButton.setTitle(Constants.INSTANCE.RestoreDefaultFilters());
    }

    public void createRefreshToggleButton(final Button refreshIntervalSelector) {
        refreshIntervalSelector.setToggle(true);
        refreshIntervalSelector.setIcon(IconType.COG);
        refreshIntervalSelector.setTitle(Constants.INSTANCE.AutoRefresh());
        refreshIntervalSelector.setSize(ButtonSize.MINI);
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)refreshIntervalSelector.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    refreshIntervalSelector.setActive(false);
                }
            }
        });
        refreshIntervalSelector.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!refreshIntervalSelector.isActive()) {
                    DataSetTasksListGridPresenter.this.showSelectRefreshIntervalPopup(refreshIntervalSelector.getAbsoluteLeft() + refreshIntervalSelector.getOffsetWidth(), refreshIntervalSelector.getAbsoluteTop() + refreshIntervalSelector.getOffsetHeight(), refreshIntervalSelector);
                } else {
                    DataSetTasksListGridPresenter.this.popup.hide(false);
                }
            }
        });
    }

    private void showSelectRefreshIntervalPopup(int left, int top, final Button refreshIntervalSelector) {
        VerticalPanel popupContent = new VerticalPanel();
        int configuredSeconds = this.view.getRefreshValue();
        if (configuredSeconds > 0) {
            this.updateRefreshInterval(true, configuredSeconds);
        } else {
            this.updateRefreshInterval(false, 0);
        }
        RadioButton oneMinuteRadioButton = this.createTimeSelectorRadioButton(60, "1 Minute", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton fiveMinuteRadioButton = this.createTimeSelectorRadioButton(300, "5 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        RadioButton tenMinuteRadioButton = this.createTimeSelectorRadioButton(600, "10 Minutes", configuredSeconds, refreshIntervalSelector, popupContent);
        popupContent.add((Widget)oneMinuteRadioButton);
        popupContent.add((Widget)fiveMinuteRadioButton);
        popupContent.add((Widget)tenMinuteRadioButton);
        Button resetButton = new Button("Disable Autorefresh");
        resetButton.setSize(ButtonSize.MINI);
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetTasksListGridPresenter.this.updateRefreshInterval(false, 0);
                DataSetTasksListGridPresenter.this.view.saveRefreshValue(0);
                refreshIntervalSelector.setActive(false);
                DataSetTasksListGridPresenter.this.popup.hide();
            }
        });
        popupContent.add((Widget)resetButton);
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    private RadioButton createTimeSelectorRadioButton(int time, String name, int configuredSeconds, final Button refreshIntervalSelector, VerticalPanel popupContent) {
        RadioButton oneMinuteRadioButton = new RadioButton("refreshInterval", name);
        oneMinuteRadioButton.setText(name);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setValue(Boolean.valueOf(true));
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetTasksListGridPresenter.this.updateRefreshInterval(true, selectedRefreshTime);
                DataSetTasksListGridPresenter.this.view.saveRefreshValue(selectedRefreshTime);
                refreshIntervalSelector.setActive(false);
                DataSetTasksListGridPresenter.this.popup.hide();
            }
        });
        return oneMinuteRadioButton;
    }

    public static interface DataSetTaskListView
    extends AbstractListView.ListView<TaskSummary, DataSetTasksListGridPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);
    }
}

