/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskdetails;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.gc.client.util.UTCDateBox;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskCalendarEvent;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskOperationsService;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class TaskDetailsPresenter {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private PlaceManager placeManager;
    @Inject
    TaskDetailsView view;
    @Inject
    private Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected;
    @Inject
    private Caller<TaskQueryService> taskQueryService;
    @Inject
    private Caller<TaskOperationsService> taskOperationsService;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    private Event<TaskCalendarEvent> taskCalendarEvent;
    @Inject
    private Event<NotificationEvent> notification;
    private long currentTaskId = 0L;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void updateTask(String taskDescription, String userId, Date dueDate, int priority) {
        if (this.currentTaskId > 0L) {
            ArrayList<String> descriptions = new ArrayList<String>();
            descriptions.add(taskDescription);
            ((TaskOperationsService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void nothing) {
                    TaskDetailsPresenter.this.view.displayNotification(TaskDetailsPresenter.this.constants.TaskDetailsUpdatedForTaskId(TaskDetailsPresenter.this.currentTaskId));
                    TaskDetailsPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskDetailsPresenter.this.currentTaskId));
                    TaskDetailsPresenter.this.taskCalendarEvent.fire((Object)new TaskCalendarEvent(Long.valueOf(TaskDetailsPresenter.this.currentTaskId)));
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    ErrorPopup.showMessage((String)TaskDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                    return true;
                }
            })).updateTask(this.currentTaskId, priority, descriptions, dueDate);
        }
    }

    public void refreshTask() {
        ((TaskQueryService)this.taskQueryService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null) {
                    TaskDetailsPresenter.this.setReadOnlyTaskDetail();
                    return;
                }
                if (details.getStatus().equals("Completed")) {
                    TaskDetailsPresenter.this.setReadOnlyTaskDetail();
                }
                TaskDetailsPresenter.this.view.setTaskDescription(details.getDescription());
                Long date = UTCDateBox.date2utc((Date)details.getExpirationTime());
                if (date != null) {
                    TaskDetailsPresenter.this.view.setDueDate(date);
                    TaskDetailsPresenter.this.view.setDueDateTime(date);
                }
                TaskDetailsPresenter.this.view.setUser(details.getActualOwner());
                TaskDetailsPresenter.this.view.setUserEnabled(false);
                TaskDetailsPresenter.this.view.setTaskStatus(details.getStatus());
                TaskDetailsPresenter.this.view.setTaskStatusEnabled(false);
                TaskDetailsPresenter.this.view.setTaskPriority(String.valueOf(details.getPriority()));
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)TaskDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new TaskKey(Long.valueOf(this.currentTaskId)));
    }

    public void setReadOnlyTaskDetail() {
        this.view.setTaskDescriptionEnabled(false);
        this.view.setDueDateEnabled(false);
        this.view.setUserEnabled(false);
        this.view.setTaskStatusEnabled(false);
        this.view.setDueDateTimeEnabled(false);
        this.view.setTaskPriorityEnabled(false);
        this.view.setUpdateTaskVisible(false);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTask();
        }
    }

    public static interface TaskDetailsView
    extends IsWidget {
        public void init(TaskDetailsPresenter var1);

        public void setTaskDescription(String var1);

        public void setTaskDescriptionEnabled(Boolean var1);

        public void setDueDate(Long var1);

        public void setDueDateEnabled(Boolean var1);

        public void setDueDateTime(Long var1);

        public void setDueDateTimeEnabled(Boolean var1);

        public void setUser(String var1);

        public void setUserEnabled(Boolean var1);

        public void setTaskStatus(String var1);

        public void setTaskStatusEnabled(Boolean var1);

        public void setTaskPriority(String var1);

        public void setTaskPriorityEnabled(Boolean var1);

        public void setUpdateTaskVisible(Boolean var1);

        public void displayNotification(String var1);
    }
}

