/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskprocesscontext;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.ht.model.TaskKey;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskQueryService;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@Dependent
public class TaskProcessContextPresenter {
    private PlaceManager placeManager;
    private TaskProcessContextView view;
    private Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected;
    private Caller<TaskQueryService> taskQueryService;
    private Caller<DataServiceEntryPoint> dataServices;
    private long currentTaskId = 0L;
    private long currentProcessInstanceId = -1L;

    @Inject
    public TaskProcessContextPresenter(TaskProcessContextView view, PlaceManager placeManager, Caller<TaskQueryService> taskQueryService, Caller<DataServiceEntryPoint> dataServices, Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected) {
        this.view = view;
        this.taskQueryService = taskQueryService;
        this.dataServices = dataServices;
        this.placeManager = placeManager;
        this.processInstanceSelected = processInstanceSelected;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void goToProcessInstanceDetails() {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary summary) {
                TaskProcessContextPresenter.this.placeManager.goTo("DataSet Process Instances With Variables");
                TaskProcessContextPresenter.this.processInstanceSelected.fire((Object)new ProcessInstancesWithDetailsRequestEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), summary.getState()));
            }
        }, (ErrorCallback)new DefaultErrorCallback())).getProcessInstanceById(this.currentProcessInstanceId);
    }

    public void refreshProcessContextOfTask() {
        ((TaskQueryService)this.taskQueryService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null || details.getProcessInstanceId() == -1L) {
                    TaskProcessContextPresenter.this.view.setProcessInstanceId("None");
                    TaskProcessContextPresenter.this.view.setProcessId("None");
                    TaskProcessContextPresenter.this.view.enablePIDetailsButton(false);
                    return;
                }
                TaskProcessContextPresenter.this.currentProcessInstanceId = details.getProcessInstanceId();
                TaskProcessContextPresenter.this.view.setProcessInstanceId(String.valueOf(TaskProcessContextPresenter.this.currentProcessInstanceId));
                TaskProcessContextPresenter.this.view.setProcessId(details.getProcessId());
                TaskProcessContextPresenter.this.view.enablePIDetailsButton(true);
            }
        }, (ErrorCallback)new DefaultErrorCallback())).getItem((ItemKey)new TaskKey(Long.valueOf(this.currentTaskId)));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.refreshProcessContextOfTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshProcessContextOfTask();
        }
    }

    public static interface TaskProcessContextView
    extends UberView<TaskProcessContextPresenter> {
        public void displayNotification(String var1);

        public void setProcessInstanceId(String var1);

        public void setProcessId(String var1);

        public void enablePIDetailsButton(boolean var1);
    }
}

