/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid;

import com.google.gwt.view.client.Range;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.AbstractTasksListGridPresenter;
import org.jbpm.console.ng.ht.client.editors.taskslist.grid.dash.DataSetTasksListGridViewImpl;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

public abstract class AbstractTasksListGridPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String USR_ID = "admin";
    private CallerMock<TaskLifeCycleService> callerMockTaskOperationsService;
    @Mock
    private TaskLifeCycleService taskLifeCycleServiceMock;
    @Mock
    private DataSetTasksListGridViewImpl viewMock;
    @Mock
    DataSetQueryHelper dataSetQueryHelperMock;
    @Mock
    DataSetQueryHelper dataSetDomainDataQueryHelperMock;
    @Mock
    private ExtendedPagedTable<TaskSummary> extendedPagedTable;
    @Mock
    private DataSet dataSetMock;
    @Mock
    private DataSet dataSetTaskVarMock;
    @Mock
    private FilterSettings filterSettings;
    @Mock
    public User identity;
    protected AbstractTasksListGridPresenter presenter;

    @Before
    public void setupMocks() {
        DataSetLookup dataSetLookup = new DataSetLookup();
        dataSetLookup.setDataSetUUID("jbpmHumanTasks");
        this.callerMockTaskOperationsService = new CallerMock((Object)this.taskLifeCycleServiceMock);
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.viewMock.getVariablesTableSettings(Matchers.anyString())).thenReturn((Object)new DataSetTasksListGridViewImpl().getVariablesTableSettings("taskName"));
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.dataSetQueryHelperMock.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTasksListGridPresenterTest.this.dataSetMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTasksListGridPresenterTest.this.dataSetTaskVarMock);
                return null;
            }
        }).when((Object)this.dataSetDomainDataQueryHelperMock)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        this.presenter = this.createPresenter(this.viewMock, this.callerMockTaskOperationsService, this.dataSetQueryHelperMock, this.dataSetDomainDataQueryHelperMock, this.identity);
    }

    protected abstract AbstractTasksListGridPresenter createPresenter(DataSetTasksListGridViewImpl var1, CallerMock<TaskLifeCycleService> var2, DataSetQueryHelper var3, DataSetQueryHelper var4, User var5);

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).setLastOrderedColumn("createdOn");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock, (VerificationMode)Mockito.never())).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void releaseTaskTest() {
        this.presenter.releaseTask(TASK_ID, USR_ID);
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).release(TASK_ID.longValue(), USR_ID);
    }

    @Test
    public void claimTaskTest() {
        this.presenter.claimTask(TASK_ID, USR_ID, "deploymentId");
        ((TaskLifeCycleService)Mockito.verify((Object)this.taskLifeCycleServiceMock)).claim(TASK_ID.longValue(), USR_ID, "deploymentId");
    }

    public void isFilteredByTaskNameTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        String filterTaskName = this.presenter.isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertEquals((Object)"taskName", (Object)filterTaskName);
    }

    public void isFilteredByTaskNameInvalidTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"description", (String)"taskName")});
        String filterTaskName = this.presenter.isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertNull((Object)filterTaskName);
    }

    @Test
    public void getDomainSpecificDataForTasksTest() {
        this.presenter.setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelperMock.getColumnLongValue(this.dataSetMock, "taskId", 0)).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 0)).thenReturn((Object)1L);
        String taskVariable1 = "var1";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "name", 0)).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "value", 0)).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 1)).thenReturn((Object)1L);
        String taskVariable2 = "var2";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "name", 1)).thenReturn((Object)taskVariable2);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "value", 1)).thenReturn((Object)"value2");
        Set<String> expectedColumns = new HashSet<String>();
        expectedColumns.add(taskVariable1);
        expectedColumns.add(taskVariable2);
        this.presenter.getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Matchers.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnLongValue(this.dataSetTaskVarMock, "taskId", 0)).thenReturn((Object)1L);
        taskVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "name", 0)).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetDomainDataQueryHelperMock.getColumnStringValue(this.dataSetTaskVarMock, "value", 0)).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(taskVariable1);
        this.presenter.getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Matchers.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperMock, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetDomainDataQueryHelperMock, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void testTaskSummaryAdmin() {
        List<String> dataSets = Arrays.asList("jbpmHumanTasksWithAdmin", "jbpmHumanTasksWithUser", "jbpmHumanTasks", "jbpmHumanTasksWithVariables");
        for (String dataSet : dataSets) {
            Mockito.when((Object)this.dataSetMock.getUUID()).thenReturn((Object)dataSet);
            TaskSummary summary = this.presenter.createTaskSummaryFromDataSet(this.dataSetMock, 0);
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)"jbpmHumanTasksWithAdmin".equals(dataSet), (Object)summary.isForAdmin());
        }
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.presenter.onSearchEvent(searchEvent);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Matchers.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.presenter.onSearchEvent(searchEvent);
        ((DataSetTasksListGridViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Matchers.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchFilterEmpty() {
        List filters = this.presenter.getColumnFilters("");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterNull() {
        List filters = this.presenter.getColumnFilters(null);
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterEmptyTrim() {
        List filters = this.presenter.getColumnFilters("     ");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterId() {
        List filters = this.presenter.getColumnFilters("1");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"taskId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterIdTrim() {
        List filters = this.presenter.getColumnFilters(" 1 ");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"taskId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterString() {
        List filters = this.presenter.getColumnFilters("taskName");
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertEquals((Object)"name", (Object)((ColumnFilter)filters.get(0)).getColumnId());
        Assert.assertEquals((Object)"description", (Object)((ColumnFilter)filters.get(1)).getColumnId());
        Assert.assertEquals((Object)"processId", (Object)((ColumnFilter)filters.get(2)).getColumnId());
    }

    @Test
    public void testGetUserGroupFilters() {
        String userRole = "role1";
        String userId = "userId";
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        Group group2 = new Group(){

            public String getName() {
                return "group2";
            }
        };
        HashSet<5> roles = new HashSet<5>();
        Role role1 = new Role(){

            public String getName() {
                return "role1";
            }
        };
        roles.add(role1);
        HashSet<Object> groups = new HashSet<Object>();
        groups.add(group1);
        groups.add(group2);
        Mockito.when((Object)this.identity.getRoles()).thenReturn(roles);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(false);
        List columnFilters = ((LogicalExprFilter)userTaskFilter).getLogicalTerms();
        Assert.assertEquals((long)columnFilters.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userTaskFilter).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((Object)((LogicalExprFilter)columnFilters.get(0)).getLogicalOperator(), (Object)LogicalExprType.AND);
        List userGroupFilter = ((LogicalExprFilter)columnFilters.get(0)).getLogicalTerms();
        Assert.assertEquals((long)userGroupFilter.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        List groupFilter = ((LogicalExprFilter)userGroupFilter.get(0)).getLogicalTerms();
        List withoutActualOwnerFilter = ((LogicalExprFilter)userGroupFilter.get(1)).getLogicalTerms();
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(1)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)withoutActualOwnerFilter.size(), (long)2L);
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)groupFilter.size(), (long)4L);
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(2)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(3)).getColumnId());
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = role1"));
        ColumnFilter userOwnerFilter = (ColumnFilter)columnFilters.get(1);
        Assert.assertEquals((Object)userOwnerFilter.getColumnId(), (Object)"actualOwner");
    }

    @Test
    public void addDynamicUserRolesTest() {
        String userRole = "role1";
        String userGoup = "group1";
        String userId = "userId";
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        HashSet<6> groups = new HashSet<6>();
        groups.add(group1);
        Role role1 = new Role(){

            public String getName() {
                return "role1";
            }
        };
        HashSet<7> roles = new HashSet<7>();
        roles.add(role1);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getRoles()).thenReturn(roles);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelperMock.getColumnLongValue(this.dataSetMock, "taskId", 0)).thenReturn((Object)1L);
        this.filterSettings.getDataSetLookup().setDataSetUUID("jbpmHumanTasksWithUser");
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(false);
        Assert.assertEquals((Object)((ColumnFilter)this.filterSettings.getDataSetLookup().getFirstFilterOp().getColumnFilterList().get(0)).toString(), (Object)userTaskFilter.toString());
        Assert.assertTrue((boolean)(userTaskFilter instanceof LogicalExprFilter));
        Assert.assertEquals((Object)LogicalExprType.OR, (Object)((LogicalExprFilter)userTaskFilter).getLogicalOperator());
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = role1"));
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = group1"));
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = userId"));
    }

    @Test
    public void addDynamicAdminRolesTest() {
        String userRole = "role1";
        String userGoup = "group1";
        String userId = "userId";
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        HashSet<8> groups = new HashSet<8>();
        groups.add(group1);
        Role role1 = new Role(){

            public String getName() {
                return "role1";
            }
        };
        HashSet<9> roles = new HashSet<9>();
        roles.add(role1);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        Mockito.when((Object)this.identity.getRoles()).thenReturn(roles);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelperMock.getColumnLongValue(this.dataSetMock, "taskId", 0)).thenReturn((Object)1L);
        this.presenter.setAddingDefaultFilters(false);
        this.filterSettings.getDataSetLookup().setDataSetUUID("jbpmHumanTasksWithAdmin");
        this.presenter.getData(new Range(0, 5));
        ColumnFilter userTaskFilter = this.presenter.getUserGroupFilters(true);
        Assert.assertEquals((Object)((ColumnFilter)this.filterSettings.getDataSetLookup().getFirstFilterOp().getColumnFilterList().get(0)).toString(), (Object)userTaskFilter.toString());
        Assert.assertTrue((boolean)(userTaskFilter instanceof LogicalExprFilter));
        Assert.assertEquals((Object)LogicalExprType.OR, (Object)((LogicalExprFilter)userTaskFilter).getLogicalOperator());
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = role1"));
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = group1"));
        Assert.assertTrue((boolean)userTaskFilter.toString().contains("id = userId"));
    }
}

