/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskslist.grid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.service.TaskLifeCycleService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractTasksListGridPresenter
extends AbstractScreenListPresenter<TaskSummary> {
    @Inject
    private DataSetTaskListView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Caller<TaskLifeCycleService> taskOperationsService;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    protected RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);

    public AbstractTasksListGridPresenter() {
        this.dataProvider = new AsyncDataProvider<TaskSummary>(){

            protected void onRangeChanged(HasData<TaskSummary> display) {
                AbstractTasksListGridPresenter.this.view.showBusyIndicator(AbstractTasksListGridPresenter.this.constants.Loading());
                Range visibleRange = AbstractTasksListGridPresenter.this.view.getListGrid().getVisibleRange();
                AbstractTasksListGridPresenter.this.getData(visibleRange);
            }
        };
    }

    public AbstractTasksListGridPresenter(DataSetTaskListView view, Caller<TaskLifeCycleService> taskOperationsService, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific, User identity) {
        this.view = view;
        this.taskOperationsService = taskOperationsService;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
        this.identity = identity;
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        try {
            FilterSettings currentTableSettings;
            if (!this.isAddingDefaultFilters() && (currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings()) != null) {
                boolean isAdminDataset;
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("createdOn");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                if (!filters.isEmpty()) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                if ((isAdminDataset = currentTableSettings.getDataSetLookup().getDataSetUUID().equals("jbpmHumanTasksWithAdmin")) || currentTableSettings.getDataSetLookup().getDataSetUUID().equals("jbpmHumanTasksWithUser")) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{this.getUserGroupFilters(isAdminDataset)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{this.getUserGroupFilters(isAdminDataset)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetTaskCallback(visibleRange.getStart(), currentTableSettings));
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            try {
                Long taskId = Long.valueOf(searchString.trim());
                filters.add(FilterFactory.equalsTo((String)"taskId", (Comparable)taskId));
            }
            catch (NumberFormatException ex) {
                filters.add(FilterFactory.likeTo((String)"name", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"description", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"processId", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            }
        }
        return filters;
    }

    protected ColumnFilter getUserGroupFilters(boolean isAdminDataset) {
        Set groups = this.identity.getGroups();
        ArrayList<ColumnFilter> condList = new ArrayList<ColumnFilter>();
        for (Object g : groups) {
            condList.add(FilterFactory.equalsTo((String)"id", (Comparable)((Object)g.getName())));
        }
        Set roles = this.identity.getRoles();
        for (Role r : roles) {
            condList.add(FilterFactory.equalsTo((String)"id", (Comparable)((Object)r.getName())));
        }
        condList.add(FilterFactory.equalsTo((String)"id", (Comparable)((Object)this.identity.getIdentifier())));
        if (isAdminDataset) {
            return FilterFactory.OR((String)"id", condList);
        }
        ColumnFilter myGroupFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.OR(condList), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)"")), FilterFactory.isNull((String)"actualOwner")})});
        return FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{myGroupFilter, FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)this.identity.getIdentifier()))});
    }

    protected DataSetReadyCallback createDataSetTaskCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getDataSet()){

            public void callback(DataSet dataSet) {
                if (dataSet != null) {
                    ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myTasksFromDataSet.add(AbstractTasksListGridPresenter.this.createTaskSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = AbstractTasksListGridPresenter.this.isFilteredByTaskName(ops);
                    if (filterValue != null) {
                        AbstractTasksListGridPresenter.this.getDomainSpecifDataForTasks(startRange, dataSet.getRowCountNonTrimmed(), filterValue, myTasksFromDataSet);
                    } else {
                        PageResponse taskSummaryPageResponse = new PageResponse();
                        taskSummaryPageResponse.setPageRowList(myTasksFromDataSet);
                        taskSummaryPageResponse.setStartRowIndex(startRange);
                        taskSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                        taskSummaryPageResponse.setTotalRowSizeExact(true);
                        if (startRange + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                            taskSummaryPageResponse.setLastPage(true);
                        } else {
                            taskSummaryPageResponse.setLastPage(false);
                        }
                        AbstractTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
                    }
                }
                AbstractTasksListGridPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByTaskName(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("name".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForTasks(int startRange, int rowCountNotTrimmed, String filterValue, List<TaskSummary> myTasksFromDataSet) {
        FilterSettings variablesTableSettings = this.view.getVariablesTableSettings(filterValue);
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("taskId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        ArrayList<Long> tasksIds = new ArrayList<Long>();
        for (TaskSummary task : myTasksFromDataSet) {
            tasksIds.add(task.getTaskId());
        }
        DataSetFilter filter = new DataSetFilter();
        ColumnFilter filter1 = FilterFactory.equalsTo((String)"taskId", tasksIds);
        filter.addFilterColumn(new ColumnFilter[]{filter1});
        variablesTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, rowCountNotTrimmed, myTasksFromDataSet, variablesTableSettings.getDataSet()));
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, final int totalRowSize, final List<TaskSummary> instances, DataSet dataset) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, dataset){

            public void callback(DataSet dataSet) {
                if (dataSet.getRowCount() > 0) {
                    HashSet<String> columns = new HashSet<String>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        Long taskId = AbstractTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "taskId", i);
                        String variableName = AbstractTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "name", i);
                        String variableValue = AbstractTasksListGridPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "value", i);
                        for (TaskSummary task : instances) {
                            if (!task.getTaskId().equals(taskId)) continue;
                            task.addDomainData(variableName, variableValue);
                            columns.add(variableName);
                        }
                    }
                    AbstractTasksListGridPresenter.this.view.addDomainSpecifColumns((ExtendedPagedTable<TaskSummary>)AbstractTasksListGridPresenter.this.view.getListGrid(), columns);
                }
                PageResponse taskSummaryPageResponse = new PageResponse();
                taskSummaryPageResponse.setPageRowList(instances);
                taskSummaryPageResponse.setStartRowIndex(startRange);
                taskSummaryPageResponse.setTotalRowSize(totalRowSize);
                taskSummaryPageResponse.setTotalRowSizeExact(true);
                if (startRange + instances.size() == totalRowSize) {
                    taskSummaryPageResponse.setLastPage(true);
                } else {
                    taskSummaryPageResponse.setLastPage(false);
                }
                AbstractTasksListGridPresenter.this.updateDataOnCallback(taskSummaryPageResponse);
            }
        };
    }

    protected TaskSummary createTaskSummaryFromDataSet(DataSet dataSet, int i) {
        return new TaskSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "taskId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "name", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "description", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "priority", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "actualOwner", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "createdBy", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "createdOn", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "activationTime", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "dueDate", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processSessionId", i).longValue(), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "deploymentId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentId", i).longValue(), "jbpmHumanTasksWithAdmin".equals(dataSet.getUUID()));
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List();
    }

    @WorkbenchPartView
    public UberView<AbstractTasksListGridPresenter> getView() {
        return this.view;
    }

    public void releaseTask(final Long taskId, String userId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                AbstractTasksListGridPresenter.this.view.displayNotification(Constants.INSTANCE.TaskReleased(String.valueOf(taskId)));
                AbstractTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                AbstractTasksListGridPresenter.this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).release(taskId.longValue(), userId);
    }

    public void claimTask(final Long taskId, String userId, String deploymentId) {
        ((TaskLifeCycleService)this.taskOperationsService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                AbstractTasksListGridPresenter.this.view.displayNotification(Constants.INSTANCE.TaskClaimed(String.valueOf(taskId)));
                AbstractTasksListGridPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                AbstractTasksListGridPresenter.this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).claim(taskId.longValue(), userId, deploymentId);
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    public abstract Menus getMenus();

    public static interface DataSetTaskListView
    extends AbstractListView.ListView<TaskSummary, AbstractTasksListGridPresenter> {
        public int getRefreshValue();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);

        public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> var1, Set<String> var2);

        public FilterSettings getVariablesTableSettings(String var1);
    }
}

