/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.tasklogs;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskLogsPresenterTest {
    private static final Long TASK_ID = 1L;
    @Mock
    private TaskService taskService;
    private Caller<TaskService> remoteTaskServiceCaller;
    @Mock
    private TaskLogsPresenter.TaskLogsView taskLogsView;
    private TaskLogsPresenter presenter;

    @Before
    public void setupMocks() {
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        this.presenter = new TaskLogsPresenter(this.taskLogsView, this.remoteTaskServiceCaller);
        Mockito.when((Object)this.taskService.getTaskComments("", "", Long.valueOf(1L))).thenReturn(Mockito.mock(List.class));
    }

    @Test
    public void logsUpdatedWhenTaskSelected() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)2))).setLogTextAreaText("");
    }

    @Test
    public void logsUpdatedWhenTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID.longValue()));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).getTaskEvents(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)4))).setLogTextAreaText("");
    }

    @Test
    public void logsNotUpdatedWhenDifferentTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID + 1L));
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)2))).setLogTextAreaText("");
    }

    @Test
    public void logEventsAreFormattedProperly() {
        List<TaskEventSummary> eventSummaries = this.createEventSummariesForTaks(TASK_ID);
        Mockito.when((Object)this.taskService.getTaskEvents(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)TASK_ID))).thenReturn(eventSummaries);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogTextAreaText("15/12/2017 00:00: Task ADDED (Jan)<br>01/01/2018 00:00: Task UPDATED (Maria updated this task)<br>20/01/2018 00:00: Task CLAIMED (John)<br>");
    }

    private List<TaskEventSummary> createEventSummariesForTaks(Long taskId) {
        TaskEventSummary added = new TaskEventSummary(Long.valueOf(1L), taskId, "ADDED", "Jan", Long.valueOf(3L), this.createDate(2017, Month.DECEMBER, 15), "Jan created this task");
        TaskEventSummary updated = new TaskEventSummary(Long.valueOf(2L), taskId, "UPDATED", "Maria", Long.valueOf(3L), this.createDate(2018, Month.JANUARY, 1), "Maria updated this task");
        TaskEventSummary claimed = new TaskEventSummary(Long.valueOf(3L), taskId, "CLAIMED", "John", Long.valueOf(3L), this.createDate(2018, Month.JANUARY, 20), "John claimed this task");
        List<TaskEventSummary> summaryList = Arrays.asList(added, updated, claimed);
        return summaryList;
    }

    private Date createDate(int year, Month month, int day) {
        LocalDate localDate = LocalDate.of(year, month, day);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

