/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskprocesscontext;

import com.google.common.collect.Sets;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.bd.model.ProcessInstanceKey;
import org.jbpm.console.ng.bd.model.ProcessInstanceSummary;
import org.jbpm.console.ng.ht.client.editors.taskprocesscontext.TaskProcessContextPresenter;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskService;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskProcessContextPresenterTest {
    private static final Long TASK_ID_NO_PROCESS = 1L;
    private static final Long TASK_ID_WITH_PROC = 2L;
    private static final Long TASK_ID_NULL_DETAILS = 3L;
    TaskSummary taskNoProcess = new TaskSummary(TASK_ID_NO_PROCESS.longValue(), "task without process", null, null, 0, null, null, null, null, null, null, -1L, -1L, null, -1L);
    TaskSummary taskWithProcess = new TaskSummary(TASK_ID_WITH_PROC.longValue(), "task with process", null, null, 0, null, null, null, null, null, "TEST_PROCESS_ID", -1L, 123L, null, -1L);
    @Mock
    ProcessRuntimeDataService dataServiceEntryPoint;
    @Mock
    Event<ProcessInstancesWithDetailsRequestEvent> procNavigationMock;
    @Mock
    private TaskProcessContextPresenter.TaskProcessContextView viewMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ActivityManager activityManager;
    private TaskProcessContextPresenter presenter;

    @Before
    public void before() {
        TaskService tqs = (TaskService)Mockito.mock(TaskService.class);
        Mockito.when((Object)tqs.getTask(null, null, TASK_ID_NO_PROCESS)).thenReturn((Object)this.taskNoProcess);
        Mockito.when((Object)tqs.getTask(null, null, TASK_ID_WITH_PROC)).thenReturn((Object)this.taskWithProcess);
        Mockito.when((Object)tqs.getTask(null, null, TASK_ID_NULL_DETAILS)).thenReturn(null);
        CallerMock taskQueryServiceMock = new CallerMock((Object)tqs);
        CallerMock dataServiceCallerMock = new CallerMock((Object)this.dataServiceEntryPoint);
        this.presenter = new TaskProcessContextPresenter(this.viewMock, this.placeManager, (Caller)taskQueryServiceMock, (Caller)dataServiceCallerMock, this.procNavigationMock, this.activityManager);
    }

    @Test
    public void processContextEmpty_whenTaskDetailsNull() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_NULL_DETAILS));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void processContextEmtpy_whenTaskNotAssociatedWithProcess() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_NO_PROCESS));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void processContextShowsProcessInfo_whenTaskDetailsHasProcess() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(TASK_ID_WITH_PROC));
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("TEST_PROCESS_ID");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("123");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enablePIDetailsButton(true);
    }

    @Test
    public void testGoToProcessInstanceDetails() {
        ProcessInstanceSummary summary = new ProcessInstanceSummary();
        summary.setDeploymentId("deploymentId");
        summary.setProcessInstanceId(Long.valueOf(-1L));
        summary.setProcessId("processId");
        summary.setProcessName("processName");
        summary.setState(1);
        Mockito.when((Object)this.dataServiceEntryPoint.getProcessInstance(Mockito.anyString(), (ProcessInstanceKey)Matchers.any(ProcessInstanceKey.class))).thenReturn((Object)summary);
        this.presenter.goToProcessInstanceDetails();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("DataSet Process Instances With Variables");
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(ProcessInstancesWithDetailsRequestEvent.class);
        ((Event)Mockito.verify(this.procNavigationMock)).fire(eventCaptor.capture());
        ProcessInstancesWithDetailsRequestEvent event = (ProcessInstancesWithDetailsRequestEvent)eventCaptor.getValue();
        Assert.assertEquals((Object)summary.getDeploymentId(), (Object)event.getDeploymentId());
        Assert.assertEquals((Object)summary.getProcessInstanceId(), (Object)event.getProcessInstanceId());
        Assert.assertEquals((Object)summary.getProcessId(), (Object)event.getProcessDefId());
        Assert.assertEquals((Object)summary.getProcessName(), (Object)event.getProcessDefName());
        Assert.assertEquals((Object)summary.getState(), (Object)event.getProcessInstanceStatus());
    }

    @Test
    public void testProcessContextEnabled() {
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn((Object)Sets.newHashSet((Object[])new Activity[]{(Activity)Mockito.mock(Activity.class)}));
        this.presenter.init();
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(true);
    }

    @Test
    public void testProcessContextDisabled() {
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn(Collections.emptySet());
        this.presenter.init();
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }
}

