/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskassignments;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ht.client.i18n.Constants;
import org.jbpm.console.ng.ht.model.TaskAssignmentSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskService;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;

@Dependent
public class TaskAssignmentsPresenter {
    private Constants constants = Constants.INSTANCE;
    private TaskAssignmentsView view;
    private Caller<TaskService> taskService;
    private Event<TaskRefreshedEvent> taskRefreshed;
    private long currentTaskId = 0L;
    private String serverTemplateId;
    private String containerId;

    @Inject
    public TaskAssignmentsPresenter(TaskAssignmentsView view, Caller<TaskService> taskService, Event<TaskRefreshedEvent> taskRefreshed) {
        this.view = view;
        this.taskService = taskService;
        this.taskRefreshed = taskRefreshed;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void delegateTask(String entity) {
        if (entity == null || "".equals(entity.trim())) {
            this.view.setHelpText(this.constants.DelegationUserInputRequired());
            return;
        }
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                TaskAssignmentsPresenter.this.view.displayNotification(TaskAssignmentsPresenter.this.constants.TaskSuccessfullyDelegated());
                TaskAssignmentsPresenter.this.view.setDelegateButtonActive(false);
                TaskAssignmentsPresenter.this.view.setHelpText(TaskAssignmentsPresenter.this.constants.DelegationSuccessfully());
                TaskAssignmentsPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskAssignmentsPresenter.this.currentTaskId));
                TaskAssignmentsPresenter.this.refreshTaskPotentialOwners();
            }
        }, (ErrorCallback)new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                TaskAssignmentsPresenter.this.view.setDelegateButtonActive(true);
                TaskAssignmentsPresenter.this.view.setHelpText(TaskAssignmentsPresenter.this.constants.DelegationUnable());
                return super.error(message, throwable);
            }
        })).delegate(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId), entity);
    }

    public void refreshTaskPotentialOwners() {
        if (this.currentTaskId != 0L) {
            this.view.enableDelegateButton(false);
            this.view.enableUserOrGroupInput(false);
            this.view.setPotentialOwnersInfo("");
            ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<TaskAssignmentSummary>(){

                public void callback(TaskAssignmentSummary response) {
                    if (response.getPotOwnersString() == null || response.getPotOwnersString().isEmpty()) {
                        TaskAssignmentsPresenter.this.view.setPotentialOwnersInfo(TaskAssignmentsPresenter.this.constants.No_Potential_Owners());
                    } else {
                        TaskAssignmentsPresenter.this.view.setPotentialOwnersInfo(response.getPotOwnersString().toString());
                        TaskAssignmentsPresenter.this.view.enableDelegateButton(response.isDelegationAllowed());
                        TaskAssignmentsPresenter.this.view.enableUserOrGroupInput(response.isDelegationAllowed());
                    }
                }
            })).getTaskAssignmentDetails(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId));
        }
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.serverTemplateId = event.getServerTemplateId();
        this.containerId = event.getContainerId();
        this.view.setHelpText("");
        this.view.clearUserOrGroupInput();
        this.refreshTaskPotentialOwners();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTaskPotentialOwners();
        }
    }

    public static interface TaskAssignmentsView
    extends IsWidget {
        public void init(TaskAssignmentsPresenter var1);

        public void displayNotification(String var1);

        public void setPotentialOwnersInfo(String var1);

        public void enableDelegateButton(boolean var1);

        public void setDelegateButtonActive(boolean var1);

        public void clearUserOrGroupInput();

        public void enableUserOrGroupInput(boolean var1);

        public void setHelpText(String var1);
    }
}

