/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.client.editors.taskprocesscontext;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ht.model.TaskSummary;
import org.jbpm.console.ng.ht.model.events.TaskRefreshedEvent;
import org.jbpm.console.ng.ht.model.events.TaskSelectionEvent;
import org.jbpm.console.ng.ht.service.TaskService;
import org.jbpm.console.ng.pr.events.ProcessInstancesWithDetailsRequestEvent;
import org.jbpm.console.ng.pr.model.ProcessInstanceKey;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class TaskProcessContextPresenter {
    public static final String PROCESS_INSTANCE_DETAILS = "DataSet Process Instances With Variables";
    private PlaceManager placeManager;
    private ActivityManager activityManager;
    private TaskProcessContextView view;
    private Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected;
    private Caller<TaskService> taskService;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    private long currentTaskId = 0L;
    private long currentProcessInstanceId = -1L;
    private boolean enableProcessInstanceDetails = true;
    private String serverTemplateId;
    private String containerId;

    @Inject
    public TaskProcessContextPresenter(TaskProcessContextView view, PlaceManager placeManager, Caller<TaskService> taskService, Caller<ProcessRuntimeDataService> processRuntimeDataService, Event<ProcessInstancesWithDetailsRequestEvent> processInstanceSelected, ActivityManager activityManager) {
        this.view = view;
        this.taskService = taskService;
        this.processRuntimeDataService = processRuntimeDataService;
        this.placeManager = placeManager;
        this.processInstanceSelected = processInstanceSelected;
        this.activityManager = activityManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        Set activity = this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest(PROCESS_INSTANCE_DETAILS));
        this.enableProcessInstanceDetails = !activity.isEmpty();
        this.view.enablePIDetailsButton(this.enableProcessInstanceDetails);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void goToProcessInstanceDetails() {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary summary) {
                TaskProcessContextPresenter.this.placeManager.goTo(TaskProcessContextPresenter.PROCESS_INSTANCE_DETAILS);
                TaskProcessContextPresenter.this.processInstanceSelected.fire((Object)new ProcessInstancesWithDetailsRequestEvent(TaskProcessContextPresenter.this.serverTemplateId, summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), summary.getState()));
            }
        })).getProcessInstance(this.serverTemplateId, new ProcessInstanceKey(this.serverTemplateId, Long.valueOf(this.currentProcessInstanceId)));
    }

    public void refreshProcessContextOfTask() {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null || details.getProcessInstanceId() == -1L) {
                    TaskProcessContextPresenter.this.view.setProcessInstanceId("None");
                    TaskProcessContextPresenter.this.view.setProcessId("None");
                    TaskProcessContextPresenter.this.view.enablePIDetailsButton(false);
                    return;
                }
                TaskProcessContextPresenter.this.currentProcessInstanceId = details.getProcessInstanceId();
                TaskProcessContextPresenter.this.view.setProcessInstanceId(String.valueOf(TaskProcessContextPresenter.this.currentProcessInstanceId));
                TaskProcessContextPresenter.this.view.setProcessId(details.getProcessId());
                TaskProcessContextPresenter.this.view.enablePIDetailsButton(true);
                TaskProcessContextPresenter.this.view.enablePIDetailsButton(TaskProcessContextPresenter.this.enableProcessInstanceDetails);
            }
        })).getTask(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.serverTemplateId = event.getServerTemplateId();
        this.containerId = event.getContainerId();
        this.refreshProcessContextOfTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshProcessContextOfTask();
        }
    }

    public static interface TaskProcessContextView
    extends UberView<TaskProcessContextPresenter> {
        public void displayNotification(String var1);

        public void setProcessInstanceId(String var1);

        public void setProcessId(String var1);

        public void enablePIDetailsButton(boolean var1);
    }
}

