/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.details;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.ga.model.process.DummyProcessPath;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceKey;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.UserTaskSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceStyleEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class ProcessInstanceDetailsPresenter {
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    private String currentDeploymentId;
    private String currentProcessInstanceId;
    private String currentProcessDefId;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private ProcessInstanceDetailsView view;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Event<ProcessInstanceStyleEvent> processInstanceStyleEvent;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    @Inject
    private Caller<VFSService> fileServices;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ProcessInstanceSummary processSelected = null;

    public IsWidget getWidget() {
        return this.view;
    }

    public void refreshProcessInstanceData(String deploymentId, final String processId, String processDefId) {
        this.processSelected = null;
        this.view.getProcessDefinitionIdText().setText(processId);
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

            public void callback(List<NodeInstanceSummary> details) {
                ProcessInstanceDetailsPresenter.this.view.setCurrentActiveNodes(details);
                ProcessInstanceDetailsPresenter.this.view.getCurrentActivitiesListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                for (NodeInstanceSummary nis : details) {
                    safeHtmlBuilder.appendEscapedLines(nis.getTimestamp() + ": " + nis.getId() + " - " + nis.getNodeName() + " (" + nis.getType() + ") \n");
                }
                ProcessInstanceDetailsPresenter.this.view.getCurrentActivitiesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessInstanceActiveNodes(Long.parseLong(processId));
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                ProcessInstanceDetailsPresenter.this.view.getProcessDefinitionIdText().setText(process.getProcessDefId());
                ProcessInstanceDetailsPresenter.this.view.getProcessVersionText().setText(process.getVersion());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessDesc(deploymentId, processDefId);
        ((ProcessInstanceService)this.processInstanceService.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary process) {
                ProcessInstanceDetailsPresenter.this.view.getProcessDeploymentText().setText(process.getDeploymentId());
                ProcessInstanceDetailsPresenter.this.view.getCorrelationKeyText().setText(process.getCorrelationKey());
                if (process.getParentId() > 0L) {
                    ProcessInstanceDetailsPresenter.this.view.getParentProcessInstanceIdText().setText(process.getParentId().toString());
                } else {
                    ProcessInstanceDetailsPresenter.this.view.getParentProcessInstanceIdText().setText(ProcessInstanceDetailsPresenter.this.constants.No_Parent_Process_Instance());
                }
                ProcessInstanceDetailsPresenter.this.view.setProcessInstance(process);
                String statusStr = "Unknown";
                switch (process.getState()) {
                    case 1: {
                        statusStr = "Active";
                        break;
                    }
                    case 3: {
                        statusStr = "Aborted";
                        break;
                    }
                    case 2: {
                        statusStr = "Completed";
                        break;
                    }
                    case 0: {
                        statusStr = "Pending";
                        break;
                    }
                    case 4: {
                        statusStr = "Suspended";
                        break;
                    }
                }
                ProcessInstanceDetailsPresenter.this.view.getActiveTasksListBox().setText("");
                if (process.getActiveTasks() != null && !process.getActiveTasks().isEmpty()) {
                    SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                    for (UserTaskSummary uts : process.getActiveTasks()) {
                        safeHtmlBuilder.appendEscapedLines(uts.getName() + " (" + uts.getStatus() + ")  " + ProcessInstanceDetailsPresenter.this.constants.Owner() + ": " + uts.getOwner() + " \n");
                    }
                    ProcessInstanceDetailsPresenter.this.view.getActiveTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
                ProcessInstanceDetailsPresenter.this.view.getStateText().setText(statusStr);
                ProcessInstanceDetailsPresenter.this.processSelected = process;
                ProcessInstanceDetailsPresenter.this.changeStyleRow(Long.parseLong(processId), ProcessInstanceDetailsPresenter.this.processSelected.getProcessName(), ProcessInstanceDetailsPresenter.this.processSelected.getProcessVersion(), ProcessInstanceDetailsPresenter.this.processSelected.getStartTime());
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new ProcessInstanceKey(Long.valueOf(Long.parseLong(processId))));
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

            public void callback(List<NodeInstanceSummary> details) {
                ProcessInstanceDetailsPresenter.this.view.setCurrentCompletedNodes(details);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessInstanceCompletedNodes(Long.parseLong(processId));
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    ProcessInstanceDetailsPresenter.this.view.setEncodedProcessSource(process.getEncodedProcessSource());
                    if (process.getOriginalPath() != null) {
                        ((VFSService)ProcessInstanceDetailsPresenter.this.fileServices.call((RemoteCallback)new RemoteCallback<Path>(){

                            public void callback(Path processPath) {
                                ProcessInstanceDetailsPresenter.this.view.setProcessAssetPath(processPath);
                                if (ProcessInstanceDetailsPresenter.this.processSelected != null) {
                                    ProcessInstanceDetailsPresenter.this.changeStyleRow(ProcessInstanceDetailsPresenter.this.processSelected.getProcessInstanceId(), ProcessInstanceDetailsPresenter.this.processSelected.getProcessName(), ProcessInstanceDetailsPresenter.this.processSelected.getProcessVersion(), ProcessInstanceDetailsPresenter.this.processSelected.getStartTime());
                                }
                            }
                        })).get(process.getOriginalPath());
                    } else {
                        ProcessInstanceDetailsPresenter.this.view.setProcessAssetPath((Path)new DummyProcessPath(process.getProcessDefId()));
                    }
                    if (ProcessInstanceDetailsPresenter.this.processSelected != null) {
                        ProcessInstanceDetailsPresenter.this.changeStyleRow(ProcessInstanceDetailsPresenter.this.processSelected.getProcessInstanceId(), ProcessInstanceDetailsPresenter.this.processSelected.getProcessName(), ProcessInstanceDetailsPresenter.this.processSelected.getProcessVersion(), ProcessInstanceDetailsPresenter.this.processSelected.getStartTime());
                    }
                } else {
                    ProcessInstanceDetailsPresenter.this.view.setEncodedProcessSource(null);
                    ProcessInstanceDetailsPresenter.this.view.setProcessAssetPath(null);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).getProcessById(deploymentId, processDefId);
    }

    private void changeStyleRow(long processInstanceId, String processDefName, String processDefVersion, Date startTime) {
        this.processInstanceStyleEvent.fire((Object)new ProcessInstanceStyleEvent(Long.valueOf(processInstanceId), processDefName, processDefVersion, startTime));
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.currentDeploymentId = event.getDeploymentId();
        this.currentProcessInstanceId = String.valueOf(event.getProcessInstanceId());
        this.currentProcessDefId = event.getProcessDefId();
        this.refreshProcessInstanceData(this.currentDeploymentId, this.currentProcessInstanceId, this.currentProcessDefId);
    }

    public static interface ProcessInstanceDetailsView
    extends IsWidget {
        public void displayNotification(String var1);

        public HTML getCurrentActivitiesListBox();

        public HTML getActiveTasksListBox();

        public HTML getProcessDefinitionIdText();

        public HTML getStateText();

        public void setProcessInstance(ProcessInstanceSummary var1);

        public HTML getProcessDeploymentText();

        public HTML getProcessVersionText();

        public HTML getCorrelationKeyText();

        public HTML getParentProcessInstanceIdText();

        public void setProcessAssetPath(Path var1);

        public void setCurrentActiveNodes(List<NodeInstanceSummary> var1);

        public void setCurrentCompletedNodes(List<NodeInstanceSummary> var1);

        public void setEncodedProcessSource(String var1);

        public List<NodeInstanceSummary> getCompletedNodes();

        public Path getProcessAssetPath();

        public String getEncodedProcessSource();

        public List<NodeInstanceSummary> getActiveNodes();
    }
}

