/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.SplitDropdownButton;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesWithDetailsRequestEvent;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class ProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter>
implements ProcessInstanceListPresenter.ProcessInstanceListView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private List<ProcessInstanceSummary> selectedProcessInstances = new ArrayList<ProcessInstanceSummary>();
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    private Column actionsColumn;
    private NavLink bulkAbortNavLink;
    private NavLink bulkSignalNavLink;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;

    private void controlBulkOperations() {
        if (this.selectedProcessInstances != null && this.selectedProcessInstances.size() > 0) {
            this.bulkAbortNavLink.setDisabled(false);
            this.bulkSignalNavLink.setDisabled(false);
        } else {
            this.bulkAbortNavLink.setDisabled(true);
            this.bulkSignalNavLink.setDisabled(true);
        }
    }

    public void init(final ProcessInstanceListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(this.constants.Select());
        bannedColumns.add(this.constants.Id());
        bannedColumns.add(this.constants.Name());
        bannedColumns.add(this.constants.Process_Instance_Description());
        bannedColumns.add(this.constants.Actions());
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(this.constants.Select());
        initColumns.add(this.constants.Id());
        initColumns.add(this.constants.Name());
        initColumns.add(this.constants.Process_Instance_Description());
        initColumns.add(this.constants.Version());
        initColumns.add(this.constants.Actions());
        initColumns.add(this.constants.Version());
        final Button button = new Button();
        button.setText("+");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Command addNewGrid = new Command(){

                    public void execute() {
                        HashMap newTabFormValues = ProcessInstanceListViewImpl.this.newTabFilterPopup.getFormValues();
                        final String key = ProcessInstanceListViewImpl.this.getValidKeyForAdditionalListGrid("ProcessInstancesGrid_");
                        ProcessInstanceListViewImpl.this.filterPagedTable.saveNewTabSettings(key, newTabFormValues);
                        final ExtendedPagedTable extendedPagedTable = ProcessInstanceListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        presenter.addDataDisplay((HasData)extendedPagedTable);
                        extendedPagedTable.setDataProvider(presenter.getDataProvider());
                        ProcessInstanceListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                ProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                                ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        ProcessInstanceListViewImpl.this.applyFilterOnPresenter(newTabFormValues);
                    }
                };
                ProcessInstanceListViewImpl.this.createFilterForm();
                ProcessInstanceListViewImpl.this.newTabFilterPopup.show(addNewGrid, ProcessInstanceListViewImpl.this.getMultiGridPreferencesStore());
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("ProcessInstancesGrid", initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.getRightActionsToolbar().clear();
        this.initExtraButtons((ExtendedPagedTable<ProcessInstanceSummary>)extendedPagedTable);
        this.initBulkActions((ExtendedPagedTable<ProcessInstanceSummary>)extendedPagedTable);
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (ProcessInstanceListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(ProcessInstanceListViewImpl.this.selectedStyles);
                    ProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != ProcessInstanceListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(ProcessInstanceListViewImpl.this.selectedStyles);
                    ProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                ProcessInstanceListViewImpl.this.selectedItem = (GenericSummary)ProcessInstanceListViewImpl.this.selectionModel.getLastSelectedObject();
                PlaceStatus status = ProcessInstanceListViewImpl.this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
                if (status == PlaceStatus.CLOSE) {
                    ProcessInstanceListViewImpl.this.placeManager.goTo("Process Instance Details Multi");
                    ProcessInstanceListViewImpl.this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getDeploymentId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessInstanceId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessName(), Integer.valueOf(((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getState())));
                } else if (status == PlaceStatus.OPEN && !close) {
                    ProcessInstanceListViewImpl.this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getDeploymentId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessInstanceId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessId(), ((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getProcessName(), Integer.valueOf(((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem).getState())));
                } else if (status == PlaceStatus.OPEN && close) {
                    ProcessInstanceListViewImpl.this.placeManager.closePlace("Process Instance Details Multi");
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessInstanceSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessInstanceSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessInstanceSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(ProcessInstanceListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(event.getValue())) {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.remove(event.getValue());
                            input.setChecked(false);
                        }
                        ProcessInstanceListViewImpl.this.controlBulkOperations();
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        Column checkColumn = this.initChecksColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column processNameColumn = this.initProcessNameColumn();
        Column processInitiatorColumn = this.initInitiatorColumn();
        Column processVersionColumn = this.initProcessVersionColumn();
        Column processStateColumn = this.initProcessStateColumn();
        Column startTimeColumn = this.initStartDateColumn();
        Column descriptionColumn = this.initDescriptionColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(checkColumn, this.constants.Select()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(processInitiatorColumn, this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(processVersionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(processStateColumn, this.constants.State()));
        columnMetas.add(new ColumnMeta(startTimeColumn, this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private void createFilterForm() {
        HashMap<String, String> stateListBoxInfo = new HashMap<String, String>();
        stateListBoxInfo.put(String.valueOf(1), Constants.INSTANCE.Active());
        stateListBoxInfo.put(String.valueOf(2), Constants.INSTANCE.Completed());
        stateListBoxInfo.put(String.valueOf(3), Constants.INSTANCE.Aborted());
        stateListBoxInfo.put(String.valueOf(0), Constants.INSTANCE.Pending());
        stateListBoxInfo.put(String.valueOf(4), Constants.INSTANCE.Suspended());
        this.newTabFilterPopup.init();
        this.newTabFilterPopup.addListBoxToFilter(Constants.INSTANCE.State(), ProcessInstanceListPresenter.FILTER_STATE_PARAM_NAME, true, stateListBoxInfo);
        this.newTabFilterPopup.addTextBoxToFilter(Constants.INSTANCE.Process_Definitions(), ProcessInstanceListPresenter.FILTER_PROCESS_DEFINITION_PARAM_NAME, "");
        this.newTabFilterPopup.addTextBoxToFilter(Constants.INSTANCE.Initiator(), ProcessInstanceListPresenter.FILTER_INITIATOR_PARAM_NAME);
    }

    public void initExtraButtons(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        Button newInstanceButton = new Button();
        newInstanceButton.setTitle(this.constants.New_Instance());
        newInstanceButton.setIcon(IconType.PLUS_SIGN);
        newInstanceButton.setTitle(Constants.INSTANCE.New_Instance());
        newInstanceButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ProcessInstanceListViewImpl.this.newProcessInstancePopup.show();
            }
        });
        extendedPagedTable.getRightActionsToolbar().add((Widget)newInstanceButton);
    }

    private void initBulkActions(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        SplitDropdownButton bulkActions = new SplitDropdownButton();
        bulkActions.setText(this.constants.Bulk_Actions());
        this.bulkAbortNavLink = new NavLink(this.constants.Bulk_Abort());
        this.bulkAbortNavLink.setIcon(IconType.REMOVE_SIGN);
        this.bulkAbortNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkAbort(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        this.bulkSignalNavLink = new NavLink(this.constants.Bulk_Signal());
        this.bulkSignalNavLink.setIcon(IconType.BELL);
        this.bulkSignalNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkSignal(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        bulkActions.add((Widget)this.bulkAbortNavLink);
        bulkActions.add((Widget)this.bulkSignalNavLink);
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
        this.controlBulkOperations();
    }

    private Column initProcessInstanceIdColumn() {
        Column<ProcessInstanceSummary, String> processInstanceIdColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return String.valueOf(object.getProcessInstanceId());
            }
        };
        processInstanceIdColumn.setSortable(true);
        processInstanceIdColumn.setDataStoreName("log.processInstanceId");
        return processInstanceIdColumn;
    }

    private Column initProcessNameColumn() {
        Column<ProcessInstanceSummary, String> processNameColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDataStoreName("log.processName");
        return processNameColumn;
    }

    private Column initInitiatorColumn() {
        Column<ProcessInstanceSummary, String> processInitiatorColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getInitiator();
            }
        };
        processInitiatorColumn.setSortable(true);
        processInitiatorColumn.setDataStoreName("log.identity");
        return processInitiatorColumn;
    }

    private Column initProcessVersionColumn() {
        Column<ProcessInstanceSummary, String> processVersionColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessVersion();
            }
        };
        processVersionColumn.setSortable(true);
        processVersionColumn.setDataStoreName("log.processVersion");
        return processVersionColumn;
    }

    private Column initProcessStateColumn() {
        Column<ProcessInstanceSummary, String> processStateColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                String statusStr = ProcessInstanceListViewImpl.this.constants.Unknown();
                switch (object.getState()) {
                    case 1: {
                        statusStr = ProcessInstanceListViewImpl.this.constants.Active();
                        break;
                    }
                    case 3: {
                        statusStr = ProcessInstanceListViewImpl.this.constants.Aborted();
                        break;
                    }
                    case 2: {
                        statusStr = ProcessInstanceListViewImpl.this.constants.Completed();
                        break;
                    }
                    case 0: {
                        statusStr = ProcessInstanceListViewImpl.this.constants.Pending();
                        break;
                    }
                    case 4: {
                        statusStr = ProcessInstanceListViewImpl.this.constants.Suspended();
                        break;
                    }
                }
                return statusStr;
            }
        };
        processStateColumn.setSortable(true);
        processStateColumn.setDataStoreName("log.status");
        return processStateColumn;
    }

    private Column initStartDateColumn() {
        Column<ProcessInstanceSummary, String> startTimeColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                Date startTime = object.getStartTime();
                if (startTime != null) {
                    DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                    return format.format(startTime);
                }
                return "";
            }
        };
        startTimeColumn.setSortable(true);
        startTimeColumn.setDataStoreName("log.start");
        return startTimeColumn;
    }

    private Column initActionsColumn() {
        LinkedList<Object> cells = new LinkedList<Object>();
        cells.add(new SignalActionHasCell(this.constants.Signal(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
                placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
                ProcessInstanceListViewImpl.this.placeManager.goTo((PlaceRequest)placeRequestImpl);
            }
        }));
        cells.add(new AbortActionHasCell(this.constants.Abort(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                if (Window.confirm((String)"Are you sure that you want to abort the process instance?")) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).abortProcessInstance(processInstance.getProcessInstanceId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)cell){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
                return object;
            }
        };
        return actionsColumn;
    }

    private Column initChecksColumn() {
        Column<ProcessInstanceSummary, Boolean> checkColumn = new Column<ProcessInstanceSummary, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(ProcessInstanceSummary object) {
                return ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(object);
            }
        };
        return checkColumn;
    }

    private Column initDescriptionColumn() {
        Column<ProcessInstanceSummary, String> descriptionColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessInstanceDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName("log.processInstanceDescription");
        return descriptionColumn;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstancesWithDetailsRequestEvent event) {
        this.placeManager.goTo("Process Instance Details Multi");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(event.getDeploymentId(), event.getProcessInstanceId(), event.getProcessDefId(), event.getProcessDefName(), event.getProcessInstanceStatus()));
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            ((ProcessInstanceListPresenter)this.presenter).refreshGrid();
        }
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ArrayList<String> states = new ArrayList<String>();
        states.add(String.valueOf(1));
        this.initTabFilter(preferences, "ProcessInstancesGrid_0", Constants.INSTANCE.Active(), "Filter " + Constants.INSTANCE.Active(), states, "", "");
        states = new ArrayList();
        states.add(String.valueOf(2));
        this.initTabFilter(preferences, "ProcessInstancesGrid_1", Constants.INSTANCE.Completed(), "Filter " + Constants.INSTANCE.Completed(), states, "", "");
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.applyFilterOnPresenter("ProcessInstancesGrid_1");
    }

    private void initTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String processDefinition, String initiator) {
        ExtendedPagedTable extendedPagedTable;
        HashMap<String, Object> tabSettingsValues = new HashMap<String, Object>();
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tabName);
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tabDesc);
        tabSettingsValues.put(ProcessInstanceListPresenter.FILTER_STATE_PARAM_NAME, states);
        tabSettingsValues.put(ProcessInstanceListPresenter.FILTER_PROCESS_DEFINITION_PARAM_NAME, processDefinition);
        tabSettingsValues.put(ProcessInstanceListPresenter.FILTER_INITIATOR_PARAM_NAME, initiator);
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(preferences, key);
        ((ProcessInstanceListPresenter)this.presenter).addDataDisplay((HasData)extendedPagedTable);
        extendedPagedTable.setDataProvider(((ProcessInstanceListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                ProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        List states = (List)params.get(ProcessInstanceListPresenter.FILTER_STATE_PARAM_NAME);
        ArrayList<Integer> statesInteger = new ArrayList<Integer>();
        for (String state : states) {
            statesInteger.add(Integer.parseInt(state));
        }
        ((ProcessInstanceListPresenter)this.presenter).filterGrid(statesInteger, (String)params.get(ProcessInstanceListPresenter.FILTER_PROCESS_DEFINITION_PARAM_NAME), (String)params.get(ProcessInstanceListPresenter.FILTER_INITIATOR_PARAM_NAME));
    }

    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    private class SignalActionHasCell
    implements HasCell<ProcessInstanceSummary, ProcessInstanceSummary> {
        private ActionCell<ProcessInstanceSummary> cell;

        public SignalActionHasCell(String text, ActionCell.Delegate<ProcessInstanceSummary> delegate) {
            this.cell = new ActionCell<ProcessInstanceSummary>(text, delegate){

                public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
                    if (value.getState() == 1) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + ProcessInstanceListViewImpl.this.constants.Signal() + "'>" + ProcessInstanceListViewImpl.this.constants.Signal() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<ProcessInstanceSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<ProcessInstanceSummary, ProcessInstanceSummary> getFieldUpdater() {
            return null;
        }

        public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
            return object;
        }
    }

    private class AbortActionHasCell
    implements HasCell<ProcessInstanceSummary, ProcessInstanceSummary> {
        private ActionCell<ProcessInstanceSummary> cell;

        public AbortActionHasCell(String text, ActionCell.Delegate<ProcessInstanceSummary> delegate) {
            this.cell = new ActionCell<ProcessInstanceSummary>(text, delegate){

                public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
                    if (value.getState() == 1) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + ProcessInstanceListViewImpl.this.constants.Abort() + "'>" + ProcessInstanceListViewImpl.this.constants.Abort() + "</a>&nbsp;");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<ProcessInstanceSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<ProcessInstanceSummary, ProcessInstanceSummary> getFieldUpdater() {
            return null;
        }

        public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, ProcessInstanceListViewImpl> {
    }
}

