/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.log;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RequiresResize;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.client.util.LogUtils;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="RuntimeLogViewImpl.html")
public class RuntimeLogViewImpl
extends Composite
implements RequiresResize,
RuntimeLogPresenter.RuntimeLogView {
    private RuntimeLogPresenter presenter;
    private LogUtils.LogOrder logOrder = LogUtils.LogOrder.ASC;
    private LogUtils.LogType logType = LogUtils.LogType.BUSINESS;
    @Inject
    @DataField
    public HTML logTextArea;
    @Inject
    @DataField
    public Label logTextLabel;
    @Inject
    @DataField
    public Button showBusinessLogButton;
    @Inject
    @DataField
    public Button showTechnicalLogButton;
    @Inject
    @DataField
    public Button showAscLogButton;
    @Inject
    @DataField
    public Button showDescLogButton;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void onResize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int height = RuntimeLogViewImpl.this.getOffsetHeight();
                GWT.log((String)("RuntimeLogViewImpl height" + height));
                RuntimeLogViewImpl.this.logTextLabel.setHeight(height + "px");
            }
        });
    }

    @Override
    public void init(RuntimeLogPresenter presenter) {
        this.presenter = presenter;
        this.logTextLabel.setText(this.constants.Process_Instance_Log());
        this.setFilters(this.showBusinessLogButton, this.constants.Business_Log(), LogUtils.LogType.BUSINESS);
        this.setFilters(this.showTechnicalLogButton, this.constants.Technical_Log(), LogUtils.LogType.TECHNICAL);
        this.setOrder(this.showAscLogButton, this.constants.Asc_Log_Order(), LogUtils.LogOrder.ASC);
        this.setOrder(this.showDescLogButton, this.constants.Desc_Log_Order(), LogUtils.LogOrder.DESC);
    }

    private void setFilters(Button button, String description, final LogUtils.LogType logType) {
        button.setSize(ButtonSize.SMALL);
        button.setText(description);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuntimeLogViewImpl.this.setActiveLogTypeButton(logType);
                RuntimeLogViewImpl.this.getInstanceData();
            }
        });
    }

    private void setOrder(Button button, String description, final LogUtils.LogOrder logOrder) {
        button.setSize(ButtonSize.SMALL);
        button.setText(description);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuntimeLogViewImpl.this.setActiveLogOrderButton(logOrder);
                RuntimeLogViewImpl.this.getInstanceData();
            }
        });
    }

    public void getInstanceData() {
        this.presenter.refreshProcessInstanceData(this.logOrder, this.logType);
    }

    @Override
    public HTML getLogTextArea() {
        return this.logTextArea;
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void setActiveLogTypeButton(LogUtils.LogType logType) {
        this.showBusinessLogButton.setStyleName("btn btn-small");
        this.showTechnicalLogButton.setStyleName("btn btn-small");
        this.logType = logType;
        switch (logType) {
            case TECHNICAL: {
                this.showTechnicalLogButton.setStyleName(this.showTechnicalLogButton.getStyleName() + " active");
                break;
            }
            case BUSINESS: {
                this.showBusinessLogButton.setStyleName(this.showBusinessLogButton.getStyleName() + " active");
            }
        }
    }

    public void setActiveLogOrderButton(LogUtils.LogOrder logOrder) {
        this.showAscLogButton.setStyleName("btn btn-small");
        this.showDescLogButton.setStyleName("btn btn-small");
        this.logOrder = logOrder;
        switch (logOrder) {
            case ASC: {
                this.showAscLogButton.setStyleName(this.showAscLogButton.getStyleName() + " active");
                break;
            }
            case DESC: {
                this.showDescLogButton.setStyleName(this.showDescLogButton.getStyleName() + " active");
            }
        }
    }
}

