/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.variables.history;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.RangeChangeEvent;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.client.util.DataGridUtils;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.ext.widgets.common.client.tables.PopoverTextCell;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class VariableHistoryPopup
extends BaseModal {
    @UiField
    public FormControlStatic variableNameTextBox;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @UiField
    public DataGrid<ProcessVariableSummary> processVarListGrid;
    @UiField
    public Pagination pagination;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    private ListDataProvider<ProcessVariableSummary> dataProvider = new ListDataProvider();
    public SimplePager pager;
    private ColumnSortEvent.ListHandler<ProcessVariableSummary> sortHandler;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private long processInstanceId;

    public VariableHistoryPopup() {
        this.setTitle(Constants.INSTANCE.History());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Ok(), new Command(){

            public void execute() {
                VariableHistoryPopup.this.closePopup();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void init() {
        this.pager = new SimplePager(SimplePager.TextLocation.CENTER, false, true);
        this.pagination.rebuild(this.pager);
        this.processVarListGrid.setEmptyTableWidget((Widget)new HTMLPanel(Constants.INSTANCE.No_History_For_This_Variable()));
        this.sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        this.processVarListGrid.addColumnSortHandler(this.sortHandler);
        this.pager.setDisplay(this.processVarListGrid);
        this.pager.setPageSize(5);
        this.processVarListGrid.addRangeChangeHandler(new RangeChangeEvent.Handler(){

            public void onRangeChange(RangeChangeEvent event) {
                VariableHistoryPopup.this.pagination.rebuild(VariableHistoryPopup.this.pager);
            }
        });
        Column<ProcessVariableSummary, String> valueColumn = new Column<ProcessVariableSummary, String>((Cell)new PopoverTextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getNewValue();
            }
        };
        this.processVarListGrid.addColumn((Column)valueColumn, Constants.INSTANCE.Value());
        valueColumn.setSortable(true);
        this.sortHandler.setComparator((Column)valueColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                return o1.getNewValue().compareTo(o2.getNewValue());
            }
        });
        Column<ProcessVariableSummary, String> oldValueColumn = new Column<ProcessVariableSummary, String>((Cell)new PopoverTextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getOldValue();
            }
        };
        oldValueColumn.setSortable(true);
        this.processVarListGrid.addColumn((Column)oldValueColumn, Constants.INSTANCE.Previous_Value());
        this.sortHandler.setComparator((Column)oldValueColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                return o1.getOldValue().compareTo(o2.getOldValue());
            }
        });
        Column<ProcessVariableSummary, String> lastTimeChangedColumn = new Column<ProcessVariableSummary, String>((Cell)new TextCell()){

            public void render(Cell.Context context, ProcessVariableSummary variableSummary, SafeHtmlBuilder sb) {
                Date lastModification = new Date(variableSummary.getTimestamp());
                DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                String title = format.format(lastModification);
                sb.append(DataGridUtils.createDivStart(title));
                super.render(context, (Object)variableSummary, sb);
                sb.append(DataGridUtils.createDivEnd());
            }

            public String getValue(ProcessVariableSummary variable) {
                Date lastModification = new Date(variable.getTimestamp());
                DateTimeFormat format = DateTimeFormat.getFormat((String)"dd/MM/yyyy HH:mm");
                return DataGridUtils.trimToColumnWidth(VariableHistoryPopup.this.processVarListGrid, this, format.format(lastModification));
            }
        };
        lastTimeChangedColumn.setSortable(true);
        this.sortHandler.setComparator((Column)lastTimeChangedColumn, (Comparator)new Comparator<ProcessVariableSummary>(){

            @Override
            public int compare(ProcessVariableSummary o1, ProcessVariableSummary o2) {
                return new Long(o1.getTimestamp()).compareTo(new Long(o2.getTimestamp()));
            }
        });
        this.processVarListGrid.addColumn((Column)lastTimeChangedColumn, Constants.INSTANCE.Last_Modification());
        this.dataProvider.addDataDisplay(this.processVarListGrid);
    }

    public void show(long processInstanceId, String variableId) {
        this.processInstanceId = processInstanceId;
        this.variableNameTextBox.setText(variableId);
        this.cleanForm();
        super.show();
    }

    public void cleanForm() {
        this.cleanErrorMessages();
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent shownEvent) {
                VariableHistoryPopup.this.refreshTable();
            }
        });
        this.loadVariableHistory();
    }

    private void cleanErrorMessages() {
        this.errorMessages.setText("");
        this.errorMessagesGroup.setValidationState(ValidationState.NONE);
    }

    public void closePopup() {
        this.hide();
    }

    public void refreshTable() {
        this.processVarListGrid.getColumnSortList().push(new ColumnSortList.ColumnSortInfo(this.processVarListGrid.getColumn(2), false));
        this.processVarListGrid.redraw();
    }

    public void loadVariableHistory() {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<ProcessVariableSummary>>(){

            public void callback(List<ProcessVariableSummary> processInstances) {
                VariableHistoryPopup.this.dataProvider.getList().clear();
                VariableHistoryPopup.this.dataProvider.getList().addAll(processInstances);
                VariableHistoryPopup.this.dataProvider.flush();
                VariableHistoryPopup.this.pagination.rebuild(VariableHistoryPopup.this.pager);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                VariableHistoryPopup.this.errorMessages.setText(throwable.getMessage());
                VariableHistoryPopup.this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
                return true;
            }
        })).getVariableHistory(this.processInstanceId, this.variableNameTextBox.getText());
    }

    static interface Binder
    extends UiBinder<Widget, VariableHistoryPopup> {
    }
}

