/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.details.multi;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jbpm.console.ng.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.details.multi.ProcessInstanceDetailsMultiPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.console.ng.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsMultiPresenterTest {
    private static final Long PI_ID = 1L;
    private static final String PI_DEPLOYMENTID = "deploymentIdTest";
    private static final String PI_PROCESS_DEF_ID = "processDefIdTest";
    private static final String PI_PROCESS_DEF_NAME = "processDefNameTest";
    @Mock
    public ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView view;
    @Mock
    private ProcessInstanceDetailsPresenter detailsPresenter;
    @Mock
    private ProcessVariableListPresenter variableListPresenter;
    @Mock
    private ProcessDocumentListPresenter documentListPresenter;
    @Mock
    private RuntimeLogPresenter runtimeLogPresenter;
    @Spy
    Event<ProcessInstanceSelectionEvent> processInstanceSelected = new EventSourceMock();
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    @InjectMocks
    private ProcessInstanceDetailsMultiPresenter presenter;

    @Before
    public void setupMocks() {
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstanceSelected)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENTID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), true));
        ((ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        Assert.assertTrue((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENTID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), false));
        ((ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView)Mockito.verify((Object)this.view)).displayAllTabs();
        Assert.assertFalse((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }
}

