/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.variables.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.service.ProcessVariablesService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessVariableListPresenterTest {
    @Mock
    ProcessVariableListPresenter.ProcessVariableListView view;
    Caller<ProcessVariablesService> variablesServicesCaller;
    @Mock
    ProcessVariablesService processVariablesService;
    Caller<DataServiceEntryPoint> dataServicesCaller;
    @Mock
    DataServiceEntryPoint dataServiceEntryPoint;
    ProcessVariableListPresenter presenter;

    @Before
    public void setup() {
        this.variablesServicesCaller = new CallerMock((Object)this.processVariablesService);
        this.dataServicesCaller = new CallerMock((Object)this.dataServiceEntryPoint);
        this.presenter = new ProcessVariableListPresenter(this.view, this.variablesServicesCaller, this.dataServicesCaller);
    }

    @Test
    public void testLoadVariableHistory() {
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        String variableName = "variable";
        long processInstanceId = 1L;
        ProcessVariableSummary summary = new ProcessVariableSummary("variable", "variableInstanceId", 1L, "oldValue", "newValue", System.currentTimeMillis(), "type");
        List<ProcessVariableSummary> summaries = Arrays.asList(summary);
        Mockito.when((Object)this.dataServiceEntryPoint.getVariableHistory(1L, "variable")).thenReturn(summaries);
        ProcessInstanceSelectionEvent event = new ProcessInstanceSelectionEvent("deploymentId", Long.valueOf(1L), "processDefId", "processDefName", Integer.valueOf(1));
        this.presenter.onProcessInstanceSelectionEvent(event);
        this.presenter.loadVariableHistory(callback, "variable");
        ((ParameterizedCommand)Mockito.verify((Object)callback)).execute(summaries);
    }
}

