/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.details.advance;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ga.model.process.DummyProcessPath;
import org.jbpm.console.ng.ga.service.ItemKey;
import org.jbpm.console.ng.ht.model.TaskDefSummary;
import org.jbpm.console.ng.pr.client.editors.definition.details.BaseProcessDefDetailsPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.service.ProcessDefinitionService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class AdvancedViewProcessDefDetailsPresenter
extends BaseProcessDefDetailsPresenter {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private AdvancedProcessDefDetailsView view;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Caller<ProcessDefinitionService> processDefService;
    @Inject
    private Caller<VFSService> fileServices;

    @Override
    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    protected void refreshView(String processId, String deploymentId) {
        this.view.getProcessIdText().setText(processId);
        this.view.getDeploymentIdText().setText(deploymentId);
    }

    private void refreshServiceTasks(String deploymentId, String processId) {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

            public void callback(Map<String, String> services) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getProcessServicesListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (services.keySet().isEmpty()) {
                    safeHtmlBuilder.appendEscaped(AdvancedViewProcessDefDetailsPresenter.this.constants.NoServicesRequiredForThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessServicesListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessServicesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (String key : services.keySet()) {
                        safeHtmlBuilder.appendEscapedLines(key + " - " + services.get(key) + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessServicesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getServiceTasks(deploymentId, processId);
    }

    private void refreshProcessItems(String deploymentId, String processId) {
        ((ProcessDefinitionService)this.processDefService.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    AdvancedViewProcessDefDetailsPresenter.this.view.setEncodedProcessSource(process.getEncodedProcessSource());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessNameText().setText(process.getName());
                    if (process.getOriginalPath() != null) {
                        ((VFSService)AdvancedViewProcessDefDetailsPresenter.this.fileServices.call((RemoteCallback)new RemoteCallback<Path>(){

                            public void callback(Path processPath) {
                                AdvancedViewProcessDefDetailsPresenter.this.view.setProcessAssetPath(processPath);
                            }
                        })).get(process.getOriginalPath());
                    } else {
                        AdvancedViewProcessDefDetailsPresenter.this.view.setProcessAssetPath((Path)new DummyProcessPath(process.getProcessDefId()));
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.changeStyleRow(process.getName(), process.getVersion());
                } else {
                    AdvancedViewProcessDefDetailsPresenter.this.view.setEncodedProcessSource(null);
                    AdvancedViewProcessDefDetailsPresenter.this.view.setProcessAssetPath(null);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getItem((ItemKey)new ProcessDefinitionKey(deploymentId, processId));
    }

    private void refreshReusableSubProcesses(String deploymentId, String processId) {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Collection<String>>(){

            public void callback(Collection<String> subprocesses) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getSubprocessListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (subprocesses.isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(AdvancedViewProcessDefDetailsPresenter.this.constants.NoSubprocessesRequiredByThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getSubprocessListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getSubprocessListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (String key : subprocesses) {
                        safeHtmlBuilder.appendEscapedLines(key + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getSubprocessListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getReusableSubProcesses(deploymentId, processId);
    }

    private void refreshRequiredInputData(String deploymentId, String processId) {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

            public void callback(Map<String, String> inputs) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getProcessDataListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (inputs.keySet().isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(AdvancedViewProcessDefDetailsPresenter.this.constants.NoProcessVariablesDefinedForThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessDataListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessDataListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (String key : inputs.keySet()) {
                        safeHtmlBuilder.appendEscapedLines(key + " - " + inputs.get(key) + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getProcessDataListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getRequiredInputData(deploymentId, processId);
    }

    private void refreshAssociatedEntities(String deploymentId, String processId) {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<Map<String, Collection<String>>>(){

            public void callback(Map<String, Collection<String>> entities) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getUsersGroupsListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (entities.keySet().isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(AdvancedViewProcessDefDetailsPresenter.this.constants.NoUserOrGroupUsedInThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getUsersGroupsListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getUsersGroupsListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (String key : entities.keySet()) {
                        StringBuffer names = new StringBuffer();
                        Collection<String> entityNames = entities.get(key);
                        if (entityNames != null) {
                            for (String entity : entityNames) {
                                names.append("'" + entity + "' ");
                            }
                        }
                        safeHtmlBuilder.appendEscapedLines(names + " - " + key + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getUsersGroupsListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getAssociatedEntities(deploymentId, processId);
    }

    private void refreshTaskDef(String deploymentId, String processId) {
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<TaskDefSummary>>(){

            public void callback(List<TaskDefSummary> tasks) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getNroOfHumanTasksText().setText(String.valueOf(tasks.size()));
                AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setText("");
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (tasks.isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(AdvancedViewProcessDefDetailsPresenter.this.constants.NoUserTasksDefinedInThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (TaskDefSummary t : tasks) {
                        safeHtmlBuilder.appendEscapedLines(t.getName() + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)AdvancedViewProcessDefDetailsPresenter.this.constants.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).getAllTasksDef(deploymentId, processId);
    }

    @Override
    protected void refreshProcessDef(String deploymentId, String processId) {
        this.refreshTaskDef(deploymentId, processId);
        this.refreshAssociatedEntities(deploymentId, processId);
        this.refreshRequiredInputData(deploymentId, processId);
        this.refreshReusableSubProcesses(deploymentId, processId);
        this.refreshProcessItems(deploymentId, processId);
        this.refreshServiceTasks(deploymentId, processId);
    }

    public static interface AdvancedProcessDefDetailsView
    extends BaseProcessDefDetailsPresenter.BaseProcessDefDetailsView {
        public HTML getNroOfHumanTasksText();

        public HTML getHumanTasksListBox();

        public HTML getUsersGroupsListBox();

        public HTML getProcessDataListBox();

        public HTML getProcessServicesListBox();

        public HTML getSubprocessListBox();
    }
}

