/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.dash;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.console.ng.df.client.list.base.DataSetEditorManager;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractMultiGridView;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceSummaryActionCell;
import org.jbpm.console.ng.pr.client.editors.instance.list.dash.DataSetProcessInstanceListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class DataSetProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, DataSetProcessInstanceListPresenter>
implements DataSetProcessInstanceListPresenter.DataSetProcessInstanceListView {
    public static final String PROCESS_INSTANCES_LIST_PREFIX = "DS_ProcessInstancesGrid";
    public static final String PROCESS_INSTANCES_DATASET_ID = "jbpmProcessInstances";
    public static final String COL_ID_SELECT = "Select";
    public static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = (Constants)GWT.create(Constants.class);
    private List<ProcessInstanceSummary> selectedProcessInstances = new ArrayList<ProcessInstanceSummary>();
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private NewTabFilterPopup newTabFilterPopup;
    @Inject
    private DataSetEditorManager dataSetEditorManager;
    private Column actionsColumn;
    private AnchorListItem bulkAbortNavLink;
    private AnchorListItem bulkSignalNavLink;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;

    private void controlBulkOperations() {
        if (this.selectedProcessInstances != null && this.selectedProcessInstances.size() > 0) {
            this.bulkAbortNavLink.setEnabled(true);
            this.bulkSignalNavLink.setEnabled(true);
        } else {
            this.bulkAbortNavLink.setEnabled(false);
            this.bulkSignalNavLink.setEnabled(false);
        }
    }

    public void init(final DataSetProcessInstanceListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_SELECT);
        bannedColumns.add("processInstanceId");
        bannedColumns.add("processName");
        bannedColumns.add("processInstanceDescription");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_SELECT);
        initColumns.add("processInstanceId");
        initColumns.add("processName");
        initColumns.add("processInstanceDescription");
        initColumns.add("processVersion");
        initColumns.add(COL_ID_ACTIONS);
        final Button button = new Button();
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = DataSetProcessInstanceListViewImpl.this.getValidKeyForAdditionalListGrid("DS_ProcessInstancesGrid_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = DataSetProcessInstanceListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        DataSetProcessInstanceListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                DataSetProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                                DataSetProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        DataSetProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = DataSetProcessInstanceListViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                DataSetProcessInstanceListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(DataSetProcessInstanceListViewImpl.this.filterPagedTable, Constants.INSTANCE.New_Process_InstanceList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(PROCESS_INSTANCES_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.getRightActionsToolbar().clear();
        this.initExtraButtons(extendedPagedTable);
        this.initBulkActions((ExtendedPagedTable<ProcessInstanceSummary>)extendedPagedTable);
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DataSetProcessInstanceListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(DataSetProcessInstanceListViewImpl.this.selectedStyles);
                    DataSetProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != DataSetProcessInstanceListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(DataSetProcessInstanceListViewImpl.this.selectedStyles);
                    DataSetProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                DataSetProcessInstanceListViewImpl.this.selectedItem = (GenericSummary)DataSetProcessInstanceListViewImpl.this.selectionModel.getLastSelectedObject();
                PlaceStatus status = DataSetProcessInstanceListViewImpl.this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
                if (status == PlaceStatus.CLOSE) {
                    DataSetProcessInstanceListViewImpl.this.placeManager.goTo("Process Instance Details Multi");
                    DataSetProcessInstanceListViewImpl.this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getDeploymentId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessInstanceId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessName(), Integer.valueOf(((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getState())));
                } else if (status == PlaceStatus.OPEN && !close) {
                    DataSetProcessInstanceListViewImpl.this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getDeploymentId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessInstanceId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessId(), ((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getProcessName(), Integer.valueOf(((ProcessInstanceSummary)DataSetProcessInstanceListViewImpl.this.selectedItem).getState())));
                } else if (status == PlaceStatus.OPEN && close) {
                    DataSetProcessInstanceListViewImpl.this.placeManager.closePlace("Process Instance Details Multi");
                }
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessInstanceSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessInstanceSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessInstanceSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(DataSetProcessInstanceListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.contains(event.getValue())) {
                            DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.remove(event.getValue());
                            input.setChecked(false);
                        }
                        DataSetProcessInstanceListViewImpl.this.controlBulkOperations();
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        Column checkColumn = this.initChecksColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column processNameColumn = this.initProcessNameColumn();
        Column processInitiatorColumn = this.initInitiatorColumn();
        Column processVersionColumn = this.initProcessVersionColumn();
        Column processStateColumn = this.initProcessStateColumn();
        Column startTimeColumn = this.initStartDateColumn();
        Column descriptionColumn = this.initDescriptionColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(checkColumn, this.constants.Select()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(processInitiatorColumn, this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(processVersionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(processStateColumn, this.constants.State()));
        columnMetas.add(new ColumnMeta(startTimeColumn, this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initBulkActions(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        this.bulkAbortNavLink = new AnchorListItem(this.constants.Bulk_Abort());
        this.bulkSignalNavLink = new AnchorListItem(this.constants.Bulk_Signal());
        ButtonGroup bulkActions = new ButtonGroup(){
            {
                this.add((Widget)new Button(DataSetProcessInstanceListViewImpl.this.constants.Bulk_Actions()){
                    {
                        this.setDataToggle(Toggle.DROPDOWN);
                        this.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
                    }
                });
                this.add((Widget)new DropDownMenu(){
                    {
                        this.addStyleName("dropdown-menu-right");
                        this.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
                        this.add((Widget)DataSetProcessInstanceListViewImpl.this.bulkAbortNavLink);
                        this.add((Widget)DataSetProcessInstanceListViewImpl.this.bulkSignalNavLink);
                    }
                });
            }
        };
        this.bulkAbortNavLink.setIcon(IconType.BAN);
        this.bulkAbortNavLink.setIconFixedWidth(true);
        this.bulkAbortNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((DataSetProcessInstanceListPresenter)DataSetProcessInstanceListViewImpl.this.presenter).bulkAbort(DataSetProcessInstanceListViewImpl.this.selectedProcessInstances);
                DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        this.bulkSignalNavLink.setIcon(IconType.BELL);
        this.bulkSignalNavLink.setIconFixedWidth(true);
        this.bulkSignalNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((DataSetProcessInstanceListPresenter)DataSetProcessInstanceListViewImpl.this.presenter).bulkSignal(DataSetProcessInstanceListViewImpl.this.selectedProcessInstances);
                DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
        this.controlBulkOperations();
    }

    private Column initProcessInstanceIdColumn() {
        Column<ProcessInstanceSummary, String> processInstanceIdColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return String.valueOf(object.getProcessInstanceId());
            }
        };
        processInstanceIdColumn.setSortable(true);
        processInstanceIdColumn.setDataStoreName("processInstanceId");
        return processInstanceIdColumn;
    }

    private Column initProcessNameColumn() {
        Column<ProcessInstanceSummary, String> processNameColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDataStoreName("processName");
        return processNameColumn;
    }

    private Column initInitiatorColumn() {
        Column<ProcessInstanceSummary, String> processInitiatorColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getInitiator();
            }
        };
        processInitiatorColumn.setSortable(true);
        processInitiatorColumn.setDataStoreName("user_identity");
        return processInitiatorColumn;
    }

    private Column initProcessVersionColumn() {
        Column<ProcessInstanceSummary, String> processVersionColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessVersion();
            }
        };
        processVersionColumn.setSortable(true);
        processVersionColumn.setDataStoreName("processVersion");
        return processVersionColumn;
    }

    private Column initProcessStateColumn() {
        Column<ProcessInstanceSummary, String> processStateColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                String statusStr = DataSetProcessInstanceListViewImpl.this.constants.Unknown();
                switch (object.getState()) {
                    case 1: {
                        statusStr = DataSetProcessInstanceListViewImpl.this.constants.Active();
                        break;
                    }
                    case 3: {
                        statusStr = DataSetProcessInstanceListViewImpl.this.constants.Aborted();
                        break;
                    }
                    case 2: {
                        statusStr = DataSetProcessInstanceListViewImpl.this.constants.Completed();
                        break;
                    }
                    case 0: {
                        statusStr = DataSetProcessInstanceListViewImpl.this.constants.Pending();
                        break;
                    }
                    case 4: {
                        statusStr = DataSetProcessInstanceListViewImpl.this.constants.Suspended();
                        break;
                    }
                }
                return statusStr;
            }
        };
        processStateColumn.setSortable(true);
        processStateColumn.setDataStoreName("status");
        return processStateColumn;
    }

    private Column initStartDateColumn() {
        Column<ProcessInstanceSummary, String> startTimeColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getStartTime());
            }
        };
        startTimeColumn.setSortable(true);
        startTimeColumn.setDataStoreName("start_date");
        return startTimeColumn;
    }

    private Column initActionsColumn() {
        LinkedList<ProcessInstanceSummaryActionCell> cells = new LinkedList<ProcessInstanceSummaryActionCell>();
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Signal(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
                placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
                DataSetProcessInstanceListViewImpl.this.placeManager.goTo((PlaceRequest)placeRequestImpl);
            }
        }));
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Abort(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                if (Window.confirm((String)DataSetProcessInstanceListViewImpl.this.constants.Abort_Process_Instances())) {
                    ((DataSetProcessInstanceListPresenter)DataSetProcessInstanceListViewImpl.this.presenter).abortProcessInstance(processInstance.getProcessInstanceId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)cell){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    private Column initChecksColumn() {
        Column<ProcessInstanceSummary, Boolean> checkColumn = new Column<ProcessInstanceSummary, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(ProcessInstanceSummary object) {
                return DataSetProcessInstanceListViewImpl.this.selectedProcessInstances.contains(object);
            }
        };
        checkColumn.setDataStoreName(COL_ID_SELECT);
        return checkColumn;
    }

    private Column initDescriptionColumn() {
        Column<ProcessInstanceSummary, String> descriptionColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getProcessInstanceDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName("processInstanceDescription");
        return descriptionColumn;
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            ((DataSetProcessInstanceListPresenter)this.presenter).refreshGrid();
        }
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ArrayList<String> states = new ArrayList<String>();
        ((DataSetProcessInstanceListPresenter)this.presenter).setAddingDefaultFilters(true);
        states.add(String.valueOf(1));
        this.initGenericTabFilter(preferences, "DS_ProcessInstancesGrid_0", Constants.INSTANCE.Active(), Constants.INSTANCE.FilterActive(), states, "", "");
        states = new ArrayList();
        states.add(String.valueOf(2));
        this.initGenericTabFilter(preferences, "DS_ProcessInstancesGrid_1", Constants.INSTANCE.Completed(), Constants.INSTANCE.FilterCompleted(), states, "", "");
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries("DS_ProcessInstancesGrid_0");
    }

    private void initGenericTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> states, String processDefinition, String initiator) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(PROCESS_INSTANCES_DATASET_ID);
        ArrayList<String> names = new ArrayList<String>();
        for (String s : states) {
            names.add(s);
        }
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.setColumn("processInstanceId", "processInstanceId");
        builder.setColumn("processId", "processId");
        builder.setColumn("start_date", "start", DateUtils.getDateTimeFormatMask());
        builder.setColumn("end_date", "end", DateUtils.getDateTimeFormatMask());
        builder.setColumn("status", "status");
        builder.setColumn("parentProcessInstanceId", "parentProcessInstanceId");
        builder.setColumn("outcome", "outcome");
        builder.setColumn("duration", "duration");
        builder.setColumn("user_identity", "identity");
        builder.setColumn("processVersion", "processVersion");
        builder.setColumn("processName", "processName");
        builder.setColumn("correlationKey", "CorrelationKey");
        builder.setColumn("externalId", "externalId");
        builder.setColumn("processInstanceDescription", "processInstanceDescription");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((DataSetProcessInstanceListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((DataSetProcessInstanceListPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset(PROCESS_INSTANCES_DATASET_ID);
        builder.setColumn("processInstanceId", "processInstanceId");
        builder.setColumn("processId", "processId");
        builder.setColumn("start_date", "start", DateUtils.getDateTimeFormatMask());
        builder.setColumn("end_date", "end", DateUtils.getDateTimeFormatMask());
        builder.setColumn("status", "status");
        builder.setColumn("parentProcessInstanceId", "parentProcessInstanceId");
        builder.setColumn("outcome", "outcome");
        builder.setColumn("duration", "duration");
        builder.setColumn("user_identity", "identity");
        builder.setColumn("processVersion", "processVersion");
        builder.setColumn("processName", "processName");
        builder.setColumn("correlationKey", "CorrelationKey");
        builder.setColumn("externalId", "externalId");
        builder.setColumn("processInstanceDescription", "processInstanceDescription");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    static interface Binder
    extends UiBinder<Widget, DataSetProcessInstanceListViewImpl> {
    }
}

