/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.gc.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance List With Variables")
public class DataSetProcessInstanceWithVariablesListPresenter
extends AbstractScreenListPresenter<ProcessInstanceSummary> {
    public static final String SCREEN_ID = "DataSet Process Instance List With Variables";
    @Inject
    private DataSetProcessInstanceWithVariablesListView view;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    private DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;

    public DataSetProcessInstanceWithVariablesListPresenter() {
    }

    public DataSetProcessInstanceWithVariablesListPresenter(DataSetProcessInstanceWithVariablesListView view, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this();
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
        this.view = view;
    }

    public DataSetProcessInstanceWithVariablesListPresenter(DataSetProcessInstanceWithVariablesListView view, Caller<ProcessInstanceService> processInstanceService, Caller<KieSessionEntryPoint> kieSessionServices, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific, PlaceManager placeManager) {
        this();
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.processInstanceService = processInstanceService;
        this.kieSessionServices = kieSessionServices;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
        this.view = view;
        this.placeManager = placeManager;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                if (currentTableSettings != null) {
                    currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                    ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                    if (columnSortList != null && columnSortList.size() > 0) {
                        this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                        this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                    } else {
                        this.dataSetQueryHelper.setLastOrderedColumn("start_date");
                        this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                    }
                    List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                    if (!filters.isEmpty()) {
                        if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                            currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        } else {
                            DataSetFilter filter = new DataSetFilter();
                            filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                            currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                        }
                    }
                    this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
                    this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                    this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetProcessInstanceCallback(visibleRange.getStart(), currentTableSettings));
                } else {
                    this.view.hideBusyIndicator();
                }
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            try {
                Long instanceId = Long.valueOf(searchString.trim());
                filters.add(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)instanceId));
            }
            catch (NumberFormatException ex) {
                filters.add(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)searchString)));
                filters.add(FilterFactory.likeTo((String)"processName", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"processInstanceDescription", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"user_identity", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            }
        }
        return filters;
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, final int totalRowSize, final List<ProcessInstanceSummary> instances, FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getDataSet()){

            public void callback(DataSet dataSet) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long processInstanceId = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "processInstanceId", i);
                    String variableName = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "variableId", i);
                    String variableValue = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "value", i);
                    for (ProcessInstanceSummary pis : instances) {
                        if (!pis.getProcessInstanceId().equals(processInstanceId)) continue;
                        pis.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.addDomainSpecifColumns((ExtendedPagedTable<ProcessInstanceSummary>)DataSetProcessInstanceWithVariablesListPresenter.this.view.getListGrid(), columns);
                PageResponse processInstanceSummaryPageResponse = new PageResponse();
                processInstanceSummaryPageResponse.setPageRowList(instances);
                processInstanceSummaryPageResponse.setStartRowIndex(startRange);
                processInstanceSummaryPageResponse.setTotalRowSize(totalRowSize);
                processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                if (startRange + instances.size() == totalRowSize) {
                    processInstanceSummaryPageResponse.setLastPage(true);
                } else {
                    processInstanceSummaryPageResponse.setLastPage(false);
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
            }
        };
    }

    protected DataSetReadyCallback createDataSetProcessInstanceCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getDataSet()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    ArrayList<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myProcessInstancesFromDataSet.add(DataSetProcessInstanceWithVariablesListPresenter.this.createProcessInstanceSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = DataSetProcessInstanceWithVariablesListPresenter.this.isFilteredByProcessId(ops);
                    if (filterValue != null) {
                        DataSetProcessInstanceWithVariablesListPresenter.this.getDomainSpecifDataForProcessInstances(startRange, dataSet, filterValue, myProcessInstancesFromDataSet);
                    } else {
                        PageResponse processInstanceSummaryPageResponse = new PageResponse();
                        processInstanceSummaryPageResponse.setPageRowList(myProcessInstancesFromDataSet);
                        processInstanceSummaryPageResponse.setStartRowIndex(startRange);
                        processInstanceSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                        processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                        if (startRange + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                            processInstanceSummaryPageResponse.setLastPage(true);
                        } else {
                            processInstanceSummaryPageResponse.setLastPage(false);
                        }
                        DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(int startRange, DataSet dataSet, String filterValue, List<ProcessInstanceSummary> myProcessInstancesFromDataSet) {
        int rowCountNotTrimmed = dataSet.getRowCountNonTrimmed();
        FilterSettings variablesTableSettings = this.view.getVariablesTableSettings(filterValue);
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("processInstanceId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, rowCountNotTrimmed, myProcessInstancesFromDataSet, variablesTableSettings));
    }

    private ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "externalId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processName", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processVersion", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "start_date", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "user_identity", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "correlationKey", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentProcessInstanceId", i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.textSearchStr = this.place.getParameter("processDefinitionId", "");
        this.refreshGrid();
    }

    public void abortProcessInstance(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstance(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)Constants.INSTANCE.UnexpectedError(throwable.getMessage()));
                return true;
            }
        })).abortProcessInstances(processInstanceIds);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        StringBuilder processIdsParam = new StringBuilder();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                this.view.displayNotification(Constants.INSTANCE.Signaling_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            processIdsParam.append(selected.getId() + ",");
        }
        if (processIdsParam.length() == 0) {
            return;
        }
        processIdsParam.deleteCharAt(processIdsParam.length() - 1);
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(Constants.INSTANCE.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                this.view.displayNotification(Constants.INSTANCE.Aborting_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            ids.add(selected.getProcessInstanceId());
            this.view.displayNotification(Constants.INSTANCE.Aborting_Process_Instance(selected.getId()));
        }
        if (ids.size() > 0) {
            this.abortProcessInstance(ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Process_Instances();
    }

    @WorkbenchPartView
    public UberView<DataSetProcessInstanceWithVariablesListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                DataSetProcessInstanceWithVariablesListPresenter.this.newProcessInstancePopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    public static interface DataSetProcessInstanceWithVariablesListView
    extends AbstractListView.ListView<ProcessInstanceSummary, DataSetProcessInstanceWithVariablesListPresenter> {
        public int getRefreshValue();

        public void saveRefreshValue(int var1);

        public FilterSettings getVariablesTableSettings(String var1);

        public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> var1, Set<String> var2);

        public void applyFilterOnPresenter(String var1);
    }
}

