/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.bd.model.ProcessSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.console.ng.pr.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.console.ng.pr.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.jbpm.console.ng.pr.model.events.ProcessDefSelectionEvent;
import org.jbpm.console.ng.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDefinitionListPresenterTest {
    @Mock
    ProcessDefinitionListPresenter.ProcessDefinitionListView view;
    @Mock
    ExtendedPagedTable extendedPagedTable;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    protected EventSourceMock<ProcessDefSelectionEvent> processDefSelectionEvent;
    Caller<ProcessRuntimeDataService> processRuntimeDataServiceCaller;
    @Mock
    ProcessRuntimeDataService processRuntimeDataService;
    @Mock
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Mock
    PopupFormDisplayerView formDisplayPopUp;
    @Mock
    HasData next;
    @InjectMocks
    ProcessDefinitionListPresenter presenter;

    @Before
    public void setup() {
        this.processRuntimeDataServiceCaller = new CallerMock((Object)this.processRuntimeDataService);
        this.presenter.setProcessRuntimeDataService(this.processRuntimeDataServiceCaller);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn((Object)new ColumnSortList());
        Mockito.when((Object)this.next.getVisibleRange()).thenReturn((Object)new Range(1, 1));
        this.presenter.getDataProvider().addDataDisplay(this.next);
    }

    @Test
    public void testSearchString() {
        String textSearchStr = "textSearch";
        SearchEvent searchEvent = new SearchEvent("textSearch");
        this.presenter.onSearchEvent(searchEvent);
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataService)).getProcessesByFilter(Mockito.anyString(), Mockito.anyString(), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Boolean.valueOf(Mockito.anyBoolean()));
    }

    @Test
    public void testProcessDefNameDefinitionPropagation() {
        String processDefName = "testProcessDefName";
        ProcessSummary processSummary = new ProcessSummary();
        processSummary.setProcessDefId("testProcessDefId");
        processSummary.setDeploymentId("testDeploymentId");
        processSummary.setProcessDefName(processDefName);
        Mockito.when((Object)this.placeManager.getStatus((PlaceRequest)Mockito.any(PlaceRequest.class))).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.selectProcessDefinition(processSummary, Boolean.valueOf(true));
        ((EventSourceMock)Mockito.verify(this.processDefSelectionEvent)).fire(Mockito.any(ProcessDefSelectionEvent.class));
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessDefSelectionEvent.class);
        ((EventSourceMock)Mockito.verify(this.processDefSelectionEvent)).fire(argument.capture());
        Assert.assertEquals((Object)processDefName, (Object)((ProcessDefSelectionEvent)argument.getValue()).getProcessDefName());
    }

    @Test
    public void testProcessDefNameDefinitionOpenGenericForm() {
        String processDefName = "testProcessDefName";
        this.presenter.openGenericForm("processDefId", "deploymentId", processDefName);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessDisplayerConfig.class);
        ((StartProcessFormDisplayProviderImpl)Mockito.verify((Object)this.startProcessDisplayProvider)).setup((ProcessDisplayerConfig)argument.capture(), (FormDisplayerView)Mockito.any());
        Assert.assertEquals((Object)processDefName, (Object)((ProcessDisplayerConfig)argument.getValue()).getProcessName());
    }

    @Test
    public void testGetData() {
        Mockito.when((Object)this.processRuntimeDataService.getProcessesByFilter(Mockito.anyString(), Mockito.anyString(), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Boolean.valueOf(Mockito.anyBoolean()))).thenReturn(ProcessDefinitionListPresenterTest.getMockList(10)).thenReturn(ProcessDefinitionListPresenterTest.getMockList(1));
        Range range = new Range(0, 10);
        ProcessDefinitionListPresenter presenter = (ProcessDefinitionListPresenter)Mockito.spy((Object)this.presenter);
        presenter.getData(range);
        ((ProcessDefinitionListPresenter)Mockito.verify((Object)presenter)).updateDataOnCallback(Mockito.anyList(), Mockito.eq((int)0), Mockito.eq((int)10), Mockito.eq((boolean)false));
        range = new Range(10, 10);
        presenter.getData(range);
        ((ProcessDefinitionListPresenter)Mockito.verify((Object)presenter)).updateDataOnCallback(Mockito.anyList(), Mockito.eq((int)10), Mockito.eq((int)11), Mockito.eq((boolean)true));
    }

    private static List<ProcessSummary> getMockList(int instances) {
        ArrayList<ProcessSummary> summaries = new ArrayList<ProcessSummary>();
        for (int i = 0; i < instances; ++i) {
            summaries.add(new ProcessSummary());
        }
        return summaries;
    }
}

