/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash;

import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.console.ng.bd.model.ProcessInstanceSummary;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash.DataSetProcessInstanceWithVariablesListPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash.DataSetProcessInstanceWithVariablesListViewImpl;
import org.jbpm.console.ng.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetProcessInstanceWithVariablesListPresenterTest {
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @Mock
    private DataSetProcessInstanceWithVariablesListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private DataSet dataSet;
    @Mock
    private DataSet dataSetProcessVar;
    @Mock
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Mock
    private ExtendedPagedTable extendedPagedTable;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    private FilterSettings filterSettings;
    private ArrayList<ProcessInstanceSummary> processInstanceSummaries;
    @InjectMocks
    private DataSetProcessInstanceWithVariablesListPresenter presenter;

    @Before
    public void setupMocks() {
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.processInstanceSummaries = this.createProcessInstanceSummaryList(5);
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)new DataSetLookup());
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getVariablesTableSettings("testProc")).thenReturn((Object)this.filterSettings);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(DataSetProcessInstanceWithVariablesListPresenterTest.this.dataSet);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(DataSetProcessInstanceWithVariablesListPresenterTest.this.dataSetProcessVar);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetProcessInstanceWithVariablesListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void isFilteredByProcessIdTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertEquals((Object)"testProc", (Object)filterProcessId);
    }

    @Test
    public void isFilteredByProcessIdInvalidTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"processId", (String)"testProc")});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertNull((Object)filterProcessId);
    }

    @Test
    public void abortProcessInstanceTest() {
        Long processInstanceId = new Random().nextLong();
        String containerId = "container";
        this.presenter.abortProcessInstance("container", processInstanceId.longValue());
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance(Mockito.anyString(), (String)Mockito.eq((Object)"container"), (Long)Mockito.eq((Object)processInstanceId));
    }

    @Test
    public void abortProcessInstancesTest() {
        Random random = new Random();
        ArrayList<String> containers = new ArrayList<String>();
        containers.add("container");
        ArrayList<Long> pIds = new ArrayList<Long>();
        pIds.add(random.nextLong());
        pIds.add(random.nextLong());
        pIds.add(random.nextLong());
        this.presenter.abortProcessInstance(containers, pIds);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkAbortProcessInstancesTest() {
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            pIds.add(summary.getProcessInstanceId());
            containers.add(summary.getDeploymentId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkAbortProcessInstancesStateTest() {
        this.processInstanceSummaries.add(DataSetProcessInstanceWithVariablesListPresenterTest.createProcessInstanceSummary(new Random().nextInt(), 3));
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            pIds.add(summary.getProcessInstanceId());
            containers.add(summary.getDeploymentId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkSignalProcessInstanceSingleAbortedTest() {
        ArrayList<ProcessInstanceSummary> processInstanceSummaries = new ArrayList<ProcessInstanceSummary>();
        processInstanceSummaries.add(DataSetProcessInstanceWithVariablesListPresenterTest.createProcessInstanceSummary(new Random().nextInt(), 3));
        this.presenter.bulkSignal(processInstanceSummaries);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
    }

    @Test
    public void bulkSignalProcessInstancesStateTest() {
        this.processInstanceSummaries.add(DataSetProcessInstanceWithVariablesListPresenterTest.createProcessInstanceSummary(new Random().nextInt(), 3));
        ArrayList<Long> pIds = new ArrayList<Long>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            pIds.add(summary.getProcessInstanceId());
        }
        this.presenter.bulkSignal(this.processInstanceSummaries);
        ArgumentCaptor placeRequest = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest.capture());
        Assert.assertEquals((Object)"Signal Process Popup", (Object)((PlaceRequest)placeRequest.getValue()).getIdentifier());
        Assert.assertEquals((Object)StringUtils.join(pIds, (String)","), (Object)((PlaceRequest)placeRequest.getValue()).getParameter("processInstanceId", null));
    }

    @Test
    public void getDomainSpecifDataForProcessInstancesTest() {
        this.presenter.setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelper.getColumnLongValue(this.dataSet, "processInstanceId", 0)).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnLongValue(this.dataSetProcessVar, "processInstanceId", 0)).thenReturn((Object)1L);
        String processVariable1 = "var1";
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "variableId", 0)).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "value", 0)).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnLongValue(this.dataSetProcessVar, "processInstanceId", 1)).thenReturn((Object)1L);
        String processVariable2 = "var2";
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "variableId", 1)).thenReturn((Object)processVariable2);
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "value", 1)).thenReturn((Object)"value2");
        Object expectedColumns = new HashSet();
        expectedColumns.add(processVariable1);
        expectedColumns.add(processVariable2);
        this.presenter.getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetProcessInstanceWithVariablesListViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastOrderedColumn("processInstanceId");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastSortOrder(SortOrder.ASCENDING);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnLongValue(this.dataSetProcessVar, "processInstanceId", 0)).thenReturn((Object)1L);
        processVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "variableId", 0)).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetQueryHelperDomainSpecific.getColumnStringValue(this.dataSetProcessVar, "value", 0)).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(processVariable1);
        this.presenter.getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((DataSetProcessInstanceWithVariablesListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
    }

    public ArrayList<ProcessInstanceSummary> createProcessInstanceSummaryList(int listSize) {
        ArrayList<ProcessInstanceSummary> pIList = new ArrayList<ProcessInstanceSummary>();
        for (int i = 1; i <= listSize; ++i) {
            pIList.add(DataSetProcessInstanceWithVariablesListPresenterTest.createProcessInstanceSummary(i));
        }
        return pIList;
    }

    public static ProcessInstanceSummary createProcessInstanceSummary(int key) {
        return DataSetProcessInstanceWithVariablesListPresenterTest.createProcessInstanceSummary(key, 1);
    }

    public static ProcessInstanceSummary createProcessInstanceSummary(int key, int status) {
        return new ProcessInstanceSummary((long)key, "procTest", "test.0.1", "Test Proc", "1.0", status, new Date(), "intiatior", "procTestInstanceDesc", "cKey", Long.valueOf(0L));
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.presenter.onSearchEvent(searchEvent);
        ((DataSetProcessInstanceWithVariablesListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.presenter.onSearchEvent(searchEvent);
        ((DataSetProcessInstanceWithVariablesListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchFilterEmpty() {
        List filters = this.presenter.getColumnFilters("");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterNull() {
        List filters = this.presenter.getColumnFilters(null);
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterEmptyTrim() {
        List filters = this.presenter.getColumnFilters("     ");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterId() {
        List filters = this.presenter.getColumnFilters("1");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterIdTrim() {
        List filters = this.presenter.getColumnFilters(" 1 ");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterString() {
        List filters = this.presenter.getColumnFilters("processName");
        Assert.assertEquals((long)4L, (long)filters.size());
        Assert.assertEquals((Object)"processId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
        Assert.assertEquals((Object)"processName", (Object)((ColumnFilter)filters.get(1)).getColumnId());
        Assert.assertEquals((Object)"processInstanceDescription", (Object)((ColumnFilter)filters.get(2)).getColumnId());
        Assert.assertEquals((Object)"user_identity", (Object)((ColumnFilter)filters.get(3)).getColumnId());
    }
}

