/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import org.jbpm.console.ng.bd.model.ProcessSummary;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.jbpm.console.ng.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class ProcessDefinitionListViewImpl
extends AbstractListView<ProcessSummary, ProcessDefinitionListPresenter>
implements ProcessDefinitionListPresenter.ProcessDefinitionListView {
    public static final String COL_ID_PROCESSNAME = "ProcessName";
    public static final String COL_ID_PROCESSVERSION = "ProcessVersion";
    public static final String COL_ID_PROJECT = "Project";
    public static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = Constants.INSTANCE;

    public void init(final ProcessDefinitionListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_PROCESSNAME);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_PROCESSNAME);
        initColumns.add(COL_ID_PROCESSVERSION);
        initColumns.add(COL_ID_PROJECT);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("ProcessDefinitionsGrid", initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (ProcessDefinitionListViewImpl.this.selectedRow == -1) {
                    ProcessDefinitionListViewImpl.this.listGrid.setRowStyles(ProcessDefinitionListViewImpl.this.selectedStyles);
                    ProcessDefinitionListViewImpl.this.selectedRow = ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDefinitionListViewImpl.this.listGrid.redraw();
                } else if (ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow() != ProcessDefinitionListViewImpl.this.selectedRow) {
                    ProcessDefinitionListViewImpl.this.listGrid.setRowStyles(ProcessDefinitionListViewImpl.this.selectedStyles);
                    ProcessDefinitionListViewImpl.this.selectedRow = ProcessDefinitionListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDefinitionListViewImpl.this.listGrid.redraw();
                } else {
                    close = true;
                }
                ProcessDefinitionListViewImpl.this.selectedItem = (GenericSummary)ProcessDefinitionListViewImpl.this.selectionModel.getLastSelectedObject();
                presenter.selectProcessDefinition((ProcessSummary)ProcessDefinitionListViewImpl.this.selectedItem, close);
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && ProcessDefinitionListViewImpl.this.listGrid.getColumnIndex(ProcessDefinitionListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setEmptyTableCaption(this.constants.No_Process_Definitions_Found());
        this.listGrid.setRowStyles(this.selectedStyles);
        this.listGrid.getElement().getStyle().setPaddingRight(20.0, Style.Unit.PX);
        this.listGrid.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column processNameColumn = this.initProcessNameColumn();
        Column versionColumn = this.initVersionColumn();
        Column projectColumn = this.initProjectColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(projectColumn, this.constants.Project()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initProcessNameColumn() {
        Column<ProcessSummary, String> processNameColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getProcessDefName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDataStoreName(COL_ID_PROCESSNAME);
        return processNameColumn;
    }

    private Column initVersionColumn() {
        Column<ProcessSummary, String> versionColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName(COL_ID_PROCESSVERSION);
        return versionColumn;
    }

    private Column initProjectColumn() {
        Column<ProcessSummary, String> projectColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getDeploymentId();
            }
        };
        projectColumn.setSortable(true);
        projectColumn.setDataStoreName(COL_ID_PROJECT);
        return projectColumn;
    }

    private Column initActionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ButtonActionCell(this.constants.Start(), (ActionCell.Delegate)new ActionCell.Delegate<ProcessSummary>(){

            public void execute(ProcessSummary process) {
                ((ProcessDefinitionListPresenter)ProcessDefinitionListViewImpl.this.presenter).openGenericForm(process.getProcessDefId(), process.getDeploymentId(), process.getProcessDefName());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessSummary, ProcessSummary> actionsColumn = new Column<ProcessSummary, ProcessSummary>((Cell)cell){

            public ProcessSummary getValue(ProcessSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }
}

