/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceDotFileImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.vfs.ActiveFileSystems;
import org.uberfire.backend.vfs.FileSystemFactory;
import org.uberfire.backend.vfs.impl.ActiveFileSystemsImpl;

public class VFSFileSystemProducer {
    private IOService ioService = new IOServiceDotFileImpl();
    ActiveFileSystems activeFileSystems = new ActiveFileSystemsImpl();

    public RepositoryDescriptor produceFileSystem(Map<String, String> env) {
        String fetchCommand;
        URI repositoryRoot = URI.create(env.get("repository.root"));
        FileSystem fileSystem = this.ioService.getFileSystem(repositoryRoot);
        if (fileSystem == null) {
            fileSystem = this.ioService.newFileSystem(repositoryRoot, env, (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
        }
        if ((fetchCommand = env.get("fetch.cmd")) != null) {
            fileSystem = this.ioService.getFileSystem(URI.create(env.get("repository.root") + fetchCommand));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(env.get("repository.root"), "designer-repo");
        this.activeFileSystems.addBootstrapFileSystem(FileSystemFactory.newFS(map, (Set)fileSystem.supportedFileAttributeViews()));
        Path rootPath = fileSystem.provider().getPath(repositoryRoot);
        return new RepositoryDescriptor(repositoryRoot, fileSystem, rootPath);
    }

    public IOService getIoService() {
        return this.ioService;
    }
}

