/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class VFSFileSystemProducer {
    private IOService ioService = new IOServiceDotFileImpl();

    public RepositoryDescriptor produceFileSystem(Map<String, String> env) {
        String fetchCommand;
        URI repositoryRoot = URI.create(env.get("repository.root"));
        FileSystem fileSystem = this.ioService.getFileSystem(repositoryRoot);
        if (fileSystem == null) {
            fileSystem = this.ioService.newFileSystem(repositoryRoot, env);
        }
        if ((fetchCommand = env.get("fetch.cmd")) != null) {
            fileSystem = this.ioService.getFileSystem(URI.create(env.get("repository.root") + fetchCommand));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(env.get("repository.root"), "designer-repo");
        Path rootPath = fileSystem.provider().getPath(repositoryRoot);
        return new RepositoryDescriptor(repositoryRoot, fileSystem, rootPath);
    }

    public IOService getIoService() {
        return this.ioService;
    }
}

