/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.server.Repository;
import org.jbpm.designer.server.StencilSetExtensionGenerator;

public class ServiceComposerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String BASE_STENCILSET = "http://b3mn.org/stencilset/bpmn1.1#";
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String baseUrl;
    protected Repository repository;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.baseUrl = Repository.getBaseUrl(request);
        this.repository = new Repository(this.baseUrl);
        ArrayList<Service> services = this.parseParameters(request.getParameterMap());
        Date creationDate = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
        String sessionName = "Service Composer Session " + dateFormat.format(creationDate);
        ArrayList<String> stencilSetExtensionUrls = new ArrayList<String>();
        stencilSetExtensionUrls.add("http://oryx-editor.org/stencilsets/extensions/bpmnservicecompositionsubset#");
        stencilSetExtensionUrls.add("http://oryx-editor.org/stencilsets/extensions/bpmn-xforms-user-interfaces#");
        stencilSetExtensionUrls.add(this.generateStencilSetExtension(sessionName, services));
        String startEventId = "oryx_" + UUID.randomUUID().toString();
        String model = this.repository.generateERDF(sessionName, "<a rel=\"oryx-render\" href=\"#" + startEventId + "\"/></div><div id=\"" + startEventId + "\"><span class=\"oryx-type\">http://b3mn.org/stencilset/bpmn1.1#StartMessageEvent</span><span class=\"oryx-id\"></span><span class=\"oryx-categories\"></span><span class=\"oryx-documentation\"></span><span class=\"oryx-name\"></span><span class=\"oryx-assignments\"></span><span class=\"oryx-pool\"></span><span class=\"oryx-lanes\"></span><span class=\"oryx-eventtype\">Start</span><span class=\"oryx-trigger\">Message</span><span class=\"oryx-message\"></span><span class=\"oryx-implementation\">Web Service</span><span class=\"oryx-bgcolor\">#ffffff</span><span class=\"oryx-bounds\">15,225,45,255</span><a rel=\"raziel-parent\" href=\"#oryx-canvas123\"/>", "/stencilsets/bpmn1.1/bpmn1.1.json", BASE_STENCILSET, stencilSetExtensionUrls);
        String modelUrl = this.baseUrl + this.repository.saveNewModel(model, "Service Composition " + dateFormat.format(creationDate));
        modelUrl = modelUrl.substring(modelUrl.lastIndexOf("http://"));
        response.setHeader("Location", modelUrl);
        response.setStatus(301);
    }

    protected String generateStencilSetExtension(String extensionName, ArrayList<Service> services) {
        String extension = this.generateJsonForStencilSetExtension(extensionName, services);
        String extensionNamespace = this.getStencilSetExtensionNamespace(extensionName);
        String extensionLocation = this.getStencilSetExtensionLocation(extensionName);
        StencilSetExtensionGenerator.saveStencilSetExtension(extensionLocation, extension);
        StencilSetExtensionGenerator.registerStencilSetExtension(extensionName, extensionNamespace, this.getStencilSetExtensionDescription(extensionName, services), extensionLocation, BASE_STENCILSET);
        return extensionNamespace;
    }

    private String generateJsonForStencilSetExtension(String extensionName, ArrayList<Service> services) {
        ArrayList<String> colors = new ArrayList<String>();
        colors.add("#eefecc");
        colors.add("#cce5fe");
        colors.add("#e5ccfe");
        colors.add("#ccccfe");
        ListIterator colorIterator = colors.listIterator();
        Pattern pattern = Pattern.compile("([a-z])([A-Z0-9])");
        StringBuffer stencilsForOperations = new StringBuffer();
        ListIterator<Service> serviceIterator = services.listIterator();
        while (serviceIterator.hasNext()) {
            Service service = serviceIterator.next();
            if (!colorIterator.hasNext()) {
                colorIterator = colors.listIterator();
            }
            String color = (String)colorIterator.next();
            ListIterator<PortType> portTypeIterator = service.portTypes.listIterator();
            while (portTypeIterator.hasNext()) {
                PortType portType = portTypeIterator.next();
                ListIterator<Operation> operationIterator = portType.operations.listIterator();
                while (operationIterator.hasNext()) {
                    Operation operation = operationIterator.next();
                    Matcher matcher = pattern.matcher(operation.name);
                    String taskName = matcher.replaceAll("$1 $2");
                    String xform = "";
                    if (!operation.uiUrls.isEmpty()) {
                        xform = operation.uiUrls.get(0);
                    }
                    stencilsForOperations.append("{\"type\": \"node\",\"id\":\"" + ServiceComposerServlet.createJsonId(portType.name + "-" + operation.name) + "\"," + "\"superId\":\"Task\"," + "\"title\":\"" + taskName + "\"," + "\"groups\":[\"Activities\"]," + "\"description\":\"An invocation of operation '" + operation.name + "' of port type '" + portType.name + "' of the service described in '" + service.wsdlUrl + "'.\"," + "\"view\":\"activity/node.task.svg\"," + "\"icon\":\"new_task.png\"," + "\"roles\": [\"sequence_start\",\"sequence_end\",\"messageflow_start\", \"messageflow_end\",\"to_task_event\",\"from_task_event\",\"conditional_start\",\"default_start\", \"tc\", \"fromtoall\" ]," + "\"properties\": [ " + "{\"id\":\"name\",\"value\":\"" + taskName + "\" }, " + "{\"id\":\"xform\",\"value\":\"" + xform + "\" }, " + "{\"id\":\"bgColor\",\"value\":\"" + color + "\"}" + "  ]},\n");
                }
            }
        }
        return "{\"title\":\"" + extensionName + "\"," + "\"namespace\":\"" + this.getStencilSetExtensionNamespace(extensionName) + "\"," + "\"description\":\"" + this.getStencilSetExtensionDescription(extensionName, services) + "\"," + "\"extends\":\"" + BASE_STENCILSET + "\"," + "\"stencils\":[\n" + stencilsForOperations.toString() + "]," + "\"properties\":[]," + "\"rules\": {\"connectionRules\": [],\"cardinalityRules\": [],\"containmentRules\": []},\"removestencils\": [],\"removeproperties\": []}";
    }

    private String getStencilSetExtensionDescription(String extensionName, ArrayList<Service> services) {
        return "Extension for " + extensionName + " using " + services.size() + " services.";
    }

    private String getStencilSetExtensionNamespace(String extensionName) {
        return "http://oryx-editor.org/stencilsets/extensions/bpmn_" + extensionName.toLowerCase().replace(" ", "_") + "#";
    }

    private String getStencilSetExtensionLocation(String extensionName) {
        return "bpmnservicecompositionsubset/" + extensionName.toLowerCase().replace(" ", "_") + ".json";
    }

    private static String createJsonId(String name) {
        String result = name.toLowerCase();
        result = result.replace(" ", "");
        return result;
    }

    protected ArrayList<Service> parseParameters(Map<?, ?> parameterMap) {
        TreeMap<String, String> sortedParameterMap = new TreeMap<String, String>();
        for (Map.Entry<?, ?> parameter : parameterMap.entrySet()) {
            sortedParameterMap.put(parameter.getKey().toString(), ((String[])parameter.getValue())[0]);
        }
        ArrayList<Service> services = new ArrayList<Service>();
        Pattern pattern = Pattern.compile("^svc[0-9]+$");
        for (Map.Entry parameter : sortedParameterMap.entrySet()) {
            String key = (String)parameter.getKey();
            Matcher matcher = pattern.matcher(key);
            if (!matcher.matches()) continue;
            String value = (String)parameter.getValue();
            services.add(new Service(key, value, sortedParameterMap));
        }
        return services;
    }

    protected void println(String output) {
        try {
            this.response.getWriter().println(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Operation {
        public String name;
        public Map<String, String> inputParts;
        public Map<String, String> outputParts;
        public String inputMessage;
        public String outputMessage;
        public ArrayList<String> uiUrls;

        public Operation(String id, String name, Map<String, String> parameterMap) {
            this.name = name;
            this.inputParts = new TreeMap<String, String>();
            this.outputParts = new TreeMap<String, String>();
            this.uiUrls = new ArrayList();
            Pattern pattern = Pattern.compile("^(" + id + "_((in)|(out))[0-9]+)_name$");
            for (Map.Entry<String, String> parameter : parameterMap.entrySet()) {
                String key = parameter.getKey();
                Matcher matcher = pattern.matcher(key);
                if (matcher.matches()) {
                    String partName = parameter.getValue();
                    Pattern pattern2 = Pattern.compile("^" + matcher.group(1) + "_type$");
                    for (Map.Entry<String, String> parameter2 : parameterMap.entrySet()) {
                        String key2 = parameter2.getKey();
                        Matcher matcher2 = pattern2.matcher(key2);
                        if (!matcher2.matches()) continue;
                        String type = parameter2.getValue();
                        if (matcher.group(2).equals("in")) {
                            this.inputParts.put(partName, type);
                            continue;
                        }
                        this.outputParts.put(partName, type);
                    }
                    continue;
                }
                if (key.matches("^" + id + "_ui[0-9]+$")) {
                    String value = parameter.getValue();
                    this.uiUrls.add(value);
                    continue;
                }
                if (key.matches("^" + id + "_inmsg$")) {
                    this.inputMessage = parameter.getValue();
                    continue;
                }
                if (!key.matches("^" + id + "_outmsg$")) continue;
                this.outputMessage = parameter.getValue();
            }
        }

        public String toString() {
            return this.name + "\n" + this.inputParts.toString() + "\n" + this.outputParts.toString() + "\n" + this.uiUrls.toString() + "\n";
        }
    }

    static class PortType {
        public String name;
        public ArrayList<Operation> operations;

        public PortType(String id, String name, Map<String, String> parameterMap) {
            this.name = name;
            this.operations = new ArrayList();
            for (Map.Entry<String, String> parameter : parameterMap.entrySet()) {
                String key = parameter.getKey();
                if (!key.matches("^" + id + "_op[0-9]+$")) continue;
                String value = parameter.getValue();
                this.operations.add(new Operation(key, value, parameterMap));
            }
        }

        public String toString() {
            return this.name + "\n" + this.operations.toString() + "\n";
        }
    }

    static class Service {
        public String wsdlUrl;
        public String name;
        public String namespace;
        public ArrayList<PortType> portTypes;

        public Service(String id, String wsdlUrl, Map<String, String> parameterMap) {
            this.wsdlUrl = wsdlUrl;
            this.portTypes = new ArrayList();
            for (Map.Entry<String, String> parameter : parameterMap.entrySet()) {
                String key = parameter.getKey();
                if (key.matches("^" + id + "_pt[0-9]+$")) {
                    String value = parameter.getValue();
                    this.portTypes.add(new PortType(key, value, parameterMap));
                    continue;
                }
                if (key.matches("^" + id + "_name$")) {
                    this.name = parameter.getValue();
                    continue;
                }
                if (!key.matches("^" + id + "_ns$")) continue;
                this.namespace = parameter.getValue();
            }
        }

        public String toString() {
            return this.wsdlUrl + "\n" + this.portTypes.toString() + "\n";
        }
    }
}

