/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.util;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.util.Base64Backport;

public class Utils {
    public static String getUUID(HttpServletRequest request) {
        return Utils.getEncodedParam(request, "uuid");
    }

    public static String getEncodedParam(HttpServletRequest request, String paramName) {
        String uniqueId = request.getParameter(paramName);
        if (uniqueId != null && Base64Backport.isBase64(uniqueId)) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                uniqueId = new String(decoded, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return uniqueId;
    }

    public static String toBPMNIdentifier(String str) {
        str = str.replace(" ", "");
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (i == 0) {
                if (Utils.isNCNameStart(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append(Utils.convertNonNCNameChar(c));
                continue;
            }
            if (Utils.isNCNamePart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(Utils.convertNonNCNameChar(c));
        }
        return sb.toString();
    }

    protected static boolean isNCNameStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    protected static boolean isNCNamePart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
    }

    protected static String convertNonNCNameChar(char c) {
        String str = "" + c;
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(4);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%x", bytes[i]));
        }
        return sb.toString().toUpperCase();
    }
}

