/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.repository.IUUIDBasedRepository;
import org.jbpm.designer.web.repository.IUUIDBasedRepositoryService;
import org.jbpm.designer.web.repository.UUIDBasedEpnRepository;
import org.jbpm.designer.web.repository.impl.UUIDBasedFileRepository;
import org.jbpm.designer.web.repository.impl.UUIDBasedJbpmRepository;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBasedRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(UUIDBasedRepositoryServlet.class);
    @Inject
    private IDiagramProfileService _profileService = null;
    public static IUUIDBasedRepositoryService _factory = new IUUIDBasedRepositoryService(){
        private Map<String, IUUIDBasedRepository> factories = new HashMap<String, IUUIDBasedRepository>();
        private boolean _init = false;

        @Override
        public void init() {
            this.factories.put("default", new UUIDBasedFileRepository());
            this.factories.put("jbpm", new UUIDBasedJbpmRepository());
            this.factories.put("epn", new UUIDBasedEpnRepository());
            this._init = true;
        }

        @Override
        public IUUIDBasedRepository createRepository(ServletConfig config) {
            if (!this._init) {
                this.init();
            }
            return this.lookupRepository(config.getInitParameter("factoryName"));
        }

        @Override
        public IUUIDBasedRepository createRepository() {
            return new UUIDBasedFileRepository();
        }

        @Override
        public IUUIDBasedRepository lookupRepository(String name) {
            if (name == null || !this.factories.containsKey(name)) {
                IUUIDBasedRepository repo = this.factories.get("default");
                return repo;
            }
            IUUIDBasedRepository repo = this.factories.get(name);
            return repo;
        }
    };
    private IUUIDBasedRepository _repository;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this._repository = _factory.createRepository(config);
            this._repository.configure(this);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        String uuid = Utils.getUUID(req);
        String preProcessingParam = req.getParameter("pp");
        if (uuid == null) {
            throw new ServletException("uuid parameter required");
        }
        IDiagramProfile profile = this._profileService.findProfile(req, req.getParameter("profile"));
        try {
            String response = new String(this._repository.load(req, uuid, profile, this.getServletContext()), Charset.forName("UTF-8"));
            resp.getWriter().write(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.getWriter().write("error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String actionParam = req.getParameter("action");
        String preProcessingParam = req.getParameter("pp");
        if (preProcessingParam == null) {
            preProcessingParam = "ReadOnlyService";
        }
        if (actionParam != null && actionParam.equals("toXML")) {
            IDiagramProfile profile = this._profileService.findProfile(req, req.getParameter("profile"));
            String json = req.getParameter("data");
            String xml = "";
            try {
                xml = this._repository.toXML(json, profile, preProcessingParam);
            }
            catch (Exception e) {
                _logger.error("Error transforming to XML: " + e.getMessage());
            }
            StringWriter output = new StringWriter();
            output.write(xml);
            resp.setContentType("application/xml");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            resp.getWriter().print(output.toString());
        } else if (actionParam != null && actionParam.equals("checkErrors")) {
            String retValue = "false";
            IDiagramProfile profile = this._profileService.findProfile(req, req.getParameter("profile"));
            String json = req.getParameter("data");
            try {
                String xmlOut = profile.createMarshaller().parseModel(json, preProcessingParam);
                String jsonIn = profile.createUnmarshaller().parseModel(xmlOut, profile, preProcessingParam);
                if (jsonIn == null || jsonIn.length() < 1) {
                    retValue = "true";
                }
            }
            catch (Throwable t) {
                retValue = "true";
                _logger.error("Exception parsing process: " + t.getMessage());
            }
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            resp.getWriter().print(retValue);
        } else {
            int read;
            BufferedReader reader = req.getReader();
            StringWriter reqWriter = new StringWriter();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                reqWriter.write(buffer, 0, read);
            }
            String data = reqWriter.toString();
            try {
                JSONObject jsonObject = new JSONObject(data);
                String json = (String)jsonObject.get("data");
                String svg = (String)jsonObject.get("svg");
                String uuid = (String)jsonObject.get("uuid");
                String profileName = (String)jsonObject.get("profile");
                boolean autosave = jsonObject.getBoolean("savetype");
                IDiagramProfile profile = this._profileService.findProfile(req, req.getParameter("profile"));
                this._repository.save(req, uuid, json, svg, profile, autosave);
            }
            catch (JSONException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
    }
}

