/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.query;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRuleAttributesQuery;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindRuleFlowNamesQuery
extends FindRuleAttributesQuery {
    private static final Logger logger = LoggerFactory.getLogger(FindRuleFlowNamesQuery.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private RuleFlorNamesResponseBuilder responseBuilder = new RuleFlorNamesResponseBuilder();

    public String getName() {
        return "FindRuleFlowNamesQuery";
    }

    public ResponseBuilder getResponseBuilder() {
        this.responseBuilder.setIOService(this.ioService);
        return this.responseBuilder;
    }

    private static class RuleFlorNamesResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;

        private RuleFlorNamesResponseBuilder() {
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            HashMap<String, List<String>> uniqueRuleFlowNames = new HashMap<String, List<String>>();
            for (KObject kObject : kObjects) {
                Map<String, List<String>> ruleFlowGroupNames = this.getRuleFlowGroupNamesNamesFromKObject(kObject);
                for (String rkey : ruleFlowGroupNames.keySet()) {
                    if (uniqueRuleFlowNames.containsKey(rkey)) {
                        List<String> rvalList = ruleFlowGroupNames.get(rkey);
                        for (String rvalKey : rvalList) {
                            ((List)uniqueRuleFlowNames.get(rkey)).add(rvalKey);
                        }
                        continue;
                    }
                    uniqueRuleFlowNames.put(rkey, ruleFlowGroupNames.get(rkey));
                }
            }
            for (String uniqueKey : uniqueRuleFlowNames.keySet()) {
                List uniqueValueList = (List)uniqueRuleFlowNames.get(uniqueKey);
                String fstr = "";
                for (String val : uniqueValueList) {
                    fstr = fstr + val + "<<";
                }
                fstr = fstr.substring(0, fstr.length() - 2);
                RefactoringStringPageRow row = new RefactoringStringPageRow();
                row.setValue((Object)(uniqueKey + "||" + fstr));
                result.add((RefactoringPageRow)row);
            }
            return result;
        }

        private Map<String, List<String>> getRuleFlowGroupNamesNamesFromKObject(KObject kObject) {
            HashMap<String, List<String>> ruleFlowGroupNames = new HashMap<String, List<String>>();
            if (kObject == null) {
                return ruleFlowGroupNames;
            }
            for (KProperty property : kObject.getProperties()) {
                org.uberfire.backend.vfs.Path path;
                if (!property.getName().equals("ruleAttribute:ruleflow-group:ruleAttributeValue")) continue;
                if (ruleFlowGroupNames.containsKey(property.getValue().toString())) {
                    path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                    ((List)ruleFlowGroupNames.get(property.getValue().toString())).add(path.getFileName() + "^^" + path.toURI());
                    continue;
                }
                path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                ArrayList<String> pathsList = new ArrayList<String>();
                pathsList.add(path.getFileName() + "^^" + path.toURI());
                ruleFlowGroupNames.put(property.getValue().toString(), pathsList);
            }
            return ruleFlowGroupNames;
        }
    }
}

