/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.DefaultProfileImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class Bpmn2JsonMarshallerTest {
    DefaultProfileImpl profile = new DefaultProfileImpl();
    IDiagramProfile.IDiagramUnmarshaller marshaller = this.profile.createUnmarshaller();

    @Test
    public void testGroupMarshalling() throws Exception {
        JSONObject process = this.loadProcessFrom("group.bpmn2");
        JSONObject group = Bpmn2JsonMarshallerTest.getChildByName(process, "group");
        Assert.assertNotNull((String)"Group with name 'group' not found in process.", (Object)group);
        Assert.assertEquals((String)"Group has wrong documentation.", (Object)"group documentation", (Object)Bpmn2JsonMarshallerTest.getDocumentationFor(group));
    }

    @Test
    public void testBoundaryEventDocumentation() throws Exception {
        JSONObject process = this.loadProcessFrom("boundaryEventsDocumentation.bpmn2");
        JSONObject boundaryEvent = Bpmn2JsonMarshallerTest.getChildByName(process, "CancelOnTimer");
        Assert.assertNotNull((String)"BoundaryEvent with name 'CancelOnTimer' not found in process.", (Object)boundaryEvent);
        Assert.assertEquals((String)"BoundaryEvent has wrong documentation.", (Object)"Cancel task on timeout.", (Object)Bpmn2JsonMarshallerTest.getDocumentationFor(boundaryEvent));
    }

    @Test
    public void testSwimlaneDocumentation() throws Exception {
        JSONObject process = this.loadProcessFrom("swimlane.bpmn2");
        JSONObject swimlane = Bpmn2JsonMarshallerTest.getChildByName(process, "Documented Swimlane");
        Assert.assertNotNull((String)"Swimlane with name 'Documented Swimlane' not found in process.", (Object)swimlane);
        Assert.assertEquals((String)"Swimlane has wrong documentation.", (Object)"Some documentation for swimlane.", (Object)Bpmn2JsonMarshallerTest.getDocumentationFor(swimlane));
    }

    @Test
    public void testSendTaskDataInputs() throws Exception {
        String[] variableNames = new String[]{"Comment", "Content", "CreatedBy", "GroupId", "Locale", "NotCompletedNotify", "NotCompletedReassign", "NotStartedNotify", "NotStartedReassign", "Priority", "Skippable", "TaskName", "MyDataInput1", "MyDataInput2"};
        JSONObject process = this.loadProcessFrom("nonusertaskdatainputs.bpmn2");
        JSONObject sendtask = Bpmn2JsonMarshallerTest.getChildByName(process, "MySendTask");
        JSONObject properties = sendtask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        for (String variableName : variableNames) {
            String dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        String assignments = properties.getString("assignments");
        for (String variableName : variableNames) {
            String assignment = "[din]" + variableName + "=a" + variableName;
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
    }

    private JSONObject loadProcessFrom(String fileName) throws Exception {
        URL fileURL = Bpmn2JsonMarshallerTest.class.getResource(fileName);
        String definition = new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
        String jsonString = this.marshaller.parseModel(definition, (IDiagramProfile)this.profile, "");
        JSONObject process = new JSONObject(jsonString);
        if ("BPMNDiagram".equals(process.getJSONObject("stencil").getString("id"))) {
            return process;
        }
        throw new IllegalArgumentException("File " + fileName + " is not a valid BPMN2 process JSON");
    }

    private static JSONObject getChildByName(JSONObject parent, String name) throws JSONException {
        JSONArray children = parent.getJSONArray("childShapes");
        for (int i = 0; i < children.length(); ++i) {
            JSONObject child = children.getJSONObject(i);
            if (!name.equals(Bpmn2JsonMarshallerTest.getPropertyValue(child, "name"))) continue;
            return child;
        }
        return null;
    }

    private static String getDocumentationFor(JSONObject bpmnElement) throws JSONException {
        return Bpmn2JsonMarshallerTest.getPropertyValue(bpmnElement, "documentation");
    }

    private static String getPropertyValue(JSONObject bpmnElement, String propertyName) throws JSONException {
        return bpmnElement.getJSONObject("properties").getString(propertyName);
    }
}

