/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.test.bpmn2;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.GlobalBusinessRuleTask;
import org.eclipse.bpmn2.GlobalManualTask;
import org.eclipse.bpmn2.GlobalScriptTask;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.GlobalUserTask;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.junit.Test;

public class Bpmn2UnmarshallingTestCase {
    private static File getTestJsonFile(String filename) {
        URL fileURL = Bpmn2UnmarshallingTestCase.class.getResource(filename);
        return new File(fileURL.getFile());
    }

    @Test
    public void testSimpleDefinitionsUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("empty.json"), "").getContents().get(0);
        Assert.assertEquals((String)"<![CDATA[my doc]]>", (String)((Documentation)definitions.getDocumentation().iterator().next()).getText());
        Assert.assertEquals((String)"http://www.w3.org/1999/XPath", (String)definitions.getExpressionLanguage());
        Assert.assertEquals((String)"http://www.omg.org/bpmn20", (String)definitions.getTargetNamespace());
        Assert.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)definitions.getTypeLanguage());
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testSimpleGlobalTaskUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("oneTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().iterator().next() instanceof GlobalTask));
        GlobalTask task = (GlobalTask)definitions.getRootElements().iterator().next();
        Assert.assertEquals((String)"oneTask", (String)task.getName());
        Assert.assertEquals((String)"my task doc", (String)((Documentation)task.getDocumentation().iterator().next()).getText());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testTwoGlobalTasksUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("twoTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof GlobalTask));
        GlobalTask task = (GlobalTask)definitions.getRootElements().get(0);
        Assert.assertEquals((String)"firstTask", (String)task.getName());
        Assert.assertEquals((String)"my task doc", (String)((Documentation)task.getDocumentation().iterator().next()).getText());
        GlobalTask task2 = (GlobalTask)definitions.getRootElements().get(1);
        Assert.assertEquals((String)"secondTask", (String)task2.getName());
        Assert.assertEquals((String)"my task doc too", (String)((Documentation)task2.getDocumentation().iterator().next()).getText());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testPoolUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("pool.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof Process));
        Process process = this.getRootProcess(definitions);
        Assert.assertEquals((String)"pool", (String)process.getName());
        Assert.assertEquals((Object)ProcessType.PRIVATE, (Object)process.getProcessType());
        Assert.assertTrue((boolean)process.isIsClosed());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testLaneUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("pool.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof Process));
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((process.getLaneSets().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((LaneSet)process.getLaneSets().get(0)).getLanes().size() == 1 ? 1 : 0) != 0);
        Lane l = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        Assert.assertEquals((String)"my first lane", (String)l.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testSequenceFlowUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("sequenceFlow.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof Task));
        Task task = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((String)"task1", (String)task.getName());
        Task task2 = (Task)process.getFlowElements().get(1);
        Assert.assertEquals((String)"task2", (String)task2.getName());
        SequenceFlow flow = (SequenceFlow)process.getFlowElements().get(2);
        Assert.assertEquals((String)"seqFlow", (String)flow.getName());
        Assert.assertEquals((Object)task, (Object)flow.getSourceRef());
        Assert.assertEquals((Object)task2, (Object)flow.getTargetRef());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testScriptTaskUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("scriptTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        GlobalScriptTask task = (GlobalScriptTask)definitions.getRootElements().get(0);
        Assert.assertEquals((String)"my script", (String)task.getName());
        Assert.assertEquals((String)"git status | grep modified | awk '{print $3}' | xargs echo | xargs git add", (String)task.getScript());
        Assert.assertEquals((String)"bash", (String)task.getScriptLanguage());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testUserTaskUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("userTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        GlobalUserTask task = (GlobalUserTask)definitions.getRootElements().get(0);
        Assert.assertEquals((String)"ask user", (String)task.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testBusinessRuleTaskUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("businessRuleTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        GlobalBusinessRuleTask task = (GlobalBusinessRuleTask)definitions.getRootElements().get(0);
        Assert.assertEquals((String)"call business rule", (String)task.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testManualTaskUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("manualTask.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        GlobalManualTask task = (GlobalManualTask)definitions.getRootElements().get(0);
        Assert.assertEquals((String)"pull a lever", (String)task.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testGatewayUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("gateway.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ExclusiveGateway g = (ExclusiveGateway)process.getFlowElements().get(0);
        Assert.assertEquals((String)"xor gateway", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testParallelGatewayUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("parallelGateway.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ParallelGateway g = (ParallelGateway)process.getFlowElements().get(0);
        Assert.assertEquals((String)"parallel gateway", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEventBasedGatewayUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("eventBasedGateway.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EventBasedGateway g = (EventBasedGateway)process.getFlowElements().get(0);
        Assert.assertEquals((String)"event-based gateway", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testInclusiveGatewayUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("inclusiveGateway.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        InclusiveGateway g = (InclusiveGateway)process.getFlowElements().get(0);
        Assert.assertEquals((String)"inclusive gateway", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartMessageEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startMessageEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 3 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start message event", (String)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartEscalationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startEscalationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start escalation event", (String)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartCompensationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startCompensationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start compensation event", (String)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartMultipleEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartParallelMultipleEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startParallelMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start parallel multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartSignalEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startSignalEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start signal event", (String)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof SignalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartTimerEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startTimerEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"start timer event", (String)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TimerEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testGroupUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("group.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Group group = (Group)process.getArtifacts().iterator().next();
        Assert.assertEquals((String)"Group name is wrong.", (String)group.getCategoryValueRef().getValue(), (String)"group");
        Assert.assertEquals((String)((Documentation)group.getDocumentation().get(0)).getText(), (String)"<![CDATA[group documentation]]>");
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testTextAnnotationUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("textAnnotation.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getArtifacts().iterator().next() instanceof TextAnnotation));
        TextAnnotation ta = (TextAnnotation)process.getArtifacts().iterator().next();
        Assert.assertEquals((String)"text annotation", (String)ta.getText());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testDataObjectUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("dataObject.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().iterator().next() instanceof DataObject));
        DataObject da = (DataObject)process.getFlowElements().iterator().next();
        Assert.assertEquals((String)"data object", (String)da.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testDataStoreUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("dataStore.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().iterator().next() instanceof DataStore));
        DataStore da = (DataStore)definitions.getRootElements().iterator().next();
        Assert.assertEquals((String)"data store", (String)da.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testMessageUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("message.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().iterator().next() instanceof Message));
        Message msg = (Message)definitions.getRootElements().iterator().next();
        Assert.assertEquals((String)"message", (String)msg.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndMessageEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endMessageEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 3 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end message event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndEscalationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endEscalationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end escalation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndErrorEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endErrorEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end error event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof ErrorEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndSignalEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endSignalEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end signal event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof SignalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndTerminateEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endTerminateEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"terminate end event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TerminateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndMultipleEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndCompensationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("endCompensationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"end compensation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testSimpleChainUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("startEvent-task-endEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((process.getFlowElements().size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((process.getLaneSets().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((LaneSet)process.getLaneSets().get(0)).getLanes().size() == 1 ? 1 : 0) != 0);
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchMessageEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchMessageEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 3 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch message event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchTimerEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchTimerEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch timer event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TimerEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchEscalationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchEscalationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch escalation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchConditionalEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchConditionalEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch conditional event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof ConditionalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchLinkEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchLinkEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch link event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof LinkEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchErrorEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchErrorEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch error event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof ErrorEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchCancelEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchCancelEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch cancel event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CancelEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchCompensationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchCompensationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch compensation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchMultipleEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchParallelMultipleEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCatchParallelMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"catch parallel multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowMessageEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowMessageEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 3 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw message event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowEscalationEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowEscalationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw escalation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowLinkEventUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowLinkEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw link event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof LinkEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowCompensationUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowCompensationEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw compensation event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowSignalUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowSignalEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw signal event", (String)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof SignalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowMultipleUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateThrowMultipleEvent.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"throw multiple event", (String)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("association.json"), "").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Task g = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((String)"task", (String)g.getName());
        TextAnnotation textA = (TextAnnotation)process.getArtifacts().get(0);
        Association association = (Association)process.getArtifacts().get(1);
        Assert.assertEquals((Object)g, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.NONE, (Object)association.getAssociationDirection());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationUnidirectionalUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("associationOne.json"), "").getContents().get(0);
        Process process = this.getRootProcess(definitions);
        Task g = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((String)"task", (String)g.getName());
        TextAnnotation textA = (TextAnnotation)process.getArtifacts().get(0);
        Association association = (Association)process.getArtifacts().get(1);
        Assert.assertEquals((Object)g, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.ONE, (Object)association.getAssociationDirection());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationBidirectionalUnmarshalling() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("associationBoth.json"), "").getContents().get(0);
        Process process = this.getRootProcess(definitions);
        Task g = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((String)"task", (String)g.getName());
        TextAnnotation textA = (TextAnnotation)process.getArtifacts().get(0);
        Association association = (Association)process.getArtifacts().get(1);
        Assert.assertEquals((Object)g, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.BOTH, (Object)association.getAssociationDirection());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testBoundaryEventMultiLineName() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("boundaryEventMultiLineName.json"), "").getContents().get(0);
        Process process = this.getRootProcess(definitions);
        Boolean foundElementNameExtensionValue = false;
        BoundaryEvent event = (BoundaryEvent)process.getFlowElements().get(1);
        if (event.getExtensionValues() != null && event.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : event.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                Assert.assertNotNull((Object)metadataExtensions);
                Assert.assertTrue((metadataExtensions.size() == 1 ? 1 : 0) != 0);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    Assert.assertNotNull((Object)metaType.getMetaValue());
                    foundElementNameExtensionValue = true;
                }
            }
            Assert.assertTrue((boolean)foundElementNameExtensionValue);
        } else {
            Assert.fail((String)"Boundary event has no extension element");
        }
    }

    @Test
    public void testFindContainerForBoundaryEvent() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        JsonParser parser = new JsonFactory().createJsonParser(Bpmn2UnmarshallingTestCase.getTestJsonFile("boundaryEventsContainers.json"));
        parser.nextToken();
        Definitions definitions = (Definitions)unmarshaller.unmarshallItem(parser, "");
        unmarshaller.revisitCatchEvents(definitions);
        unmarshaller.revisitCatchEventsConvertToBoundary(definitions);
        Process process = this.getRootProcess(definitions);
        for (FlowElement element : process.getFlowElements()) {
            SubProcess sp;
            if (!(element instanceof BoundaryEvent)) continue;
            BoundaryEvent be = (BoundaryEvent)element;
            if ("Timer1".equals(element.getName())) {
                sp = (SubProcess)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
                Assert.assertEquals((String)"Subprocess1", (String)sp.getName());
            }
            if ("Timer2".equals(element.getName())) {
                sp = (SubProcess)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
                Assert.assertEquals((String)"Subprocess2", (String)sp.getName());
            }
            if (!"Timer3".equals(element.getName())) continue;
            sp = (Process)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
            Assert.assertEquals((String)"DemoProcess", (String)sp.getName());
        }
    }

    @Test
    public void testCompensationThrowingEvent() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("intermediateCompensationEventThrowing.json"), "").getContents().get(0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent compensationThrowEvent = (ThrowEvent)process.getFlowElements().get(2);
        Assert.assertEquals((String)"Compensate", (String)compensationThrowEvent.getName());
        Assert.assertNotNull((Object)compensationThrowEvent.getEventDefinitions());
        Assert.assertEquals((int)1, (int)compensationThrowEvent.getEventDefinitions().size());
        EventDefinition ed = (EventDefinition)compensationThrowEvent.getEventDefinitions().get(0);
        Assert.assertTrue((boolean)(ed instanceof CompensateEventDefinition));
        CompensateEventDefinition ced = (CompensateEventDefinition)ed;
        Assert.assertNotNull((Object)ced.getActivityRef());
        Assert.assertEquals((String)"User Task", (String)ced.getActivityRef().getName());
    }

    @Test
    public void testRevisitBoundaryEventsPositions() throws Exception {
        SubProcess subProcess;
        Process process;
        String SUBTIMER_NAME = "SubTimer";
        String SUBPROCESSMESSAGE_NAME = "SubProcessMessage";
        String OUTTIMER_NAME = "OutTimer";
        String DURING_INITIALIZATION = "during initialization";
        String AFTER_REVISION = "after revision";
        List initialBoundaryEventOutgointIds = null;
        List finalBoundaryEventOutgointIds = null;
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        JsonParser parser = new JsonFactory().createJsonParser(Bpmn2UnmarshallingTestCase.getTestJsonFile("boundaryEvents.json"));
        parser.nextToken();
        Definitions definitions = (Definitions)unmarshaller.unmarshallItem(parser, "");
        unmarshaller.revisitCatchEvents(definitions);
        unmarshaller.revisitCatchEventsConvertToBoundary(definitions);
        for (RootElement root : definitions.getRootElements()) {
            if (!(root instanceof Process)) continue;
            process = (Process)root;
            this.assertThatElementPresent(true, "during initialization", (FlowElementsContainer)process, "SubTimer");
            this.assertThatElementPresent(true, "during initialization", (FlowElementsContainer)process, "SubProcessMessage");
            this.assertThatElementPresent(true, "during initialization", (FlowElementsContainer)process, "OutTimer");
            for (FlowElement flow : ((Process)root).getFlowElements()) {
                if ("SubTimer".equals(flow.getName())) {
                    initialBoundaryEventOutgointIds = (List)unmarshaller.getOutgoingFlowsMap().get(flow);
                }
                if (!"Subprocess".equals(flow.getName())) continue;
                subProcess = (SubProcess)flow;
                this.assertThatElementPresent(false, "during initialization", (FlowElementsContainer)subProcess, "SubTimer");
                this.assertThatElementPresent(false, "during initialization", (FlowElementsContainer)subProcess, "SubProcessMessage");
                this.assertThatElementPresent(false, "during initialization", (FlowElementsContainer)subProcess, "OutTimer");
            }
        }
        unmarshaller.revisitBoundaryEventsPositions(definitions);
        for (RootElement root : definitions.getRootElements()) {
            if (!(root instanceof Process)) continue;
            process = (Process)root;
            this.assertThatElementPresent(false, "after revision", (FlowElementsContainer)process, "SubTimer");
            this.assertThatElementPresent(true, "after revision", (FlowElementsContainer)process, "SubProcessMessage");
            this.assertThatElementPresent(true, "after revision", (FlowElementsContainer)process, "OutTimer");
            for (FlowElement flow : ((Process)root).getFlowElements()) {
                if (!"Subprocess".equals(flow.getName())) continue;
                subProcess = (SubProcess)flow;
                this.assertThatElementPresent(true, "after revision", (FlowElementsContainer)subProcess, "SubTimer");
                this.assertThatElementPresent(false, "after revision", (FlowElementsContainer)subProcess, "SubProcessMessage");
                this.assertThatElementPresent(false, "after revision", (FlowElementsContainer)subProcess, "OutTimer");
                for (FlowElement subFlow : subProcess.getFlowElements()) {
                    if (!"SubTimer".equals(subFlow.getName())) continue;
                    finalBoundaryEventOutgointIds = (List)unmarshaller.getOutgoingFlowsMap().get(subFlow);
                }
            }
        }
        initialBoundaryEventOutgointIds.equals(finalBoundaryEventOutgointIds);
        unmarshaller = new Bpmn2JsonUnmarshaller();
        parser = new JsonFactory().createJsonParser(Bpmn2UnmarshallingTestCase.getTestJsonFile("boundaryEventsContainers.json"));
        parser.nextToken();
        definitions = (Definitions)unmarshaller.unmarshallItem(parser, "");
        unmarshaller.revisitCatchEvents(definitions);
        unmarshaller.revisitCatchEventsConvertToBoundary(definitions);
        Process process2 = this.getRootProcess(definitions);
        this.assertThatElementPresent(true, "", (FlowElementsContainer)process2, "Timer3");
        this.assertThatElementPresent(true, "", (FlowElementsContainer)process2, "Timer1");
        this.assertThatElementPresent(true, "", (FlowElementsContainer)process2, "Timer2");
        unmarshaller.revisitBoundaryEventsPositions(definitions);
        this.assertThatElementPresent(true, "", (FlowElementsContainer)process2, "Timer3");
        this.assertThatElementPresent(false, "", (FlowElementsContainer)process2, "Timer1");
        this.assertThatElementPresent(false, "", (FlowElementsContainer)process2, "Timer2");
        for (FlowElement flow : process2.getFlowElements()) {
            if ("Subprocess1".equals(flow.getName())) {
                this.assertThatElementPresent(true, "", (FlowElementsContainer)((SubProcess)flow), "Timer1");
            }
            if (!"Subprocess2".equals(flow.getName())) continue;
            this.assertThatElementPresent(true, "", (FlowElementsContainer)((SubProcess)flow), "Timer2");
        }
    }

    private void assertThatElementPresent(boolean expected, String when, FlowElementsContainer where, String which) {
        if (expected) {
            Assert.assertTrue((String)(which + " NOT found in " + where.toString() + " " + when + " but EXPECTED"), (boolean)this.isContainerContainFlowElementByName(where, which));
        } else {
            Assert.assertFalse((String)(which + " FOUND in " + where.toString() + " " + when + " but NOT expected"), (boolean)this.isContainerContainFlowElementByName(where, which));
        }
    }

    private boolean isContainerContainFlowElementByName(FlowElementsContainer container, String elementName) {
        for (FlowElement findingSubTimer : container.getFlowElements()) {
            if (!elementName.equals(findingSubTimer.getName())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testWorkItemHandlerNoParams() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("workItemHandlerNoParams.json"), "Email,HelloWorkItemHandler,Log,Rest,WebService").getContents().get(0);
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof StartEvent));
        StartEvent startEvent = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((String)"TheStart", (String)startEvent.getName());
        Task task = (Task)process.getFlowElements().get(1);
        Assert.assertEquals((String)"HelloWorldService", (String)task.getName());
        SequenceFlow flow = (SequenceFlow)process.getFlowElements().get(2);
        Assert.assertEquals((String)"flow1", (String)flow.getName());
        Assert.assertEquals((Object)startEvent, (Object)flow.getSourceRef());
        Assert.assertEquals((Object)task, (Object)flow.getTargetRef());
    }

    private Process getRootProcess(Definitions def) {
        for (RootElement nextRootElement : def.getRootElements()) {
            if (!(nextRootElement instanceof Process)) continue;
            return (Process)nextRootElement;
        }
        return null;
    }

    @Test
    public void testDocumentationPropertyForBoundaryEvents() throws Exception {
        String DOCUMENTATION_VALUE = "<![CDATA[Cancel task on timeout.]]>";
        String BOUNDARY_EVENT_NAME = "CancelOnTimer";
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        JsonParser parser = new JsonFactory().createJsonParser(Bpmn2UnmarshallingTestCase.getTestJsonFile("boundaryEventsDocumentation.json"));
        parser.nextToken();
        Definitions definitions = (Definitions)unmarshaller.unmarshallItem(parser, "");
        unmarshaller.revisitCatchEvents(definitions);
        unmarshaller.revisitCatchEventsConvertToBoundary(definitions);
        unmarshaller.revisitBoundaryEventsPositions(definitions);
        boolean documentationChecked = false;
        block0: for (RootElement root : definitions.getRootElements()) {
            if (!(root instanceof Process)) continue;
            for (FlowElement flow : ((Process)root).getFlowElements()) {
                if (!"CancelOnTimer".equals(flow.getName())) continue;
                Assert.assertTrue((String)"CancelOnTimer have no documentation.", (flow.getDocumentation().size() > 0 ? 1 : 0) != 0);
                Assert.assertEquals((String)"<![CDATA[Cancel task on timeout.]]>", (String)((Documentation)flow.getDocumentation().get(0)).getText());
                documentationChecked = true;
                continue block0;
            }
        }
        Assert.assertTrue((String)"Boundary Event 'CancelOnTimer' is not found in the process.", (boolean)documentationChecked);
    }

    @Test
    public void testDocumentationForSwimlane() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = (Definitions)unmarshaller.unmarshall(Bpmn2UnmarshallingTestCase.getTestJsonFile("swimlane.json"), "").getContents().get(0);
        Process process = this.getRootProcess(definitions);
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        Assert.assertEquals((String)"Swimlane name is wrong.", (String)lane.getName(), (String)"Documented Swimlane");
        Assert.assertEquals((String)"<![CDATA[Some documentation for swimlane.]]>", (String)((Documentation)lane.getDocumentation().get(0)).getText());
    }
}

