/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.repository.impl;

import bpsim.impl.BpsimPackageImpl;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.designer.notification.DesignerNotificationEvent;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.repository.IUUIDBasedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class UUIDBasedJbpmRepository
implements IUUIDBasedRepository {
    @Inject
    private Event<DesignerNotificationEvent> notification;
    @Inject
    private User user;
    private static final Logger _logger = LoggerFactory.getLogger(UUIDBasedJbpmRepository.class);
    private static final String DEFAULTS_PATH = "defaults";
    private String _defaultsPath;

    @Override
    public void configure(HttpServlet servlet) {
        this._defaultsPath = servlet.getServletContext().getRealPath("/defaults");
    }

    @Override
    public byte[] load(HttpServletRequest req, String uuid, IDiagramProfile profile, ServletContext servletContext) throws Exception {
        Repository repository = profile.getRepository();
        String preProcessingParam = req.getParameter("pp");
        String processxml = (String)repository.loadAsset(uuid).getAssetContent();
        if (processxml != null && processxml.length() > 0) {
            try {
                DroolsPackageImpl.init();
                BpsimPackageImpl.init();
                String processjson = profile.createUnmarshaller().parseModel(processxml, profile, preProcessingParam);
                return processjson.getBytes("UTF-8");
            }
            catch (Exception e) {
                return this.loadDefaultProcess(profile, preProcessingParam);
            }
        }
        return this.loadDefaultProcess(profile, preProcessingParam);
    }

    private byte[] loadDefaultProcess(IDiagramProfile profile, String preProcessingParam) {
        try {
            String defaultProcessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"${processid}\" drools:packageName=\"org.jbpm\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>".replaceAll("\\$\\{processid\\}", "defaultprocessid");
            String processjson = profile.createUnmarshaller().parseModel(defaultProcessContent, profile, preProcessingParam);
            String errorMessages = "openinxmleditor";
            this.notification.fire((Object)new DesignerNotificationEvent(errorMessages, NotificationEvent.NotificationType.ERROR, this.user.getIdentifier()));
            return processjson.getBytes("UTF-8");
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    @Override
    public void save(HttpServletRequest req, String uuid, String json, String svg, IDiagramProfile profile, Boolean autosave) {
    }

    @Override
    public String toXML(String json, IDiagramProfile profile, String preProcessingData) throws Exception {
        return profile.createMarshaller().parseModel(json, preProcessingData);
    }
}

