/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.utils;

import bpsim.impl.BpsimPackageImpl;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.DefaultProfileImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bpmn2Loader {
    private Class testClass;
    private String processJson;
    DefaultProfileImpl profile = new DefaultProfileImpl();
    IDiagramProfile.IDiagramUnmarshaller marshaller = this.profile.createUnmarshaller();
    IDiagramProfile.IDiagramMarshaller unmarshaller = this.profile.createMarshaller();

    public Bpmn2Loader(Class testClass) {
        this.testClass = testClass;
    }

    public Definitions loadProcessFromJson(String fileName) throws Exception {
        URL fileURL = this.testClass.getResource(fileName);
        String json = new String(FileUtils.readFileToString((File)new File(fileURL.toURI())));
        return this.unmarshaller.getDefinitions(json, "Email,HelloWorkItemHandler,Log,Rest,WebService");
    }

    public JSONObject loadProcessFromXml(String fileName, Class nonDefaultTestClass) throws Exception {
        URL fileURL = nonDefaultTestClass.getResource(fileName);
        String definition = new String(FileUtils.readFileToString((File)new File(fileURL.toURI())));
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        this.processJson = this.marshaller.parseModel(definition, (IDiagramProfile)this.profile, "Email,HelloWorkItemHandler,Log,Rest,WebService");
        JSONObject process = new JSONObject(this.processJson);
        if ("BPMNDiagram".equals(process.getJSONObject("stencil").getString("id"))) {
            return process;
        }
        throw new IllegalArgumentException("File " + fileName + " is not a valid BPMN2 process JSON");
    }

    public JSONObject loadProcessFromXml(String fileName) throws Exception {
        return this.loadProcessFromXml(fileName, this.testClass);
    }

    public static JSONObject getChildByName(JSONObject parent, String name) throws JSONException {
        JSONArray children = parent.getJSONArray("childShapes");
        for (int i = 0; i < children.length(); ++i) {
            JSONObject child = children.getJSONObject(i);
            if (!name.equals(Bpmn2Loader.getPropertyValue(child, "name"))) continue;
            return child;
        }
        return null;
    }

    public static String getDocumentationFor(JSONObject bpmnElement) throws JSONException {
        return Bpmn2Loader.getPropertyValue(bpmnElement, "documentation");
    }

    private static String getPropertyValue(JSONObject bpmnElement, String propertyName) throws JSONException {
        return bpmnElement.getJSONObject("properties").getString(propertyName);
    }

    public DefaultProfileImpl getProfile() {
        return this.profile;
    }

    public String getProcessJson() {
        return this.processJson;
    }

    public IDiagramProfile.IDiagramMarshaller getUnmarshaller() {
        return this.unmarshaller;
    }
}

