/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.editorhandler;

import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.server.EditorHandler;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EditorHandlerBaseTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @Spy
    @InjectMocks
    private EditorHandler editorHandler = new EditorHandler();

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testGetInstanceViewMode() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceviewmode", "false");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
        params.put("instanceviewmode", "true");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"true");
        params.remove("instanceviewmode");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
    }

    @Test
    public void testDoShowPDFDoc() throws Exception {
        try {
            VFSRepository repository = new VFSRepository(this.producer.getIoService());
            repository.setDescriptor(this.descriptor);
            this.profile.setRepository((Repository)repository);
            TestServletConfig config = new TestServletConfig(new TestServletContext((Repository)repository));
            Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
            config.getServletContext().setInitParameter("designer.showpdfdoc", "false");
            Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
            config.getServletContext().setInitParameter("designer.showpdfdoc", "true");
            Assert.assertTrue((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
            config.getServletContext().setInitParameter("designer.showpdfdoc", "true");
            System.setProperty("designer.showpdfdoc", "false");
            Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
            config.getServletContext().setInitParameter("designer.showpdfdoc", "false");
            System.setProperty("designer.showpdfdoc", "true");
            Assert.assertTrue((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
        }
        finally {
            System.clearProperty("designer.showpdfdoc");
        }
    }

    @Test
    public void testDoGetFindProfile() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.editorHandler.doGet(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoGetProfileAlreadySet() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.editorHandler.setProfile((IDiagramProfile)this.profile);
        try {
            this.editorHandler.doGet(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }
}

