/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JbpmPreprocessingUnitVFSGitTest {
    private static final String REPOSITORY_ROOT = "designer-playground";
    private static final String VFS_REPOSITORY_ROOT = "git://designer-playground";
    private static final String USERNAME = "guvnorngtestuser1";
    private static final String PASSWORD = "test1234";
    private static final String ORIGIN_URL = "https://github.com/mswiderski/designer-playground.git";
    private static final String FETCH_COMMAND = "?fetch";
    private JbpmProfileImpl profile;
    private static String gitLocalClone = System.getProperty("java.io.tmpdir") + "git-repo";
    private static Map<String, String> env = new HashMap<String, String>();
    private static int counter = -100;
    private RepositoryDescriptor descriptor;
    private VFSFileSystemProducer producer = new VFSFileSystemProducer();

    @BeforeClass
    public static void prepare() {
        env.put("username", USERNAME);
        env.put("password", PASSWORD);
        env.put("origin", ORIGIN_URL);
        env.put("fetch.cmd", FETCH_COMMAND);
        System.setProperty("org.kie.nio.git.dir", gitLocalClone);
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.kie.nio.git.dir");
    }

    @Before
    public void setup() {
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    private void deleteFiles(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteFiles(file);
            }
            file.delete();
        }
    }

    @After
    public void teardown() {
        File repo = new File(gitLocalClone);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
        repo = new File(".niogit");
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
        ++counter;
    }

    @Test
    public void testProprocess() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("process").location("/myprocesses");
        String uniqueId = repository.createAsset(builder.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit((ServletContext)new TestServletContext(), "/", null, null, null, null, null, null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(params), null, (IDiagramProfile)new TestIDiagramProfile((Repository)repository), null, false, false, null, null);
        Collection globalAssets = repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)31L, (long)globalAssets.size());
        repository.assetExists("/global/backboneformsinclude.fw");
        repository.assetExists("/global/backbonejsinclude.fw");
        repository.assetExists("/global/cancelbutton.fw");
        repository.assetExists("/global/checkbox.fw");
        repository.assetExists("/global/customeditors.json");
        repository.assetExists("/global/div.fw");
        repository.assetExists("/global/dropdownmenu.fw");
        repository.assetExists("/global/fieldset.fw");
        repository.assetExists("/global/form.fw");
        repository.assetExists("/global/handlebarsinclude.fw");
        repository.assetExists("/global/htmlbasepage.fw");
        repository.assetExists("/global/image.fw");
        repository.assetExists("/global/jqueryinclude.fw");
        repository.assetExists("/global/jquerymobileinclude.fw");
        repository.assetExists("/global/link.fw");
        repository.assetExists("/global/mobilebasepage.fw");
        repository.assetExists("/global/orderedlist.fw");
        repository.assetExists("/global/passwordfield.fw");
        repository.assetExists("/global/radiobutton.fw");
        repository.assetExists("/global/script.fw");
        repository.assetExists("/global/submitbutton.fw");
        repository.assetExists("/global/table.fw");
        repository.assetExists("/global/textarea.fw");
        repository.assetExists("/global/textfield.fw");
        repository.assetExists("/global/themes.json");
        repository.assetExists("/global/unorderedlist.fw");
        repository.assetExists("/global/defaultemailicon.gif");
        repository.assetExists("/global/defaultlogicon.gif");
        repository.assetExists("/global/defaultservicenodeicon.png");
        repository.assetExists("/global/patterns.json");
        repository.assetExists("/global/.gitignore");
        Collection defaultStuff = repository.listAssets("/myprocesses");
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)3L, (long)defaultStuff.size());
        repository.assetExists("/myprocesses/WorkDefinitions.wid");
        repository.assetExists("/myprocesses/process.bpmn2");
        repository.assetExists("/myprocesses/.gitignore");
    }
}

