/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.server.ServiceRepoUtils;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.process.workitem.WorkItemRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ServiceRepoUtilsTest
extends RepositoryBaseTest {
    @Mock
    private VFSService vfsServices;
    @Mock
    private IOService ioService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private POMService pomService;
    @Mock
    private MetadataService metadataService;
    @Captor
    private ArgumentCaptor<NotificationEvent> notificationCaptor;
    @Captor
    private ArgumentCaptor<DesignerWorkitemInstalledEvent> widinstallCaptor;
    protected Event<NotificationEvent> notification = (Event)Mockito.mock(EventSourceMock.class);
    private final List<Object> receivedWidInstallEvents = new ArrayList<Object>();
    private Event<DesignerWorkitemInstalledEvent> widinstall = new EventSourceMock<DesignerWorkitemInstalledEvent>(){

        public void fire(DesignerWorkitemInstalledEvent event) {
            ServiceRepoUtilsTest.this.receivedWidInstallEvents.add(event);
        }
    };

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.vfsServices.get(Matchers.anyString())).thenAnswer((Answer)new Answer<org.uberfire.backend.vfs.Path>(){

            public org.uberfire.backend.vfs.Path answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return PathFactory.newPath((String)((String)args[0]), (String)((String)args[0]));
            }
        });
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testInstallWorkitem() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder bpmn2builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        bpmn2builder.content((Object)"bpmn2 content").type("bpmn2").name("samplebpmn2process").location("/src/main/resources");
        String bpmn2AssetID = repository.createAsset(bpmn2builder.getAsset());
        Assert.assertNotNull((Object)bpmn2AssetID);
        AssetBuilder pomBuilder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        pomBuilder.content((Object)"").type("xml").name("pom").location("/");
        String pomAssetID = repository.createAsset(pomBuilder.getAsset());
        Assert.assertNotNull((Object)pomAssetID);
        Collection foundAsset = repository.listAssets("/src/main/resources", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)repository.getDescriptor().getRepositoryRootPath());
        String uuid = rootPath.toURI() + "/src/main/resources/samplebpmn2process.bpmn2";
        String pomuuid = rootPath.toURI() + "/pom.xml";
        KieProject project = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)project.getRootPath()).thenReturn((Object)rootPath);
        org.uberfire.backend.vfs.Path pomXmlPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)project.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        Mockito.when((Object)pomXmlPath.toURI()).thenReturn((Object)pomuuid);
        Mockito.when((Object)project.getPomXMLPath()).thenReturn((Object)pomXmlPath);
        POM projectPOM = new POM();
        Mockito.when((Object)this.pomService.load(pomXmlPath)).thenReturn((Object)projectPOM);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)project);
        Map workitemsFromRepo = WorkItemRepository.getWorkDefinitions((String)this.getClass().getResource("servicerepo").toURI().toString());
        Assert.assertNotNull(workitemsFromRepo.get("Rewardsystem"));
        WorkDefinitionImpl rewardSystemWorkItem = (WorkDefinitionImpl)workitemsFromRepo.get("Rewardsystem");
        Assert.assertEquals((Object)"Rewardsystem", (Object)rewardSystemWorkItem.getName());
        Assert.assertNull((Object)rewardSystemWorkItem.getIcon());
        ServiceRepoUtils.installWorkItem((Map)workitemsFromRepo, (String)"Rewardsystem", (String)uuid, (Repository)repository, (VFSService)this.vfsServices, this.widinstall, this.notification, (POMService)this.pomService, (ProjectService)this.projectService, (MetadataService)this.metadataService);
        Assert.assertEquals((long)1L, (long)this.receivedWidInstallEvents.size());
        Object event = this.receivedWidInstallEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof DesignerWorkitemInstalledEvent));
        DesignerWorkitemInstalledEvent eventReceived = (DesignerWorkitemInstalledEvent)event;
        Assert.assertEquals((Object)"Rewardsystem", (Object)eventReceived.getName());
        Assert.assertEquals((Object)"mvel: com.rewardsystem.MyRewardsHandler()", (Object)eventReceived.getValue());
        Assert.assertNotNull((Object)projectPOM);
        Assert.assertNotNull((Object)projectPOM.getDependencies());
        Assert.assertEquals((long)2L, (long)projectPOM.getDependencies().size());
        Dependencies pomDepends = projectPOM.getDependencies();
        Dependency depends1 = pomDepends.get(0);
        Assert.assertNotNull((Object)depends1);
        Assert.assertEquals((Object)"com.rewardssystem", (Object)depends1.getGroupId());
        Assert.assertEquals((Object)"myrewardssystem", (Object)depends1.getArtifactId());
        Assert.assertEquals((Object)"2.0", (Object)depends1.getVersion());
        Dependency depends2 = pomDepends.get(1);
        Assert.assertNotNull((Object)depends2);
        Assert.assertEquals((Object)"com.rewardssystem", (Object)depends2.getGroupId());
        Assert.assertEquals((Object)"systemhelper", (Object)depends2.getArtifactId());
        Assert.assertEquals((Object)"1.2", (Object)depends2.getVersion());
    }
}

