/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class EPCUpload
extends HttpServlet {
    private static final long serialVersionUID = 316274845723034029L;

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        InputStream inputStream;
        List items;
        boolean isMultipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (!isMultipartContent) {
            this.printError(res, "No Multipart Content transmitted.");
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
        servletFileUpload.setSizeMax(-1L);
        try {
            items = servletFileUpload.parseRequest(req);
            if (items.size() != 1) {
                this.printError(res, "Not exactly one File.");
                return;
            }
        }
        catch (FileUploadException e) {
            this.handleException(res, (Exception)((Object)e));
            return;
        }
        FileItem fileItem = (FileItem)items.get(0);
        String fileName = fileItem.getName();
        String content = fileItem.getString();
        try {
            inputStream = fileItem.getInputStream();
        }
        catch (IOException e) {
            this.handleException(res, e);
            return;
        }
        String xsltFilename = this.getServletContext().getRealPath("/xslt/EPML2eRDF.xslt");
        File epml2eRDFxsltFile = new File(xsltFilename);
        StreamSource epml2eRDFxsltSource = new StreamSource(epml2eRDFxsltFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!fileName.endsWith(".epml") && !content.contains("http://www.epml.de")) {
            this.printError(res, "No EPML or AML file uploaded.");
            return;
        }
        StreamSource epmlSource = new StreamSource(inputStream);
        String resultString = null;
        try {
            Transformer transformer = transformerFactory.newTransformer(epml2eRDFxsltSource);
            StringWriter writer = new StringWriter();
            transformer.transform(epmlSource, new StreamResult(writer));
            resultString = writer.toString();
        }
        catch (Exception e) {
            this.handleException(res, e);
            return;
        }
        if (resultString != null) {
            try {
                this.printResponse(res, resultString);
            }
            catch (Exception e) {
                this.handleException(res, e);
                return;
            }
        }
    }

    private void printResponse(HttpServletResponse res, String text) {
        if (res != null) {
            res.setContentType("text/plain");
            try {
                PrintWriter out = res.getWriter();
                out.print(text);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void printError(HttpServletResponse res, String err) {
        if (res != null) {
            res.setContentType("text/html");
            try {
                PrintWriter out = res.getWriter();
                out.print("{success:false, content:'" + err + "'}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleException(HttpServletResponse res, Exception e) {
        e.printStackTrace();
        this.printError(res, e.getLocalizedMessage());
    }
}

