/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TaskFormsServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TaskFormsServletTest
extends RepositoryBaseTest {
    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Ignore
    @Test
    public void testTaskFormServlet() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("hello").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("src/test/resources/BPMN2-DefaultProcess.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        TaskFormsServlet taskFormsServlet = new TaskFormsServlet();
        taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
        Assert.assertEquals((Object)"hello-taskform", (Object)((Asset)forms.iterator().next()).getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)((Asset)forms.iterator().next()).getAssetLocation());
        Asset form = repository.loadAsset(((Asset)forms.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)form.getAssetContent());
    }

    @Ignore
    @Test
    public void testTaskFormServletWithUserTask() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("userTask").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("src/test/resources/BPMN2-UserTask.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        TaskFormsServlet taskFormsServlet = new TaskFormsServlet();
        taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)2L, (long)forms.size());
        Iterator assets = forms.iterator();
        Asset asset1 = (Asset)assets.next();
        Assert.assertEquals((Object)"evaluate-taskform", (Object)asset1.getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)asset1.getAssetLocation());
        Asset asset2 = (Asset)assets.next();
        Assert.assertEquals((Object)"testprocess-taskform", (Object)asset2.getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)asset2.getAssetLocation());
        Asset form1 = repository.loadAsset(asset1.getUniqueId());
        Assert.assertNotNull((Object)form1.getAssetContent());
        Asset form2 = repository.loadAsset(asset2.getUniqueId());
        Assert.assertNotNull((Object)form2.getAssetContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = new Scanner(new File(pathname), "UTF-8");
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }
}

