/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingService;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingUnit;
import org.jbpm.designer.web.preprocessing.impl.DefaultPreprocessingUnit;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.workbench.events.NotificationEvent;

public class PreprocessingServiceImpl
implements IDiagramPreprocessingService {
    public static final PreprocessingServiceImpl INSTANCE = new PreprocessingServiceImpl();
    private Map<String, IDiagramPreprocessingUnit> _registry = new HashMap<String, IDiagramPreprocessingUnit>();

    @Override
    public Collection<IDiagramPreprocessingUnit> getRegisteredPreprocessingUnits(HttpServletRequest request) {
        HashMap<String, IDiagramPreprocessingUnit> preprocessingUnits = new HashMap<String, IDiagramPreprocessingUnit>(this._registry);
        return new ArrayList<IDiagramPreprocessingUnit>(preprocessingUnits.values());
    }

    @Override
    public IDiagramPreprocessingUnit findPreprocessingUnit(HttpServletRequest request, IDiagramProfile profile) {
        HashMap<String, IDiagramPreprocessingUnit> preprocessingUnits = new HashMap<String, IDiagramPreprocessingUnit>(this._registry);
        return (IDiagramPreprocessingUnit)preprocessingUnits.get(profile.getName());
    }

    @Override
    public void init(ServletContext context, VFSService vfsService, Event<DesignerWorkitemInstalledEvent> workitemInstalledEventEvent, Event<NotificationEvent> notification, POMService pomService, ProjectService projectService, MetadataService metadataService) {
        this._registry.put("default", new DefaultPreprocessingUnit(context, vfsService, workitemInstalledEventEvent, notification, pomService, projectService, metadataService));
        this._registry.put("jbpm", new JbpmPreprocessingUnit(context, vfsService, workitemInstalledEventEvent, notification, pomService, projectService, metadataService));
    }
}

