/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.designer.server.diagram.Bounds;
import org.jbpm.designer.server.diagram.Diagram;
import org.jbpm.designer.server.diagram.Point;
import org.jbpm.designer.server.diagram.Shape;
import org.jbpm.designer.server.diagram.StencilSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder {
    public static String parseModeltoString(Diagram diagram) throws JSONException {
        return JSONBuilder.parseModel(diagram).toString();
    }

    public static JSONObject parseModel(Diagram diagram) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("resourceId", (Object)diagram.getResourceId().toString());
        json.put("properties", (Object)JSONBuilder.parseProperties(diagram.getProperties()));
        json.put("stencil", (Object)JSONBuilder.parseStencil(diagram.getStencilId()));
        json.put("childShapes", (Object)JSONBuilder.parseChildShapesRecursive(diagram.getChildShapes()));
        json.put("bounds", (Object)JSONBuilder.parseBounds(diagram.getBounds()));
        json.put("stencilset", (Object)JSONBuilder.parseStencilSet(diagram.getStencilset()));
        json.put("ssextensions", (Object)JSONBuilder.parseStencilSetExtensions(diagram.getSsextensions()));
        return json;
    }

    private static JSONObject parseStencil(String stencilId) throws JSONException {
        JSONObject stencilObject = new JSONObject();
        stencilObject.put("id", (Object)stencilId.toString());
        return stencilObject;
    }

    private static JSONArray parseChildShapesRecursive(ArrayList<Shape> childShapes) throws JSONException {
        if (childShapes != null) {
            JSONArray childShapesArray = new JSONArray();
            for (Shape childShape : childShapes) {
                JSONObject childShapeObject = new JSONObject();
                childShapeObject.put("resourceId", (Object)childShape.getResourceId().toString());
                childShapeObject.put("properties", (Object)JSONBuilder.parseProperties(childShape.getProperties()));
                childShapeObject.put("stencil", (Object)JSONBuilder.parseStencil(childShape.getStencilId()));
                childShapeObject.put("childShapes", (Object)JSONBuilder.parseChildShapesRecursive(childShape.getChildShapes()));
                childShapeObject.put("outgoing", (Object)JSONBuilder.parseOutgoings(childShape.getOutgoings()));
                childShapeObject.put("bounds", (Object)JSONBuilder.parseBounds(childShape.getBounds()));
                childShapeObject.put("dockers", (Object)JSONBuilder.parseDockers(childShape.getDockers()));
                if (childShape.getTarget() != null) {
                    childShapeObject.put("target", (Object)JSONBuilder.parseTarget(childShape.getTarget()));
                }
                childShapesArray.put((Object)childShapeObject);
            }
            return childShapesArray;
        }
        return new JSONArray();
    }

    private static JSONObject parseTarget(Shape target) throws JSONException {
        JSONObject targetObject = new JSONObject();
        targetObject.put("resourceId", (Object)target.getResourceId().toString());
        return targetObject;
    }

    private static JSONArray parseDockers(ArrayList<Point> dockers) throws JSONException {
        if (dockers != null) {
            JSONArray dockersArray = new JSONArray();
            for (Point docker : dockers) {
                JSONObject dockerObject = new JSONObject();
                dockerObject.put("x", docker.getX().doubleValue());
                dockerObject.put("y", docker.getY().doubleValue());
                dockersArray.put((Object)dockerObject);
            }
            return dockersArray;
        }
        return new JSONArray();
    }

    private static JSONArray parseOutgoings(ArrayList<Shape> outgoings) throws JSONException {
        if (outgoings != null) {
            JSONArray outgoingsArray = new JSONArray();
            for (Shape outgoing : outgoings) {
                JSONObject outgoingObject = new JSONObject();
                outgoingObject.put("resourceId", (Object)outgoing.getResourceId().toString());
                outgoingsArray.put((Object)outgoingObject);
            }
            return outgoingsArray;
        }
        return new JSONArray();
    }

    private static JSONObject parseProperties(HashMap<String, String> properties) throws JSONException {
        if (properties != null) {
            JSONObject propertiesObject = new JSONObject();
            for (String key : properties.keySet()) {
                String propertyValue = properties.get(key);
                if (propertyValue.startsWith("{") && propertyValue.endsWith("}")) {
                    propertiesObject.put(key, (Object)new JSONObject(propertyValue));
                    continue;
                }
                propertiesObject.put(key, (Object)propertyValue.toString());
            }
            return propertiesObject;
        }
        return new JSONObject();
    }

    private static JSONArray parseStencilSetExtensions(ArrayList<String> extensions) {
        if (extensions != null) {
            JSONArray extensionsArray = new JSONArray();
            for (String extension : extensions) {
                extensionsArray.put((Object)extension.toString());
            }
            return extensionsArray;
        }
        return new JSONArray();
    }

    private static JSONObject parseStencilSet(StencilSet stencilSet) throws JSONException {
        if (stencilSet != null) {
            JSONObject stencilSetObject = new JSONObject();
            stencilSetObject.put("url", (Object)stencilSet.getUrl().toString());
            stencilSetObject.put("namespace", (Object)stencilSet.getNamespace().toString());
            return stencilSetObject;
        }
        return new JSONObject();
    }

    private static JSONObject parseBounds(Bounds bounds) throws JSONException {
        if (bounds != null) {
            JSONObject boundsObject = new JSONObject();
            JSONObject lowerRight = new JSONObject();
            JSONObject upperLeft = new JSONObject();
            lowerRight.put("x", bounds.getLowerRight().getX().doubleValue());
            lowerRight.put("y", bounds.getLowerRight().getY().doubleValue());
            upperLeft.put("x", bounds.getUpperLeft().getX().doubleValue());
            upperLeft.put("y", bounds.getUpperLeft().getY().doubleValue());
            boundsObject.put("lowerRight", (Object)lowerRight);
            boundsObject.put("upperLeft", (Object)upperLeft);
            return boundsObject;
        }
        return new JSONObject();
    }
}

