/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.stringtemplate.v4.ST;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmPreprocessingUnitVFSGitTest
extends RepositoryBaseTest {
    private static final String REPOSITORY_ROOT = "designer-playground";
    private static final String VFS_REPOSITORY_ROOT = "git://designer-playground";
    private static final String USERNAME = "guvnorngtestuser1";
    private static final String PASSWORD = "test1234";
    private static final String ORIGIN_URL = "https://github.com/mswiderski/designer-playground.git";
    private static final String FETCH_COMMAND = "?fetch";
    private static String gitLocalClone = System.getProperty("java.io.tmpdir") + "git-repo";
    private static Map<String, String> env = new HashMap<String, String>();
    private VFSFileSystemProducer producer = new VFSFileSystemProducer();
    @Spy
    @InjectMocks
    private JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();

    @BeforeClass
    public static void prepare() {
        env.put("username", USERNAME);
        env.put("password", PASSWORD);
        env.put("origin", ORIGIN_URL);
        env.put("fetch.cmd", FETCH_COMMAND);
        System.setProperty("org.kie.nio.git.dir", gitLocalClone);
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.kie.nio.git.dir");
    }

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testProprocess() {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("process").location("/myprocesses");
        String uniqueId = repository.createAsset(builder.getAsset());
        this.preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(params), null, (IDiagramProfile)new TestIDiagramProfile(repository), null, false, false, null, null);
        Collection globalAssets = repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)31L, (long)globalAssets.size());
        repository.assetExists("/global/backboneformsinclude.fw");
        repository.assetExists("/global/backbonejsinclude.fw");
        repository.assetExists("/global/cancelbutton.fw");
        repository.assetExists("/global/checkbox.fw");
        repository.assetExists("/global/customeditors.json");
        repository.assetExists("/global/div.fw");
        repository.assetExists("/global/dropdownmenu.fw");
        repository.assetExists("/global/fieldset.fw");
        repository.assetExists("/global/form.fw");
        repository.assetExists("/global/handlebarsinclude.fw");
        repository.assetExists("/global/htmlbasepage.fw");
        repository.assetExists("/global/image.fw");
        repository.assetExists("/global/jqueryinclude.fw");
        repository.assetExists("/global/jquerymobileinclude.fw");
        repository.assetExists("/global/link.fw");
        repository.assetExists("/global/mobilebasepage.fw");
        repository.assetExists("/global/orderedlist.fw");
        repository.assetExists("/global/passwordfield.fw");
        repository.assetExists("/global/radiobutton.fw");
        repository.assetExists("/global/script.fw");
        repository.assetExists("/global/submitbutton.fw");
        repository.assetExists("/global/table.fw");
        repository.assetExists("/global/textarea.fw");
        repository.assetExists("/global/textfield.fw");
        repository.assetExists("/global/themes.json");
        repository.assetExists("/global/unorderedlist.fw");
        repository.assetExists("/global/defaultemailicon.gif");
        repository.assetExists("/global/defaultmilestoneicon.png");
        repository.assetExists("/global/defaultlogicon.gif");
        repository.assetExists("/global/defaultservicenodeicon.png");
        repository.assetExists("/global/patterns.json");
        repository.assetExists("/global/.gitignore");
        Collection defaultStuff = repository.listAssets("/myprocesses");
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)2L, (long)defaultStuff.size());
        repository.assetExists("/myprocesses/WorkDefinitions.wid");
        repository.assetExists("/myprocesses/process.bpmn2");
        repository.assetExists("/myprocesses/.gitignore");
    }

    @Test
    public void testEmptyCustomEditor() throws Exception {
        Repository repository = this.createRepository();
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"import org.drools.core.process.core.datatype.impl.type.StringDataType;\n\n[\n\n  [\n    \"name\" : \"Rewardsystem\",\n    \"description\" : \"Notifies the Reward System\",\n    \"displayName\" : \"Rewardsystem\",\n    \"defaultHandler\": \"mvel: com.rewardsystem.MyRewardsHandler()\",\n    \"category\" : \"Rewards\",\n    \"customEditor\" : \"\",\n    \"icon\" : \"widicon.png\",\n  ]\n\n]").type("wid").name("processwid").location("/myprocesses");
        String uniqueWidID = repository.createAsset(builder.getAsset());
        AssetBuilder builder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder2.content((Object)"".getBytes()).type("png").name("widicon").location("/myprocesses");
        String uniqueIconID = repository.createAsset(builder2.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
        preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", null);
        Asset widAsset = repository.loadAsset(uniqueWidID);
        HashMap workDefinitions = new HashMap();
        preprocessingUnitVFS.evaluateWorkDefinitions(workDefinitions, widAsset, widAsset.getAssetLocation(), repository);
        Assert.assertNotNull(workDefinitions);
        Assert.assertEquals((long)1L, (long)workDefinitions.size());
        Assert.assertTrue((boolean)workDefinitions.containsKey("Rewardsystem"));
        Assert.assertTrue((((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).getCustomEditor() == null ? 1 : 0) != 0);
        ST workItemTemplate = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate.add("workitemDefs", workDefinitions);
        Assert.assertFalse((boolean)workItemTemplate.render().contains("CEdefined"));
        Assert.assertTrue((boolean)workItemTemplate.render().contains("CEnotdefined"));
        ((WorkDefinitionImpl)workDefinitions.get("Rewardsystem")).setCustomEditor("myRewardsCustomEditor");
        ST workItemTemplate2 = new ST("$workitemDefs:{k| $if(workitemDefs.(k).customEditor)$CEdefined$else$CEnotdefined$endif$ }$", '$', '$');
        workItemTemplate2.add("workitemDefs", workDefinitions);
        Assert.assertTrue((boolean)workItemTemplate2.render().contains("CEdefined"));
        Assert.assertFalse((boolean)workItemTemplate2.render().contains("CEnotdefined"));
    }
}

