/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.jbpm.designer.server.indexing.TestBPMN2FileIndexer;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindAllChangeImpactQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindResourcesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class BPMN2FileIndexerIndexingTest
extends BaseIndexingTest<Bpmn2TypeDefinition> {
    private static final String DEPLOYMENT_ID = "org.kjar:test:1.0";

    protected Set<NamedQuery> getQueries() {
        return new HashSet<NamedQuery>(){
            {
                this.add(new FindResourcesQuery(){

                    public ResponseBuilder getResponseBuilder() {
                        return new DefaultResponseBuilder(BPMN2FileIndexerIndexingTest.this.ioService());
                    }
                });
                this.add(new FindAllChangeImpactQuery(){

                    public ResponseBuilder getResponseBuilder() {
                        return new DefaultResponseBuilder(BPMN2FileIndexerIndexingTest.this.ioService());
                    }
                });
            }
        };
    }

    @Test
    public void testBPMN2Indexing() throws Exception {
        Object response;
        String[] bpmn2Files = new String[]{"callActivity.bpmn2", "callActivityByName.bpmn2", "callActivityCalledSubProcess.bpmn2", "hiring.bpmn2", "multipleRuleTasksWithDataInput.bpmn2", "signal.bpmn2", "brokenSignal.bpmn2"};
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int i = 0; i < bpmn2Files.length; ++i) {
            String bpmn2File = bpmn2Files[i];
            if (!bpmn2File.endsWith("bpmn2")) continue;
            Path path = this.basePath.resolve(bpmn2File);
            pathList.add(path);
            String bpmn2Str = this.loadText(bpmn2File);
            this.ioService().write(path, bpmn2Str, new OpenOption[0]);
        }
        Path[] path = pathList.toArray(new Path[pathList.size()]);
        Thread.sleep(5000L);
        RefactoringPageRequest request = new RefactoringPageRequest(FindResourcesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueResourceIndexTerm("*", ResourceType.BPMN2, ValueIndexTerm.TermSearchType.WILDCARD));
            }
        }, 0, Integer.valueOf(10));
        try {
            response = this.service.query(request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)path.length, (long)response.getPageRowList().size());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"*", (PartType)PartType.RULEFLOW_GROUP, (ValueIndexTerm.TermSearchType)ValueIndexTerm.TermSearchType.WILDCARD).inAllProjects().onAllBranches();
        try {
            response = this.service.queryToList((QueryOperationRequest)request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains((List)response, path[4]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"MySignal", (PartType)PartType.SIGNAL).inAllProjects().onAllBranches();
        try {
            response = this.service.queryToList((QueryOperationRequest)request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains((List)response, path[5]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"BrokenSignal", (PartType)PartType.SIGNAL).inAllProjects().onAllBranches();
        try {
            response = this.service.queryToList((QueryOperationRequest)request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)1L, (long)response.size());
            this.assertResponseContains((List)response, path[6]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
        request = (QueryOperationRequest)QueryOperationRequest.referencesSharedPart((String)"name", (PartType)PartType.GLOBAL).inAllProjects().onAllBranches();
        try {
            response = this.service.queryToList((QueryOperationRequest)request);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)2L, (long)response.size());
            this.assertResponseContains((List)response, path[5]);
            this.assertResponseContains((List)response, path[6]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    protected KieProjectService getProjectService() {
        org.uberfire.backend.vfs.Path mockRoot = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)mockRoot.toURI()).thenReturn((Object)"/a/mock/project/root");
        KieProject mockProject = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)mockProject.getRootPath()).thenReturn((Object)mockRoot);
        Mockito.when((Object)mockProject.getProjectName()).thenReturn((Object)"mockProject");
        POM mockPom = (POM)Mockito.mock(POM.class);
        Mockito.when((Object)mockProject.getPom()).thenReturn((Object)mockPom);
        GAV mockGAV = (GAV)Mockito.mock(GAV.class);
        Mockito.when((Object)mockPom.getGav()).thenReturn((Object)mockGAV);
        Mockito.when((Object)mockGAV.toString()).thenReturn((Object)DEPLOYMENT_ID);
        Package mockPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)mockPackage.getPackageName()).thenReturn((Object)"org.kie.workbench.mock.package");
        KieProjectService mockProjectService = (KieProjectService)Mockito.mock(KieProjectService.class);
        Mockito.when((Object)mockProjectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)mockProject);
        Mockito.when((Object)mockProjectService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)mockPackage);
        return mockProjectService;
    }

    protected TestIndexer getIndexer() {
        return new TestBPMN2FileIndexer();
    }

    protected Bpmn2TypeDefinition getResourceTypeDefinition() {
        return new Bpmn2TypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

