/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.ServiceRepoUtilsTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class JbpmPreprocessingUnitVFSTest
extends RepositoryBaseTest {
    @Mock
    private Event<DesignerWorkitemInstalledEvent> workitemInstalledEvent;
    @Mock
    private Event<NotificationEvent> notificationEvent;
    @Mock
    private POMService pomService;
    @Mock
    private ProjectService<? extends Project> projectService;
    @Mock
    private MetadataService metadataService;
    @Spy
    @InjectMocks
    private JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit();
    private Repository repository;
    private String uniqueId;
    private Map<String, String> params;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.preprocessingUnitVFS.workitemInstalledEventEvent = this.workitemInstalledEvent;
        this.preprocessingUnitVFS.notification = this.notificationEvent;
        this.repository = new VFSRepository(this.producer.getIoService());
        ((VFSRepository)this.repository).setDescriptor(this.descriptor);
        this.profile.setRepository(this.repository);
        this.repository.createDirectory("/myprocesses");
        this.repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("process").location("/myprocesses");
        this.uniqueId = this.repository.createAsset(builder.getAsset());
        this.preprocessingUnitVFS.init((ServletContext)new TestServletContext(), "/", (VFSService)Mockito.mock(VFSService.class));
        this.params = new HashMap<String, String>();
        this.params.put("uuid", this.uniqueId);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
        System.clearProperty("org.jbpm.service.repository");
        System.clearProperty("org.jbpm.service.servicetasknames");
    }

    @Test
    public void testPreprocess() {
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        Collection globalAssets = this.repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)31L, (long)globalAssets.size());
        this.repository.assetExists("/global/backboneformsinclude.fw");
        this.repository.assetExists("/global/backbonejsinclude.fw");
        this.repository.assetExists("/global/cancelbutton.fw");
        this.repository.assetExists("/global/checkbox.fw");
        this.repository.assetExists("/global/customeditors.json");
        this.repository.assetExists("/global/div.fw");
        this.repository.assetExists("/global/dropdownmenu.fw");
        this.repository.assetExists("/global/fieldset.fw");
        this.repository.assetExists("/global/form.fw");
        this.repository.assetExists("/global/handlebarsinclude.fw");
        this.repository.assetExists("/global/htmlbasepage.fw");
        this.repository.assetExists("/global/image.fw");
        this.repository.assetExists("/global/jqueryinclude.fw");
        this.repository.assetExists("/global/jquerymobileinclude.fw");
        this.repository.assetExists("/global/link.fw");
        this.repository.assetExists("/global/mobilebasepage.fw");
        this.repository.assetExists("/global/orderedlist.fw");
        this.repository.assetExists("/global/passwordfield.fw");
        this.repository.assetExists("/global/radiobutton.fw");
        this.repository.assetExists("/global/script.fw");
        this.repository.assetExists("/global/submitbutton.fw");
        this.repository.assetExists("/global/table.fw");
        this.repository.assetExists("/global/textarea.fw");
        this.repository.assetExists("/global/textfield.fw");
        this.repository.assetExists("/global/themes.json");
        this.repository.assetExists("/global/unorderedlist.fw");
        this.repository.assetExists("/global/defaultmilestoneicon.png");
        this.repository.assetExists("/global/defaultemailicon.gif");
        this.repository.assetExists("/global/defaultlogicon.gif");
        this.repository.assetExists("/global/patterns.json");
        this.repository.assetExists("/global/defaultservicenodeicon.png");
        Collection defaultStuff = this.repository.listAssets("/myprocesses");
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)2L, (long)defaultStuff.size());
        this.repository.assetExists("/myprocesses/WorkDefinitions.wid");
        this.repository.assetExists("/myprocesses/process.bpmn2");
    }

    @Test
    public void testInstallDefaultWids() throws Exception {
        System.setProperty("org.jbpm.service.repository", ServiceRepoUtilsTest.class.getResource("servicerepo").toURI().toString());
        System.setProperty("org.jbpm.service.servicetasknames", "SwitchYardService,Rewardsystem");
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.verifyWidsPngsAndGifs(Arrays.asList("/myprocesses/WorkDefinitions.wid", "/myprocesses/SwitchYardService.wid", "/myprocesses/Rewardsystem.wid"), Arrays.asList("/myprocesses/defaultservicenodeicon.png", "/myprocesses/defaultmilestoneicon.png"), Arrays.asList("/myprocesses/switchyard.gif", "/myprocesses/defaultemailicon.gif", "/myprocesses/defaultlogicon.gif"));
        ((Event)Mockito.verify(this.workitemInstalledEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(DesignerWorkitemInstalledEvent.class));
    }

    @Test
    public void testInstallNoServiceRepo() throws Exception {
        System.setProperty("org.jbpm.service.servicetasknames", "SwitchYardService,Rewardsystem");
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.verifyWidsPngsAndGifs(Arrays.asList("/myprocesses/WorkDefinitions.wid"), Arrays.asList("/myprocesses/defaultservicenodeicon.png", "/myprocesses/defaultmilestoneicon.png"), Arrays.asList("/myprocesses/defaultemailicon.gif", "/myprocesses/defaultlogicon.gif"));
        ((Event)Mockito.verify(this.workitemInstalledEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(DesignerWorkitemInstalledEvent.class));
    }

    @Test
    public void testInstallNoServiceTasks() throws Exception {
        System.setProperty("org.jbpm.service.repository", ServiceRepoUtilsTest.class.getResource("servicerepo").toURI().toString());
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.verifyWidsPngsAndGifs(Arrays.asList("/myprocesses/WorkDefinitions.wid"), Arrays.asList("/myprocesses/defaultservicenodeicon.png", "/myprocesses/defaultmilestoneicon.png"), Arrays.asList("/myprocesses/defaultemailicon.gif", "/myprocesses/defaultlogicon.gif"));
        ((Event)Mockito.verify(this.workitemInstalledEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(DesignerWorkitemInstalledEvent.class));
    }

    @Test
    public void testInstallNotExistingTask() throws Exception {
        System.setProperty("org.jbpm.service.repository", ServiceRepoUtilsTest.class.getResource("servicerepo").toURI().toString());
        System.setProperty("org.jbpm.service.servicetasknames", "NonExistingTask");
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.verifyWidsPngsAndGifs(Arrays.asList("/myprocesses/WorkDefinitions.wid"), Arrays.asList("/myprocesses/defaultservicenodeicon.png", "/myprocesses/defaultmilestoneicon.png"), Arrays.asList("/myprocesses/defaultemailicon.gif", "/myprocesses/defaultlogicon.gif"));
        ((Event)Mockito.verify(this.workitemInstalledEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(DesignerWorkitemInstalledEvent.class));
    }

    @Test
    public void testInstallTwice() throws Exception {
        System.setProperty("org.jbpm.service.repository", ServiceRepoUtilsTest.class.getResource("servicerepo").toURI().toString());
        System.setProperty("org.jbpm.service.servicetasknames", "MicrosoftAcademy");
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(this.params), null, (IDiagramProfile)new TestIDiagramProfile(this.repository), null, false, false, null, null);
        this.verifyWidsPngsAndGifs(Arrays.asList("/myprocesses/WorkDefinitions.wid", "/myprocesses/MicrosoftAcademy.wid"), Arrays.asList("/myprocesses/microsoftacademy.png", "/myprocesses/defaultservicenodeicon.png", "/myprocesses/defaultmilestoneicon.png"), Arrays.asList("/myprocesses/defaultemailicon.gif", "/myprocesses/defaultlogicon.gif"));
        ((Event)Mockito.verify(this.workitemInstalledEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(DesignerWorkitemInstalledEvent.class));
    }

    private void verifyWidsPngsAndGifs(List<String> wids, List<String> pngs, List<String> gifs) {
        if (wids != null) {
            Collection storedWids = this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("wid"));
            Assert.assertEquals((long)wids.size(), (long)storedWids.size());
            for (String wid : wids) {
                this.repository.assetExists(wid);
            }
        }
        if (pngs != null) {
            Collection storedPngs = this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("png"));
            Assert.assertEquals((long)pngs.size(), (long)storedPngs.size());
            for (String png : pngs) {
                this.repository.assetExists(png);
            }
        }
        if (gifs != null) {
            Collection storedGifs = this.repository.listAssetsRecursively("/", (Filter)new FilterByExtension("gif"));
            Assert.assertEquals((long)gifs.size(), (long)storedGifs.size());
            for (String gif : gifs) {
                this.repository.assetExists(gif);
            }
        }
    }
}

