/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.GlobalManualTask;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.impl.BPMNEdgeImpl;
import org.eclipse.bpmn2.impl.DataInputImpl;
import org.eclipse.bpmn2.impl.DataOutputImpl;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.dd.di.Edge;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.jboss.drools.impl.MetaDataTypeImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.bpmn2.impl.helpers.SimpleEdge;
import org.jbpm.designer.bpmn2.utils.Bpmn2Loader;
import org.junit.Assert;
import org.junit.Test;

public class Bpmn2UnmarshallingTest {
    private Bpmn2Loader loader = new Bpmn2Loader(Bpmn2UnmarshallingTest.class);

    @Test
    public void testSimpleDefinitionsUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("empty.json");
        Assert.assertEquals((Object)"<![CDATA[my doc]]>", (Object)((Documentation)((RootElement)definitions.getRootElements().get(0)).getDocumentation().iterator().next()).getText());
        Assert.assertEquals((Object)"http://www.w3.org/1999/XPath", (Object)definitions.getExpressionLanguage());
        Assert.assertEquals((Object)"http://www.omg.org/bpmn20", (Object)definitions.getTargetNamespace());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)definitions.getTypeLanguage());
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testSimpleGlobalTaskUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("oneTask.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().iterator().next() instanceof GlobalTask));
        GlobalTask task = (GlobalTask)definitions.getRootElements().iterator().next();
        Assert.assertEquals((Object)"oneTask", (Object)task.getName());
        Assert.assertEquals((Object)"my task doc", (Object)((Documentation)task.getDocumentation().iterator().next()).getText());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    public void testTwoGlobalTasksUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("twoTask.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof GlobalTask));
        GlobalTask task = (GlobalTask)definitions.getRootElements().get(0);
        Assert.assertEquals((Object)"firstTask", (Object)task.getName());
        Assert.assertEquals((Object)"my task doc", (Object)((Documentation)task.getDocumentation().iterator().next()).getText());
        GlobalTask task2 = (GlobalTask)definitions.getRootElements().get(1);
        Assert.assertEquals((Object)"secondTask", (Object)task2.getName());
        Assert.assertEquals((Object)"my task doc too", (Object)((Documentation)task2.getDocumentation().iterator().next()).getText());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testPoolUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("pool.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof Process));
        Process process = this.getRootProcess(definitions);
        Assert.assertEquals((Object)"pool", (Object)process.getName());
        Assert.assertEquals((Object)ProcessType.PRIVATE, (Object)process.getProcessType());
        Assert.assertTrue((boolean)process.isIsClosed());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testLaneUnmarshallingOrdering() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("lane.json", "true");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(definitions.getRootElements().get(0) instanceof Process));
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((process.getLaneSets().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((LaneSet)process.getLaneSets().get(0)).getLanes().size() == 1 ? 1 : 0) != 0);
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        Assert.assertEquals((Object)"my first lane", (Object)lane.getName());
        this.verifyBpmnShapePresent((BaseElement)lane, definitions);
        Task task = (Task)process.getFlowElements().get(4);
        Assert.assertEquals((Object)"task", (Object)task.getName());
        this.verifyBpmnShapePresent((BaseElement)task, definitions);
        Assert.assertEquals((long)0L, (long)this.getDIElementOrder((BaseElement)lane, definitions));
        Assert.assertTrue((this.getDIElementOrder((BaseElement)lane, definitions) < this.getDIElementOrder((BaseElement)task, definitions) ? 1 : 0) != 0);
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testLaneUnmarshallingWithoutOrdering() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("lane.json", "false");
        Process process = this.getRootProcess(definitions);
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        this.verifyBpmnShapePresent((BaseElement)lane, definitions);
        Task task = (Task)process.getFlowElements().get(4);
        this.verifyBpmnShapePresent((BaseElement)task, definitions);
        Assert.assertNotEquals((long)-1L, (long)this.getDIElementOrder((BaseElement)task, definitions));
        Assert.assertNotEquals((long)0L, (long)this.getDIElementOrder((BaseElement)lane, definitions));
        Assert.assertTrue((this.getDIElementOrder((BaseElement)lane, definitions) > this.getDIElementOrder((BaseElement)task, definitions) ? 1 : 0) != 0);
    }

    @Test
    public void testNestedElementsOrdering() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("nestedElements.json", "true");
        Process process = this.getRootProcess(definitions);
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        Assert.assertEquals((long)0L, (long)this.getDIElementOrder((BaseElement)lane, definitions));
        SubProcess subProcess = (SubProcess)this.getFlowElement(process.getFlowElements(), "subprocess");
        Assert.assertNull((Object)subProcess.getLoopCharacteristics());
        Assert.assertEquals((long)1L, (long)this.getDIElementOrder((BaseElement)subProcess, definitions));
        UserTask task = (UserTask)this.getFlowElement(subProcess.getFlowElements(), "task");
        Assert.assertEquals((long)2L, (long)this.getDIElementOrder((BaseElement)task, definitions));
        BoundaryEvent event = (BoundaryEvent)this.getFlowElement(subProcess.getFlowElements(), "boundary");
        Assert.assertEquals((long)3L, (long)this.getDIElementOrder((BaseElement)event, definitions));
    }

    @Test
    public void testSequenceFlowUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("sequenceFlow.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof Task));
        Task task = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"task1", (Object)task.getName());
        Task task2 = (Task)process.getFlowElements().get(1);
        Assert.assertEquals((Object)"task2", (Object)task2.getName());
        SequenceFlow flow = (SequenceFlow)process.getFlowElements().get(2);
        Assert.assertEquals((Object)"seqFlow", (Object)flow.getName());
        Assert.assertEquals((Object)task, (Object)flow.getSourceRef());
        Assert.assertEquals((Object)task2, (Object)flow.getTargetRef());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)this.getBpmnEdges((BaseElement)flow, definitions).size());
    }

    @Test
    public void testScriptTaskUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("scriptTask.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        FlowElement element = this.getFlowElement(process.getFlowElements(), "scriptTask");
        if (element == null || !(element instanceof ScriptTask)) {
            Assert.fail((String)"Script task not found");
        }
        ScriptTask scriptTask = (ScriptTask)element;
        Assert.assertEquals((Object)"<![CDATA[System.out.println(\"xyz\");]]>", (Object)scriptTask.getScript());
        Assert.assertEquals((Object)"http://www.java.com/java", (Object)scriptTask.getScriptFormat());
        Assert.assertEquals((Object)"<![CDATA[Prints something to output]]>", (Object)((Documentation)scriptTask.getDocumentation().get(0)).getText());
        Assert.assertEquals((Object)"<![CDATA[scriptTask]]>", (Object)this.getMetaDataValue(scriptTask.getExtensionValues(), "elementname"));
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(scriptTask.getExtensionValues(), "customAsync"));
        Assert.assertEquals((Object)"<![CDATA[System.out.println(\"entry\");]]>", (Object)this.getOnEntryScript(scriptTask.getExtensionValues()));
        Assert.assertEquals((Object)"<![CDATA[System.out.println(\"exit\");]]>", (Object)this.getOnExitScript(scriptTask.getExtensionValues()));
    }

    @Test
    public void testScriptTaskMvelScriptFormat() throws Exception {
        ScriptTask element;
        Definitions definitions = this.loader.loadProcessFromJson("mvelScriptTask.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ScriptTask scriptTask = element = (ScriptTask)this.getFlowElement(process.getFlowElements(), "mvelScriptTask");
        Assert.assertEquals((Object)"<![CDATA[m : Message( status == Message.HELLO )]]>", (Object)scriptTask.getScript());
        Assert.assertEquals((Object)"http://www.mvel.org/2.0", (Object)scriptTask.getScriptFormat());
    }

    @Test
    public void testBusinessRuleTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("businessRule.json");
        Process process = this.getRootProcess(definitions);
        FlowElement task = this.getFlowElement(process.getFlowElements(), "businessRuleTask");
        Assert.assertTrue((boolean)(task instanceof BusinessRuleTask));
        BusinessRuleTask ruleTask = (BusinessRuleTask)task;
        this.verifyAttribute((BaseElement)ruleTask, "ruleFlowGroup", "simpleGroup");
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(task.getExtensionValues(), "customAsync"));
        Assert.assertEquals((Object)"http://www.jboss.org/drools/rule", (Object)ruleTask.getImplementation());
    }

    @Test
    public void testReceiveTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("receiveTask.json");
        Process process = this.getRootProcess(definitions);
        FlowElement task = this.getFlowElement(process.getFlowElements(), "receiveTask");
        Assert.assertTrue((boolean)(task instanceof ReceiveTask));
        ReceiveTask receiveTask = (ReceiveTask)task;
        this.verifyAttribute((BaseElement)receiveTask, "msgref", "parcel");
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(task.getExtensionValues(), "customAsync"));
    }

    @Test
    public void testSendTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("sendTask.json");
        Process process = this.getRootProcess(definitions);
        FlowElement task = this.getFlowElement(process.getFlowElements(), "sendTask");
        Assert.assertTrue((boolean)(task instanceof SendTask));
        SendTask sendTask = (SendTask)task;
        this.verifyAttribute((BaseElement)sendTask, "msgref", "parcel");
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(task.getExtensionValues(), "customAsync"));
    }

    public void testManualTaskUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("manualTask.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        GlobalManualTask task = (GlobalManualTask)definitions.getRootElements().get(0);
        Assert.assertEquals((Object)"pull a lever", (Object)task.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testGatewayUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("gateway.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ExclusiveGateway g = (ExclusiveGateway)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"xor gateway", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testParallelGatewayUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("parallelGateway.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ParallelGateway g = (ParallelGateway)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"parallel gateway", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEventBasedGatewayUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("eventBasedGateway.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EventBasedGateway g = (EventBasedGateway)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"event-based gateway", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testInclusiveGatewayUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("inclusiveGateway.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        InclusiveGateway g = (InclusiveGateway)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"inclusive gateway", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartMessageEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startMessageEvent.json");
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start message event", (Object)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartEscalationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startEscalationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start escalation event", (Object)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        EscalationEventDefinition escalationEventDefinition = (EscalationEventDefinition)g.getEventDefinitions().iterator().next();
        Assert.assertEquals((Object)"com.sample.escalation", (Object)escalationEventDefinition.getEscalationRef().getEscalationCode());
        Assert.assertEquals((Object)"com.sample.escalation", (Object)escalationEventDefinition.getEscalationRef().getName());
    }

    @Test
    public void testStartCompensationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startCompensationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start compensation event", (Object)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartMultipleEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartParallelMultipleEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startParallelMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start parallel multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartSignalEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startSignalEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start signal event", (Object)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof SignalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testStartTimerEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startTimerEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        StartEvent g = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"start timer event", (Object)g.getName());
        Assert.assertTrue((g.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TimerEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testGroupUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("group.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Group group = (Group)process.getArtifacts().iterator().next();
        Assert.assertEquals((String)"Group name is wrong.", (Object)group.getCategoryValueRef().getValue(), (Object)"group");
        Assert.assertEquals((Object)((Documentation)group.getDocumentation().get(0)).getText(), (Object)"<![CDATA[group documentation]]>");
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testTextAnnotationUnmarshalling() throws Exception {
        ArrayList<SimpleEdge> expectedEdges = new ArrayList<SimpleEdge>();
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[Start\nAnnotation]]>").addPoint(120, 320).addPoint(170, 160));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[Task\nIn\nLane\nAnnotation]]>").addPoint(155, 125).addPoint(380, 184).addPoint(331, 184).addPoint(380, 130));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[WID\nTask\nannotation]]>").addPoint(690, 650).addPoint(690, 507).addPoint(791, 507));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[User\nTask\nAnnotation]]>").addPoint(100, 76).addPoint(196, 646).addPoint(245, 550));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[Gateway\nin\nlane\nannotation]]>").addPoint(270, 125).addPoint(409, 125));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[End\nIn\nSwimlane]]>").addPoint(270, 36).addPoint(915, 231).addPoint(964, 133));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[Subprocess's\nAnnotation]]>").addPoint(495, 650).addPoint(495, 847).addPoint(714, 848));
        expectedEdges.add(SimpleEdge.createEdge("<![CDATA[Swimlane's\nAnnotation]]>").addPoint(525, 320).addPoint(1066, 320).addPoint(1115, 505));
        ArrayList<SimpleEdge> actualEdges = new ArrayList<SimpleEdge>();
        Definitions definitions = this.loader.loadProcessFromJson("textAnnotation.json");
        List<BPMNEdge> edges = this.getAllEdgesFromDefinition(definitions);
        for (Edge edge : edges) {
            SimpleEdge currentEdge = SimpleEdge.createEdge(this.getEdgeName(edge));
            for (Point p : edge.getWaypoint()) {
                currentEdge.addPoint(p.getX(), p.getY());
            }
            actualEdges.add(currentEdge);
        }
        Assert.assertEquals(expectedEdges, actualEdges);
    }

    private String getEdgeName(Edge edge) {
        return ((MetaDataTypeImpl)((FeatureMap.Entry)((ExtensionAttributeValue)((Association)((BPMNEdgeImpl)edge).getBpmnElement()).getTargetRef().getExtensionValues().get(0)).getValue().get(0)).getValue()).getMetaValue();
    }

    private List<BPMNEdge> getAllEdgesFromDefinition(Definitions definitions) {
        ArrayList<BPMNEdge> edges = new ArrayList<BPMNEdge>();
        List<DiagramElement> elements = this.getPlaneElementsFormDefinition(definitions);
        for (DiagramElement element : elements) {
            if (!this.isAssociation(element)) continue;
            edges.add((BPMNEdge)element);
        }
        return edges;
    }

    private List<DiagramElement> getPlaneElementsFormDefinition(Definitions definitions) {
        return ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane().getPlaneElement();
    }

    private boolean isEdge(DiagramElement element) {
        return element instanceof BPMNEdge;
    }

    private boolean isAssociation(DiagramElement element) {
        return this.isEdge(element) && ((BPMNEdgeImpl)element).getBpmnElement() instanceof Association;
    }

    @Test
    public void testDataObjectUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("dataObject.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().iterator().next() instanceof DataObject));
        DataObject da = (DataObject)process.getFlowElements().iterator().next();
        Assert.assertEquals((Object)"data object", (Object)da.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndMessageEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endMessageEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end message event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndEscalationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endEscalationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end escalation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndErrorEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endErrorEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end error event", (Object)g.getName());
        ErrorEventDefinition error = (ErrorEventDefinition)g.getEventDefinitions().iterator().next();
        Assert.assertEquals((Object)"com.sample.Error", (Object)error.getErrorRef().getName());
        Assert.assertEquals((Object)"com.sample.Error", (Object)error.getErrorRef().getErrorCode());
    }

    @Test
    public void testEndSignalEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endSignalEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)this.getFlowElement(process.getFlowElements(), "EndSignalEvent");
        Assert.assertEquals((Object)"EndSignalEvent", (Object)g.getName());
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)g.getEventDefinitions().iterator().next();
        Signal signal = (Signal)definitions.getRootElements().get(1);
        Assert.assertEquals((Object)signal.getId(), (Object)signalEventDefinition.getSignalRef());
        Assert.assertEquals((Object)"signalForTestPurposes", (Object)signal.getName());
    }

    @Test
    public void testEndTerminateEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endTerminateEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"terminate end event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TerminateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndMultipleEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testEndCompensationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("endCompensationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        EndEvent g = (EndEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"end compensation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testSimpleChainUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("startEvent-task-endEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((process.getFlowElements().size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((process.getLaneSets().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((LaneSet)process.getLaneSets().get(0)).getLanes().size() == 1 ? 1 : 0) != 0);
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchMessageEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchMessageEvent.json");
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch message event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchTimerEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchTimerEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch timer event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof TimerEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchEscalationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchEscalationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch escalation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchConditionalEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchConditionalEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch conditional event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof ConditionalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchLinkEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchLinkEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch link event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof LinkEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchErrorEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchErrorEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch error event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof ErrorEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchCancelEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchCancelEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch cancel event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CancelEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchCompensationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchCompensationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch compensation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchMultipleEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateCatchParallelMultipleEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCatchParallelMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        CatchEvent g = (CatchEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"catch parallel multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowMessageEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowMessageEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw message event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowEscalationEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowEscalationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 2 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw escalation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof EscalationEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowLinkEventUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowLinkEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw link event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof LinkEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowCompensationUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowCompensationEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw compensation event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof CompensateEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowSignalUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowSignalEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw signal event", (Object)g.getName());
        Assert.assertTrue((boolean)(g.getEventDefinitions().iterator().next() instanceof SignalEventDefinition));
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testIntermediateThrowMultipleUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateThrowMultipleEvent.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        ThrowEvent g = (ThrowEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"throw multiple event", (Object)g.getName());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("association.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Task g = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"task", (Object)g.getName());
        TextAnnotation textA = (TextAnnotation)process.getFlowElements().get(1);
        Association association = (Association)process.getArtifacts().get(0);
        Assert.assertEquals((Object)g, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.NONE, (Object)association.getAssociationDirection());
        Assert.assertEquals((long)1L, (long)this.getBpmnEdges((BaseElement)association, definitions).size());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationUnidirectionalUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("associationOne.json");
        Process process = this.getRootProcess(definitions);
        Task g = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"task", (Object)g.getName());
        TextAnnotation textA = (TextAnnotation)process.getFlowElements().get(1);
        Association association = (Association)process.getArtifacts().get(0);
        Assert.assertEquals((Object)g, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.ONE, (Object)association.getAssociationDirection());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testAssociationBidirectionalUnmarshalling() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("associationBoth.json");
        Process process = this.getRootProcess(definitions);
        Task task = (Task)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"task", (Object)task.getName());
        TextAnnotation textA = (TextAnnotation)process.getFlowElements().get(1);
        Association association = (Association)process.getArtifacts().get(0);
        Assert.assertEquals((Object)task, (Object)association.getSourceRef());
        Assert.assertEquals((Object)textA, (Object)association.getTargetRef());
        Assert.assertEquals((Object)AssociationDirection.BOTH, (Object)association.getAssociationDirection());
        definitions.eResource().save((OutputStream)System.out, Collections.emptyMap());
    }

    @Test
    public void testMultiLineNames() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("multiLineNames.json");
        Process process = this.getRootProcess(definitions);
        Assert.assertEquals((Object)"<![CDATA[my\nstart]]>", (Object)this.getElementName((FlowElementsContainer)process, 0));
        Assert.assertEquals((Object)"<![CDATA[my\nflow]]>", (Object)this.getElementName((FlowElementsContainer)process, 1));
        Assert.assertEquals((Object)"<![CDATA[my\ngate]]>", (Object)this.getElementName((FlowElementsContainer)process, 2));
        Assert.assertEquals((Object)"<![CDATA[my\nend]]>", (Object)this.getElementName((FlowElementsContainer)process, 3));
        Assert.assertEquals((Object)"<![CDATA[my\nterminate\nend]]>", (Object)this.getElementName((FlowElementsContainer)process, 5));
        Assert.assertEquals((Object)"<![CDATA[my\nthrowing\nmessage]]>", (Object)this.getElementName((FlowElementsContainer)process, 6));
        Assert.assertEquals((Object)"<![CDATA[my\nflow\nin\nlane]]>", (Object)this.getElementName((FlowElementsContainer)process, 9));
        Assert.assertEquals((Object)"<![CDATA[my\nsubprocess]]>", (Object)this.getElementName((FlowElementsContainer)process, 10));
        Assert.assertEquals((Object)"<![CDATA[my\nuser\ntask]]>", (Object)this.getElementName((FlowElementsContainer)process, 14));
        Assert.assertEquals((Object)"<![CDATA[my\nmessage]]>", (Object)this.getElementName((FlowElementsContainer)process, 15));
        FlowElementsContainer embeddedSubProcess = (FlowElementsContainer)process.getFlowElements().get(10);
        Assert.assertEquals((Object)"<![CDATA[my\nmessage\nstart]]>", (Object)this.getElementName(embeddedSubProcess, 0));
        Assert.assertEquals((Object)"<![CDATA[my\nmanual\ntask]]>", (Object)this.getElementName(embeddedSubProcess, 1));
        Assert.assertEquals((Object)"<![CDATA[my\ninner\nend]]>", (Object)this.getElementName(embeddedSubProcess, 2));
        Assert.assertEquals((Object)"<![CDATA[my\nflow\nin\nsubprocess]]>", (Object)this.getElementName(embeddedSubProcess, 3));
        Assert.assertEquals((Object)"<![CDATA[my\nescalation\nevent]]>", (Object)this.getElementName(embeddedSubProcess, 5));
        Assert.assertNull((Object)((SubProcess)embeddedSubProcess).getLoopCharacteristics());
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        FlowElementsContainer adHocSubProcess = (FlowElementsContainer)lane.getFlowNodeRefs().get(0);
        Assert.assertEquals((Object)"<![CDATA[my\nlane]]>", (Object)this.getMetaDataValue(lane.getExtensionValues(), "elementname"));
        Assert.assertEquals((Object)"<![CDATA[my\nadhoc\nsubprocess]]>", (Object)this.getMetaDataValue(adHocSubProcess.getExtensionValues(), "elementname"));
        Assert.assertEquals((Object)"<![CDATA[my\ntask\nin\nadhoc]]>", (Object)this.getElementName(adHocSubProcess, 0));
        Assert.assertEquals((Object)"<![CDATA[my\nmessage\nin\nsubprocess\nin\nlane]]>", (Object)this.getElementName(adHocSubProcess, 1));
        Assert.assertEquals((Object)"<![CDATA[my\nuser\ntask]]>", (Object)this.getMetaDataValue(((FlowNode)lane.getFlowNodeRefs().get(1)).getExtensionValues(), "elementname"));
        Assert.assertEquals((Object)"<![CDATA[my\nmessage]]>", (Object)this.getMetaDataValue(((FlowNode)lane.getFlowNodeRefs().get(2)).getExtensionValues(), "elementname"));
        Assert.assertNull((Object)((AdHocSubProcess)adHocSubProcess).getLoopCharacteristics());
    }

    private String getElementName(FlowElementsContainer container, int elementNumber) {
        BaseElement element = (BaseElement)container.getFlowElements().get(elementNumber);
        return this.getMetaDataValue(element.getExtensionValues(), "elementname");
    }

    @Test
    public void testFindContainerForBoundaryEvent() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("boundaryEventsContainers.json");
        Process process = this.getRootProcess(definitions);
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        boolean foundTimer1 = false;
        boolean foundTimer2 = false;
        boolean foundTimer3 = false;
        for (Object element : process.getFlowElements()) {
            if (!(element instanceof BoundaryEvent)) continue;
            BoundaryEvent be = (BoundaryEvent)element;
            if (!"Timer3".equals(element.getName())) continue;
            Process sp = (Process)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
            Assert.assertEquals((Object)"DemoProcess", (Object)sp.getName());
            this.verifyAttribute((BaseElement)be, "dockerinfo", "17.0^70.0|");
            foundTimer3 = true;
        }
        SubProcess subProcessOne = (SubProcess)this.getFlowElement(process.getFlowElements(), "Subprocess1");
        Assert.assertNull((Object)subProcessOne.getLoopCharacteristics());
        for (FlowElement element : subProcessOne.getFlowElements()) {
            if (!(element instanceof BoundaryEvent)) continue;
            BoundaryEvent be = (BoundaryEvent)element;
            if (!"Timer1".equals(element.getName())) continue;
            SubProcess sp = (SubProcess)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
            Assert.assertEquals((Object)"Subprocess1", (Object)sp.getName());
            this.verifyAttribute((BaseElement)be, "dockerinfo", "47.0^80.0|");
            foundTimer1 = true;
        }
        SubProcess subProcessTwo = (SubProcess)this.getFlowElement(process.getFlowElements(), "Subprocess2");
        Assert.assertNull((Object)subProcessTwo.getLoopCharacteristics());
        for (FlowElement element : subProcessTwo.getFlowElements()) {
            if (!(element instanceof BoundaryEvent)) continue;
            BoundaryEvent be = (BoundaryEvent)element;
            if (!"Timer2".equals(element.getName())) continue;
            SubProcess sp = (SubProcess)unmarshaller.findContainerForBoundaryEvent((FlowElementsContainer)process, be);
            Assert.assertNull((Object)sp.getLoopCharacteristics());
            Assert.assertEquals((Object)"Subprocess2", (Object)sp.getName());
            this.verifyAttribute((BaseElement)be, "dockerinfo", "46.0^77.0|");
            foundTimer2 = true;
        }
        Assert.assertTrue((foundTimer1 && foundTimer2 && foundTimer3 ? 1 : 0) != 0);
    }

    @Test
    public void testCompensationThrowingEvent() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("intermediateCompensationEventThrowing.json");
        Process process = this.getRootProcess(definitions);
        ThrowEvent compensationThrowEvent = (ThrowEvent)process.getFlowElements().get(2);
        Assert.assertEquals((Object)"Compensate", (Object)compensationThrowEvent.getName());
        Assert.assertNotNull((Object)compensationThrowEvent.getEventDefinitions());
        Assert.assertEquals((long)1L, (long)compensationThrowEvent.getEventDefinitions().size());
        EventDefinition ed = (EventDefinition)compensationThrowEvent.getEventDefinitions().get(0);
        Assert.assertTrue((boolean)(ed instanceof CompensateEventDefinition));
        CompensateEventDefinition ced = (CompensateEventDefinition)ed;
        Assert.assertNotNull((Object)ced.getActivityRef());
        Assert.assertEquals((Object)"User Task", (Object)ced.getActivityRef().getName());
    }

    @Test
    public void testBoundaryEvents() throws Exception {
        String SUBTIMER_NAME = "SubTimer";
        String SUBPROCESSMESSAGE_NAME = "SubProcessMessage";
        String OUTTIMER_NAME = "OutTimer";
        Definitions definitions = this.loader.loadProcessFromJson("boundaryEvents.json");
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)process, "OutTimer"));
        Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)process, "SubProcessMessage"));
        Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)process, "SubTimer"));
        SubProcess subProcess = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof SubProcess)) continue;
            subProcess = (SubProcess)flowElement;
            break;
        }
        Assert.assertNotNull(subProcess);
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(subProcess.getExtensionValues(), "customAsync"));
        Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "OutTimer"));
        Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "SubProcessMessage"));
        Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "SubTimer"));
        Assert.assertNull((Object)subProcess.getLoopCharacteristics());
        BoundaryEvent outTimer = (BoundaryEvent)this.getFlowElement(process.getFlowElements(), "OutTimer");
        BoundaryEvent subProcessMessage = (BoundaryEvent)this.getFlowElement(process.getFlowElements(), "SubProcessMessage");
        Assert.assertEquals((long)0L, (long)this.getBpmnEdges((BaseElement)outTimer, definitions).size());
        Assert.assertEquals((long)0L, (long)this.getBpmnEdges((BaseElement)subProcessMessage, definitions).size());
    }

    @Test
    public void testBoundaryEventsContainers() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("boundaryEventsContainers.json");
        Process process = this.getRootProcess(definitions);
        String TIMER_ONE = "Timer1";
        String TIMER_TWO = "Timer2";
        String TIMER_THREE = "Timer3";
        Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)process, "Timer1"));
        Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)process, "Timer2"));
        Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)process, "Timer3"));
        for (FlowElement flowElement : process.getFlowElements()) {
            SubProcess subProcess;
            if ("Subprocess1".equals(flowElement.getName()) && flowElement instanceof SubProcess) {
                subProcess = (SubProcess)flowElement;
                Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer1"));
                Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer2"));
                Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer3"));
                Assert.assertNull((Object)subProcess.getLoopCharacteristics());
            }
            if (!"Subprocess2".equals(flowElement.getName()) || !(flowElement instanceof SubProcess)) continue;
            subProcess = (SubProcess)flowElement;
            Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer1"));
            Assert.assertTrue((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer2"));
            Assert.assertFalse((boolean)this.containerContainsElement((FlowElementsContainer)subProcess, "Timer3"));
            Assert.assertNull((Object)subProcess.getLoopCharacteristics());
        }
    }

    private boolean containerContainsElement(FlowElementsContainer container, String elementName) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (!elementName.equals(flowElement.getName())) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testWorkItemHandlerNoParams() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("workItemHandlerNoParams.json");
        Assert.assertTrue((definitions.getRootElements().size() >= 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof StartEvent));
        StartEvent startEvent = (StartEvent)process.getFlowElements().get(0);
        Assert.assertEquals((Object)"TheStart", (Object)startEvent.getName());
        Task task = (Task)process.getFlowElements().get(1);
        Assert.assertEquals((Object)"HelloWorldService", (Object)task.getName());
        SequenceFlow flow = (SequenceFlow)process.getFlowElements().get(2);
        Assert.assertEquals((Object)"flow1", (Object)flow.getName());
        Assert.assertEquals((Object)startEvent, (Object)flow.getSourceRef());
        Assert.assertEquals((Object)task, (Object)flow.getTargetRef());
    }

    private Process getRootProcess(Definitions def) {
        for (RootElement nextRootElement : def.getRootElements()) {
            if (!(nextRootElement instanceof Process)) continue;
            return (Process)nextRootElement;
        }
        return null;
    }

    @Test
    public void testDocumentationPropertyForBoundaryEvents() throws Exception {
        String DOCUMENTATION_VALUE = "<![CDATA[Cancel task on timeout.]]>";
        String BOUNDARY_EVENT_NAME = "CancelOnTimer";
        Definitions definitions = this.loader.loadProcessFromJson("boundaryEventsDocumentation.json");
        boolean documentationChecked = false;
        Process process = this.getRootProcess(definitions);
        for (FlowElement flow : process.getFlowElements()) {
            if (!"CancelOnTimer".equals(flow.getName())) continue;
            Assert.assertTrue((String)"CancelOnTimer have no documentation.", (flow.getDocumentation().size() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"<![CDATA[Cancel task on timeout.]]>", (Object)((Documentation)flow.getDocumentation().get(0)).getText());
            documentationChecked = true;
            break;
        }
        Assert.assertTrue((String)"Boundary Event 'CancelOnTimer' is not found in the process.", (boolean)documentationChecked);
    }

    @Test
    public void testDefaultMessageRefForStartMessageEvent() throws Exception {
        Process process = this.getRootProcess(this.loader.loadProcessFromJson("defaultMessageStartEvent.json"));
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof StartEvent));
        StartEvent startEvent = (StartEvent)process.getFlowElements().get(0);
        Assert.assertTrue((startEvent.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(startEvent.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        MessageEventDefinition messageEventDef = (MessageEventDefinition)startEvent.getEventDefinitions().iterator().next();
        Assert.assertNull((Object)messageEventDef.getMessageRef());
    }

    @Test
    public void testDefaultMessageRefsCombined() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("defaultMessagesCombined.json");
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof SendTask));
        SendTask sendTask = (SendTask)process.getFlowElements().get(0);
        Assert.assertNull((Object)sendTask.getMessageRef());
        Assert.assertTrue((boolean)(process.getFlowElements().get(1) instanceof ReceiveTask));
        ReceiveTask receiveTask = (ReceiveTask)process.getFlowElements().get(1);
        Assert.assertNull((Object)receiveTask.getMessageRef());
        Assert.assertTrue((boolean)(process.getFlowElements().get(2) instanceof StartEvent));
        StartEvent startEvent = (StartEvent)process.getFlowElements().get(2);
        Assert.assertTrue((startEvent.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(startEvent.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        MessageEventDefinition messageEventDefStart = (MessageEventDefinition)startEvent.getEventDefinitions().iterator().next();
        Assert.assertNull((Object)messageEventDefStart.getMessageRef());
        Assert.assertTrue((boolean)(process.getFlowElements().get(3) instanceof EndEvent));
        EndEvent endEvent = (EndEvent)process.getFlowElements().get(3);
        Assert.assertTrue((endEvent.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(endEvent.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        MessageEventDefinition messageEventDefEnd = (MessageEventDefinition)endEvent.getEventDefinitions().iterator().next();
        Assert.assertNull((Object)messageEventDefEnd.getMessageRef());
        Assert.assertTrue((boolean)(process.getFlowElements().get(4) instanceof IntermediateCatchEvent));
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)process.getFlowElements().get(4);
        Assert.assertTrue((catchEvent.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(catchEvent.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        MessageEventDefinition messageEventDefCatch = (MessageEventDefinition)catchEvent.getEventDefinitions().iterator().next();
        Assert.assertNull((Object)messageEventDefCatch.getMessageRef());
        Assert.assertTrue((boolean)(process.getFlowElements().get(5) instanceof IntermediateThrowEvent));
        IntermediateThrowEvent throwEvent = (IntermediateThrowEvent)process.getFlowElements().get(5);
        Assert.assertTrue((throwEvent.getEventDefinitions().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(throwEvent.getEventDefinitions().iterator().next() instanceof MessageEventDefinition));
        MessageEventDefinition messageEventDefThrow = (MessageEventDefinition)throwEvent.getEventDefinitions().iterator().next();
        Assert.assertNull((Object)messageEventDefThrow.getMessageRef());
    }

    @Test
    public void testCallActivityAssignments() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("callActivityInSubprocess.json");
        Process process = this.getRootProcess(definitions);
        FlowElement subProcess = this.getFlowElement(process.getFlowElements(), "SubProcess");
        Assert.assertTrue((boolean)(subProcess instanceof SubProcess));
        FlowElement activity = this.getFlowElement(((SubProcess)subProcess).getFlowElements(), "callActivity");
        Assert.assertTrue((boolean)(activity instanceof CallActivity));
        CallActivity callActivity = (CallActivity)activity;
        InputOutputSpecification specification = callActivity.getIoSpecification();
        Assert.assertNull((Object)((SubProcess)subProcess).getLoopCharacteristics());
        DataInput dataInput = this.getDataInput(specification.getDataInputs(), "innerInput");
        this.verifyAttribute((BaseElement)dataInput, "dtype", "Integer");
        DataOutput dataOutput = this.getDataOutput(specification.getDataOutputs(), "innerOutput");
        this.verifyAttribute((BaseElement)dataOutput, "dtype", "Integer");
    }

    @Test
    public void testSubProcessDiagramElements() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("callActivityInSubprocess.json");
        Process process = this.getRootProcess(definitions);
        FlowElement subProcess = this.getFlowElement(process.getFlowElements(), "SubProcess");
        this.verifyBpmnShapePresent((BaseElement)subProcess, definitions);
        Assert.assertNull((Object)((SubProcess)subProcess).getLoopCharacteristics());
    }

    @Test
    public void testNoDefaultMessageCreated() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("message.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentationForSwimlane() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("swimlane.json");
        Process process = this.getRootProcess(definitions);
        Lane lane = (Lane)((LaneSet)process.getLaneSets().get(0)).getLanes().get(0);
        Assert.assertEquals((String)"Swimlane name is wrong.", (Object)lane.getName(), (Object)"Documented Swimlane");
        Assert.assertEquals((Object)"<![CDATA[Some documentation for swimlane.]]>", (Object)((Documentation)lane.getDocumentation().get(0)).getText());
    }

    @Test
    public void testUserTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("userTask.json");
        Process process = this.getRootProcess(definitions);
        UserTask userTask = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof UserTask)) continue;
            userTask = (UserTask)flowElement;
            break;
        }
        Assert.assertNotNull(userTask);
        Assert.assertEquals((Object)"User Task One", (Object)userTask.getName());
        Assert.assertEquals((Object)"assignedActor", (Object)((FormalExpression)((ResourceRole)userTask.getResources().get(0)).getResourceAssignmentExpression().getExpression()).getBody());
        boolean foundTaskName = false;
        boolean foundGroupId = false;
        for (DataInputAssociation association : userTask.getDataInputAssociations()) {
            if (association.getAssignment() == null) continue;
            for (Assignment assignment : association.getAssignment()) {
                String from = ((FormalExpression)assignment.getFrom()).getBody();
                String to = ((FormalExpression)assignment.getTo()).getBody();
                if (to.contains("TaskName") && from.equals("<![CDATA[taskForAssignedActor]]>")) {
                    foundTaskName = true;
                }
                if (!to.contains("GroupId") || !from.equals("<![CDATA[assignedGroup]]>")) continue;
                foundGroupId = true;
            }
        }
        Assert.assertTrue((boolean)foundTaskName);
        Assert.assertTrue((boolean)foundGroupId);
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(userTask.getExtensionValues(), "customAsync"));
        this.verifyBpmnShapePresent((BaseElement)userTask, definitions);
    }

    @Test
    public void testSequenceFlowPointsInsideLane() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("sequenceFlowPointsInsideLane.json");
        BPMNPlane plane = ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            if (!(dia instanceof BPMNEdge)) continue;
            BPMNEdge edge = (BPMNEdge)dia;
            List wayPoints = edge.getWaypoint();
            Assert.assertNotNull((Object)wayPoints);
            Assert.assertEquals((long)wayPoints.size(), (long)2L);
            Assert.assertEquals((Object)Float.valueOf(((Point)wayPoints.get(0)).getX()), (Object)new Float(252.0));
            Assert.assertEquals((Object)Float.valueOf(((Point)wayPoints.get(0)).getY()), (Object)new Float(220.0));
            Assert.assertEquals((Object)Float.valueOf(((Point)wayPoints.get(1)).getX()), (Object)new Float(357.0));
            Assert.assertEquals((Object)Float.valueOf(((Point)wayPoints.get(1)).getY()), (Object)new Float(220.0));
        }
    }

    @Test
    public void testCallActivity() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("callActivity.json");
        Process process = this.getRootProcess(definitions);
        CallActivity callActivity = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof CallActivity)) continue;
            callActivity = (CallActivity)flowElement;
            break;
        }
        Assert.assertNotNull(callActivity);
        Assert.assertEquals((Object)"callActivity", (Object)callActivity.getName());
        Assert.assertEquals((Object)"abc.noCalledElementCallActivity", (Object)callActivity.getCalledElement());
    }

    @Test
    public void testDefaultInterfaceForServiceTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("defaultServiceTask.json");
        Process process = this.getRootProcess(definitions);
        Assert.assertTrue((boolean)(process.getFlowElements().get(0) instanceof ServiceTask));
        ServiceTask serviceTask = (ServiceTask)process.getFlowElements().get(0);
        this.verifyServiceTask(serviceTask, "Java", null, null);
    }

    @Test
    public void testServiceTaskInterfaceAndOperation() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("serviceTaskInterfaceAndOperation.json");
        Process process = this.getRootProcess(definitions);
        FlowElement element = this.getFlowElement(process.getFlowElements(), "Send PO");
        Assert.assertTrue((boolean)(element instanceof ServiceTask));
        ServiceTask serviceTask = (ServiceTask)element;
        this.verifyServiceTask(serviceTask, "Java", "sendInterface", "sendOperation");
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(serviceTask.getExtensionValues(), "customAsync"));
    }

    @Test
    public void testSubprocessTaskAssignemtns() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("subprocessTaskAssignments.json");
        Process process = this.getRootProcess(definitions);
        FlowElement subprocess = this.getFlowElement(process.getFlowElements(), "Embedded subprocess");
        Assert.assertTrue((boolean)(subprocess instanceof SubProcess));
        FlowElement element = this.getFlowElement(((SubProcess)subprocess).getFlowElements(), "UserTask");
        Assert.assertTrue((boolean)(element instanceof UserTask));
        UserTask userTask = (UserTask)element;
        InputOutputSpecification specification = userTask.getIoSpecification();
        DataInput sInput = this.getDataInput(specification.getDataInputs(), "sInput");
        DataOutput iOutput = this.getDataOutput(specification.getDataOutputs(), "iOutput");
        this.verifyAttribute((BaseElement)sInput, "dtype", "String");
        this.verifyAttribute((BaseElement)iOutput, "dtype", "Integer");
        Assert.assertNull((Object)((SubProcess)subprocess).getLoopCharacteristics());
    }

    @Test
    public void testEndEventsAssignments() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("subprocessTaskAssignments.json");
        Process process = this.getRootProcess(definitions);
        FlowElement subprocess = this.getFlowElement(process.getFlowElements(), "Embedded subprocess");
        Assert.assertTrue((boolean)(subprocess instanceof SubProcess));
        FlowElement element = this.getFlowElement(((SubProcess)subprocess).getFlowElements(), "SubEnd");
        Assert.assertTrue((boolean)(element instanceof EndEvent));
        EndEvent subEnd = (EndEvent)element;
        List associations = subEnd.getDataInputAssociation();
        Assert.assertEquals((long)1L, (long)associations.size());
        Assert.assertEquals((Object)"intVar", (Object)((ItemAwareElement)((DataInputAssociation)associations.get(0)).getSourceRef().get(0)).getId());
        Assert.assertTrue((boolean)((DataInputAssociation)associations.get(0)).getTargetRef().getId().contains("intSubInput"));
        this.verifyAttribute((BaseElement)((DataInputAssociation)associations.get(0)).getTargetRef(), "dtype", "Integer");
        Assert.assertNull((Object)((SubProcess)subprocess).getLoopCharacteristics());
        element = this.getFlowElement(process.getFlowElements(), "End Event");
        Assert.assertTrue((boolean)(element instanceof EndEvent));
        EndEvent endEvent = (EndEvent)element;
        associations = endEvent.getDataInputAssociation();
        Assert.assertEquals((long)1L, (long)associations.size());
        Assert.assertEquals((Object)"intVar", (Object)((ItemAwareElement)((DataInputAssociation)associations.get(0)).getSourceRef().get(0)).getId());
        Assert.assertTrue((boolean)((DataInputAssociation)associations.get(0)).getTargetRef().getId().contains("intInput"));
        this.verifyAttribute((BaseElement)((DataInputAssociation)associations.get(0)).getTargetRef(), "dtype", "Integer");
    }

    @Test
    public void testRestTaskAssignments() throws Exception {
        String[] taskInputs = new String[]{"Content", "ContentType", "ResultClass", "Method", "Username", "Password", "ReadTimeout", "ConnectTimeout", "Url"};
        Definitions definitions = this.loader.loadProcessFromJson("restTask.json");
        Process process = this.getRootProcess(definitions);
        FlowElement element = this.getFlowElement(process.getFlowElements(), "REST");
        Assert.assertTrue((boolean)(element instanceof Task));
        Task restTask = (Task)element;
        InputOutputSpecification specification = restTask.getIoSpecification();
        for (String input : taskInputs) {
            DataInput dataInput = this.getDataInput(specification.getDataInputs(), input);
            this.verifyAttribute((BaseElement)dataInput, "dtype", "String");
        }
        DataOutput dataOutput = this.getDataOutput(specification.getDataOutputs(), "Result");
        this.verifyAttribute((BaseElement)dataOutput, "dtype", "java.lang.Object");
    }

    @Test
    public void testTaskInputOutputSet() throws Exception {
        Process process = this.getRootProcess(this.loader.loadProcessFromJson("taskInputOutputSet.json"));
        Assert.assertTrue((boolean)(process.getFlowElements().get(1) instanceof UserTask));
        UserTask task = (UserTask)process.getFlowElements().get(1);
        Assert.assertEquals((Object)"userTask", (Object)task.getName());
        InputSet inputSet = (InputSet)task.getIoSpecification().getInputSets().get(0);
        OutputSet outputSet = (OutputSet)task.getIoSpecification().getOutputSets().get(0);
        Assert.assertEquals((long)4L, (long)inputSet.getDataInputRefs().size());
        Assert.assertEquals((Object)"firstInput", (Object)((DataInput)inputSet.getDataInputRefs().get(0)).getName());
        Assert.assertEquals((Object)"secondInput", (Object)((DataInput)inputSet.getDataInputRefs().get(1)).getName());
        Assert.assertEquals((Object)"TaskName", (Object)((DataInput)inputSet.getDataInputRefs().get(2)).getName());
        Assert.assertEquals((Object)"Skippable", (Object)((DataInput)inputSet.getDataInputRefs().get(3)).getName());
        Assert.assertEquals((long)1L, (long)outputSet.getDataOutputRefs().size());
        Assert.assertEquals((Object)"firstOutput", (Object)((DataOutput)outputSet.getDataOutputRefs().get(0)).getName());
    }

    @Test
    public void testSubprocessDefaultInputOutputSets() throws Exception {
        Process process = this.getRootProcess(this.loader.loadProcessFromJson("defaultSubprocessInputOutputSets.json"));
        Assert.assertTrue((boolean)(process.getFlowElements().get(1) instanceof SubProcess));
        SubProcess subProcess = (SubProcess)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)subProcess.getLoopCharacteristics());
        InputSet inputSet = (InputSet)subProcess.getIoSpecification().getInputSets().get(0);
        OutputSet outputSet = (OutputSet)subProcess.getIoSpecification().getOutputSets().get(0);
        Assert.assertEquals((long)0L, (long)inputSet.getDataInputRefs().size());
        Assert.assertEquals((long)0L, (long)outputSet.getDataOutputRefs().size());
    }

    @Test
    public void testSubprocessDefaultOutputSet() throws Exception {
        Process process = this.getRootProcess(this.loader.loadProcessFromJson("subprocessDefaultOutputSet.json"));
        Assert.assertTrue((boolean)(process.getFlowElements().get(1) instanceof SubProcess));
        SubProcess subProcess = (SubProcess)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)subProcess.getLoopCharacteristics());
        InputSet inputSet = (InputSet)subProcess.getIoSpecification().getInputSets().get(0);
        OutputSet outputSet = (OutputSet)subProcess.getIoSpecification().getOutputSets().get(0);
        Assert.assertEquals((long)1L, (long)inputSet.getDataInputRefs().size());
        Assert.assertEquals((long)0L, (long)outputSet.getDataOutputRefs().size());
    }

    private FlowElement getFlowElement(List<FlowElement> elements, String name) {
        for (FlowElement element : elements) {
            if (element.getName() == null || name.compareTo(element.getName()) != 0) continue;
            return element;
        }
        return null;
    }

    private String getMetaDataValue(List<ExtensionAttributeValue> extensionValues, String metaDataName) {
        for (MetaDataType type : this.extractFeature(extensionValues, (EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA)) {
            if (type.getName() == null || !type.getName().equals(metaDataName)) continue;
            return type.getMetaValue();
        }
        return null;
    }

    private String getOnEntryScript(List<ExtensionAttributeValue> extensionValues) {
        Iterator iterator = this.extractFeature(extensionValues, (EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT).iterator();
        if (iterator.hasNext()) {
            OnEntryScriptType type = (OnEntryScriptType)iterator.next();
            return type.getScript();
        }
        return null;
    }

    private String getOnExitScript(List<ExtensionAttributeValue> extensionValues) {
        Iterator iterator = this.extractFeature(extensionValues, (EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT).iterator();
        if (iterator.hasNext()) {
            OnExitScriptType type = (OnExitScriptType)iterator.next();
            return type.getScript();
        }
        return null;
    }

    private <T> List<T> extractFeature(List<ExtensionAttributeValue> extensionValues, EStructuralFeature feature) {
        ArrayList result = new ArrayList();
        if (extensionValues != null) {
            for (ExtensionAttributeValue extattrval : extensionValues) {
                FeatureMap extensionElements = extattrval.getValue();
                result.addAll((List)extensionElements.get(feature, true));
            }
        }
        return result;
    }

    private void verifyServiceTask(ServiceTask serviceTask, String serviceImplementation, String serviceInterface, String serviceOperation) {
        String foundServiceImplementation = null;
        String foundServiceInterface = null;
        String foundServiceOperation = null;
        for (FeatureMap.Entry entry : serviceTask.getAnyAttribute()) {
            if (entry.getEStructuralFeature().getName().equals("serviceimplementation")) {
                foundServiceImplementation = (String)entry.getValue();
            }
            if (entry.getEStructuralFeature().getName().equals("serviceoperation")) {
                foundServiceOperation = (String)entry.getValue();
            }
            if (!entry.getEStructuralFeature().getName().equals("serviceinterface")) continue;
            foundServiceInterface = (String)entry.getValue();
        }
        Assert.assertEquals((Object)serviceImplementation, foundServiceImplementation);
        Assert.assertEquals((Object)serviceInterface, foundServiceInterface);
        Assert.assertEquals((Object)serviceOperation, foundServiceOperation);
    }

    private DataInput getDataInput(List<DataInput> inputs, String name) {
        if (inputs != null) {
            for (DataInput input : inputs) {
                if (input.getName() == null || !input.getName().equals(name)) continue;
                return input;
            }
        }
        return null;
    }

    private DataOutput getDataOutput(List<DataOutput> outputs, String name) {
        if (outputs != null) {
            for (DataOutput output : outputs) {
                if (output.getName() == null || !output.getName().equals(name)) continue;
                return output;
            }
        }
        return null;
    }

    private void verifyAttribute(BaseElement element, String attributeName, Object attributeValue) {
        for (FeatureMap.Entry entry : element.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals(attributeName) || !entry.getValue().equals(attributeValue)) continue;
            return;
        }
        Assert.fail((String)(attributeName + " with value: " + attributeValue + " was not found"));
    }

    @Test
    public void testUserTasksWithNoName() throws Exception {
        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
        Definitions definitions = this.loader.loadProcessFromJson("usertaskswithnoname.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        UserTask t1 = (UserTask)process.getFlowElements().get(6);
        Assert.assertEquals((Object)"Task_1", (Object)t1.getName());
        UserTask t2 = (UserTask)process.getFlowElements().get(8);
        Assert.assertEquals((Object)"Task_2", (Object)t2.getName());
    }

    @Test
    public void testMIandEventProcessBoundaryEvents() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("miandeventsubprocessboundary.json");
        Process process = this.getRootProcess(definitions);
        SubProcess miSubprocess = (SubProcess)process.getFlowElements().get(0);
        Assert.assertNotNull((Object)miSubprocess.getLoopCharacteristics());
        Assert.assertNotNull((Object)miSubprocess);
        Assert.assertEquals((Object)"MyMISubprocess", (Object)miSubprocess.getName());
        SubProcess eventSubprocess = (SubProcess)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)eventSubprocess);
        Assert.assertEquals((Object)"MyEventSubprocess", (Object)eventSubprocess.getName());
        BoundaryEvent subprocessBoundary1 = (BoundaryEvent)process.getFlowElements().get(2);
        Assert.assertNotNull((Object)subprocessBoundary1);
        Assert.assertNotNull((Object)subprocessBoundary1.getName());
        if (subprocessBoundary1.getName().equals("MyTimberBoundaryEvent1")) {
            Assert.assertEquals((Object)subprocessBoundary1.getAttachedToRef().getId(), (Object)eventSubprocess.getId());
        } else if (subprocessBoundary1.getName().equals("MyTimberBoundaryEvent2")) {
            Assert.assertEquals((Object)subprocessBoundary1.getAttachedToRef().getId(), (Object)miSubprocess.getId());
        } else {
            Assert.fail((String)"Illegal attached to ref for boundary event");
        }
        BoundaryEvent subprocessBoundary2 = (BoundaryEvent)process.getFlowElements().get(3);
        Assert.assertNotNull((Object)subprocessBoundary2);
        Assert.assertNotNull((Object)subprocessBoundary2.getName());
        if (subprocessBoundary2.getName().equals("MyTimberBoundaryEvent1")) {
            Assert.assertEquals((Object)subprocessBoundary2.getAttachedToRef().getId(), (Object)eventSubprocess.getId());
        } else if (subprocessBoundary2.getName().equals("MyTimberBoundaryEvent2")) {
            Assert.assertEquals((Object)subprocessBoundary2.getAttachedToRef().getId(), (Object)miSubprocess.getId());
        } else {
            Assert.fail((String)"Illegal attached to ref for boundary event");
        }
    }

    @Test
    public void testOnEntryOnExitScript() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("onentryonexitactions.json");
        Assert.assertTrue((definitions.getRootElements().size() == 3 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)task);
        String takOnEntryScript = this.getOnEntryScript(task.getExtensionValues());
        String taskOnExitScript = this.getOnExitScript(task.getExtensionValues());
        Assert.assertNotNull((Object)takOnEntryScript);
        Assert.assertNotNull((Object)taskOnExitScript);
        Assert.assertEquals((Object)takOnEntryScript, (Object)"<![CDATA[if ( a == null || a ) { System.out.println(a); }]]>");
        Assert.assertEquals((Object)taskOnExitScript, (Object)"<![CDATA[if ( b == null || b ) { System.out.println(b); }]]>");
    }

    @Test
    public void testMITaskProperties() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("mitaskproperties.json");
        Assert.assertTrue((definitions.getRootElements().size() == 6 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"MyTask", (Object)task.getName());
        Assert.assertEquals((Object)"miin", (Object)((DataInput)((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().get(0)).getName());
        Assert.assertEquals((Object)"miout", (Object)((DataOutput)((OutputSet)task.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().get(0)).getName());
        Assert.assertTrue((boolean)(task.getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics));
        MultiInstanceLoopCharacteristics lc = (MultiInstanceLoopCharacteristics)task.getLoopCharacteristics();
        Assert.assertNotNull((Object)lc);
        Assert.assertEquals((Object)"_aaItem", (Object)lc.getLoopDataInputRef().getItemSubjectRef().getId());
        Assert.assertEquals((Object)"_bbItem", (Object)lc.getLoopDataOutputRef().getItemSubjectRef().getId());
        Assert.assertEquals((Object)"abcde", (Object)((FormalExpression)lc.getCompletionCondition()).getBody());
        Assert.assertNotNull((Object)lc.getInputDataItem());
        Assert.assertNotNull((Object)lc.getOutputDataItem());
    }

    @Test
    public void testNoMIOnEmbeddedSubprocess() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("simpleEmbeddedSubprocess.json");
        Process process = this.getRootProcess(definitions);
        SubProcess subprocess = (SubProcess)this.getFlowElement(process.getFlowElements(), "abc");
        Assert.assertNull((Object)subprocess.getLoopCharacteristics().getId());
    }

    @Test
    public void testMISubProcess() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("miSubProcess.json");
        Process process = this.getRootProcess(definitions);
        SubProcess miSubProcess = (SubProcess)this.getFlowElement(process.getFlowElements(), "miSubProcess");
        Assert.assertEquals((long)1L, (long)miSubProcess.getIoSpecification().getDataInputs().size());
        Assert.assertEquals((long)1L, (long)miSubProcess.getIoSpecification().getDataOutputs().size());
        Assert.assertEquals((long)1L, (long)miSubProcess.getIoSpecification().getInputSets().size());
        Assert.assertEquals((long)1L, (long)miSubProcess.getIoSpecification().getOutputSets().size());
        Assert.assertEquals((long)1L, (long)((InputSet)miSubProcess.getIoSpecification().getInputSets().get(0)).getDataInputRefs().size());
        Assert.assertEquals((long)1L, (long)((OutputSet)miSubProcess.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().size());
        Assert.assertTrue((boolean)(miSubProcess.getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics));
        MultiInstanceLoopCharacteristics lc = (MultiInstanceLoopCharacteristics)miSubProcess.getLoopCharacteristics();
        Assert.assertEquals((Object)(miSubProcess.getId() + "_input"), (Object)lc.getLoopDataInputRef().getId());
        Assert.assertEquals((Object)(miSubProcess.getId() + "_output"), (Object)lc.getLoopDataOutputRef().getId());
        Assert.assertEquals((Object)"variableOne", (Object)((DataInputImpl)lc.getLoopDataInputRef()).getName());
        Assert.assertEquals((Object)"variableTwo", (Object)((DataOutputImpl)lc.getLoopDataOutputRef()).getName());
        Assert.assertNotNull((String)"defaultDataInput", (Object)lc.getInputDataItem().getId());
        Assert.assertNotNull((String)"defaultDataOutput", (Object)lc.getOutputDataItem().getId());
    }

    @Test
    public void testProcessCustomProperties() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("customProperties.json");
        Assert.assertTrue((definitions.getRootElements().size() == 1 ? 1 : 0) != 0);
        Process process = this.getRootProcess(definitions);
        List extensionAttributeValues = process.getExtensionValues();
        Assert.assertNotNull((Object)extensionAttributeValues);
        Assert.assertEquals((long)1L, (long)extensionAttributeValues.size());
        Assert.assertEquals((Object)"<![CDATA[HR]]>", (Object)this.getMetaDataValue(process.getExtensionValues(), "customCaseIdPrefix"));
        Assert.assertEquals((Object)"<![CDATA[owner:1,participant:2]]>", (Object)this.getMetaDataValue(process.getExtensionValues(), "customCaseRoles"));
    }

    @Test
    public void testTaskCustomProperties() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("customPropertiesTask.json");
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Task_1", (Object)task.getName());
        List extensionAttributeValues = task.getExtensionValues();
        Assert.assertNotNull((Object)extensionAttributeValues);
        Assert.assertEquals((long)1L, (long)extensionAttributeValues.size());
        Assert.assertEquals((Object)"<![CDATA[true]]>", (Object)this.getMetaDataValue(task.getExtensionValues(), "customAutoStart"));
    }

    @Test
    public void testUserTaskTaskNameProperty() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("userTaskTaskName.json");
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"<![CDATA[strangetaskname~`!@#$*%^()_+=-{}|\\][\":;'?><,./]]>", (Object)((FormalExpression)((Assignment)((DataInputAssociation)task.getDataInputAssociations().get(0)).getAssignment().get(0)).getFrom()).getBody());
    }

    @Test
    public void testUserTaskDataIOForForms() throws Exception {
        List<String> excludeFromForms = Arrays.asList("TaskName", "GroupId", "Skippable", "Comment", "Description", "Content", "Priority", "Locale", "CreatedBy", "NotCompletedReassign", "NotStartedReassign", "NotCompletedNotify", "NotStartedNotify");
        Definitions definitions = this.loader.loadProcessFromJson("userTaskDataIOForForms.json");
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)task);
        List inputAssociations = task.getDataInputAssociations();
        List outputAssociations = task.getDataOutputAssociations();
        Assert.assertNotNull((Object)inputAssociations);
        Assert.assertNotNull((Object)outputAssociations);
        ArrayList<String> dataInputNamesForForms = new ArrayList<String>();
        ArrayList<String> dataOutputNamesForForm = new ArrayList<String>();
        HashMap<String, String> dataInputOutputTypes = new HashMap<String, String>();
        for (DataInputAssociation dataIn : inputAssociations) {
            DataInput din = (DataInput)dataIn.getTargetRef();
            if (excludeFromForms.contains(din.getName())) continue;
            dataInputNamesForForms.add(din.getName());
            dataInputOutputTypes.put(din.getName(), din.getItemSubjectRef().getStructureRef());
        }
        for (DataOutputAssociation dataOut : outputAssociations) {
            DataOutput dout = (DataOutput)dataOut.getSourceRef().get(0);
            dataOutputNamesForForm.add(dout.getName());
            dataInputOutputTypes.put(dout.getName(), dout.getItemSubjectRef().getStructureRef());
        }
        Assert.assertTrue((dataInputNamesForForms.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((dataOutputNamesForForm.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dataInputNamesForForms.contains("reason"));
        Assert.assertTrue((boolean)dataInputNamesForForms.contains("BusinessAdministratorId"));
        Assert.assertTrue((boolean)dataInputNamesForForms.contains("test"));
        Assert.assertEquals((Object)"String", dataInputOutputTypes.get("reason"));
        Assert.assertEquals((Object)"String", dataInputOutputTypes.get("BusinessAdministratorId"));
        Assert.assertEquals((Object)"String", dataInputOutputTypes.get("test"));
        Assert.assertTrue((boolean)dataOutputNamesForForm.contains("performance"));
        Assert.assertEquals((Object)"String", dataInputOutputTypes.get("performance"));
    }

    @Test
    public void testAdHocSubprocessDroolsCompletionCondition() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("adHocSubprocessCompletionCondition.json");
        Process process = this.getRootProcess(definitions);
        AdHocSubProcess adHocSubProcess = (AdHocSubProcess)process.getFlowElements().get(0);
        Assert.assertNotNull((Object)adHocSubProcess);
        Assert.assertNotNull((Object)adHocSubProcess.getCompletionCondition());
        Assert.assertTrue((boolean)(adHocSubProcess.getCompletionCondition() instanceof FormalExpression));
        FormalExpression expression = (FormalExpression)adHocSubProcess.getCompletionCondition();
        Assert.assertEquals((Object)"<![CDATA[org.kie.api.runtime.process.CaseData(data.get(\"claimReportDone\") == true)]]>", (Object)expression.getBody());
        Assert.assertEquals((Object)"http://www.jboss.org/drools/rule", (Object)expression.getLanguage());
    }

    @Test
    public void testDMNBusinessRuleTask() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("dmnBusinessRule.json");
        Process process = this.getRootProcess(definitions);
        FlowElement task = this.getFlowElement(process.getFlowElements(), "test");
        Assert.assertTrue((boolean)(task instanceof BusinessRuleTask));
        BusinessRuleTask ruleTask = (BusinessRuleTask)task;
        Assert.assertEquals((Object)"http://www.jboss.org/drools/dmn", (Object)ruleTask.getImplementation());
    }

    @Test
    public void testCallActivityAbortParent() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("callActivityAbortParent.json");
        Process process = this.getRootProcess(definitions);
        CallActivity callActivity = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof CallActivity)) continue;
            callActivity = (CallActivity)flowElement;
            break;
        }
        Assert.assertNotNull(callActivity);
        Assert.assertEquals((Object)"callActivity", (Object)callActivity.getName());
        Assert.assertEquals((Object)"<![CDATA[false]]>", (Object)this.getMetaDataValue(callActivity.getExtensionValues(), "customAbortParent"));
    }

    @Test
    public void testAdHocSubprocessCompletionCondition() throws Exception {
        Definitions definitionsOne = this.loader.loadProcessFromJson("adhocSubprocessSetCompletionCondition.json");
        Definitions definitionsTwo = this.loader.loadProcessFromJson("adhocSubprocessEmptyCompletionCondition.json");
        Process processOne = this.getRootProcess(definitionsOne);
        Process processTwo = this.getRootProcess(definitionsTwo);
        AdHocSubProcess subprocessWithSetCompletionCondition = (AdHocSubProcess)processOne.getFlowElements().get(0);
        AdHocSubProcess subprocessWithEmptyCompletionCondition = (AdHocSubProcess)processTwo.getFlowElements().get(0);
        Assert.assertNotNull((Object)subprocessWithSetCompletionCondition);
        Assert.assertNotNull((Object)subprocessWithEmptyCompletionCondition);
        Assert.assertEquals((Object)"<![CDATA[autocomplete]]>", (Object)((FormalExpression)subprocessWithSetCompletionCondition.getCompletionCondition()).getBody());
        Assert.assertEquals((Object)"<![CDATA[autocomplete]]>", (Object)((FormalExpression)subprocessWithEmptyCompletionCondition.getCompletionCondition()).getBody());
    }

    public void testInputOutputSetsOfIoSpecification() throws Exception {
        Definitions definitions = this.loader.loadProcessFromJson("taskIoSpecification.json");
        Process process = this.getRootProcess(definitions);
        UserTask task = (UserTask)process.getFlowElements().get(0);
        Assert.assertNotNull((Object)task);
        SubProcess subProcess = (SubProcess)process.getFlowElements().get(1);
        Assert.assertNotNull((Object)subProcess);
        UserTask task2 = (UserTask)subProcess.getFlowElements().get(0);
        Assert.assertNotNull((Object)task2);
        Assert.assertNotNull((Object)task.getIoSpecification());
        Assert.assertNotNull((Object)task.getIoSpecification().getInputSets());
        Assert.assertNotNull((Object)task.getIoSpecification().getOutputSets());
        Assert.assertNotNull((Object)task2.getIoSpecification());
        Assert.assertNotNull((Object)task2.getIoSpecification().getInputSets());
        Assert.assertNotNull((Object)task2.getIoSpecification().getOutputSets());
    }

    private void verifyBpmnShapePresent(BaseElement element, Definitions definitions) {
        boolean diagramElementPresent = false;
        for (DiagramElement diagramElement : ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane().getPlaneElement()) {
            if (!(diagramElement instanceof BPMNShape) || ((BPMNShape)diagramElement).getBpmnElement() != element) continue;
            diagramElementPresent = true;
        }
        Assert.assertTrue((boolean)diagramElementPresent);
    }

    private List<BPMNEdge> getBpmnEdges(BaseElement element, Definitions definitions) {
        ArrayList<BPMNEdge> edges = new ArrayList<BPMNEdge>();
        for (DiagramElement diagramElement : ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane().getPlaneElement()) {
            if (!(diagramElement instanceof BPMNEdge) || !((BPMNEdge)diagramElement).getBpmnElement().equals(element)) continue;
            edges.add((BPMNEdge)diagramElement);
        }
        return edges;
    }

    private int getDIElementOrder(BaseElement element, Definitions definitions) {
        int counter = 0;
        for (DiagramElement diagramElement : ((BPMNDiagram)definitions.getDiagrams().get(0)).getPlane().getPlaneElement()) {
            if (diagramElement instanceof BPMNShape && ((BPMNShape)diagramElement).getBpmnElement() == element) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }
}

