/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.filters.FilterByFileName;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;

public class VFSRepositoryGitFileSystemTest {
    Logger logger = LoggerFactory.getLogger(VFSRepositoryGitFileSystemTest.class);
    private static final String REPOSITORY_ROOT = "designer-playground";
    private static final String VFS_REPOSITORY_ROOT = "git://designer-playground";
    private static final String USERNAME = "guvnorngtestuser1";
    private static final String PASSWORD = "test1234";
    private static final String ORIGIN_URL = "https://github.com/mswiderski/designer-playground.git";
    private static final String FETCH_COMMAND = "?fetch";
    private JbpmProfileImpl profile;
    private static String gitLocalClone = System.getProperty("java.io.tmpdir") + File.separator + "git-repo";
    private static Map<String, String> env = new HashMap<String, String>();
    private static int counter = 0;
    private RepositoryDescriptor descriptor;
    private VFSFileSystemProducer producer;

    @BeforeClass
    public static void prepare() {
        env.put("username", USERNAME);
        env.put("password", PASSWORD);
        env.put("origin", ORIGIN_URL);
        env.put("fetch.cmd", FETCH_COMMAND);
        System.setProperty("org.kie.nio.git.dir", gitLocalClone);
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.kie.nio.git.dir");
    }

    @Before
    public void setup() {
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        env.put("repository.root", VFS_REPOSITORY_ROOT + counter);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    private void deleteFiles(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteFiles(file);
            }
            file.delete();
        }
    }

    @After
    public void teardown() {
        File repo = new File(gitLocalClone);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
        repo = new File(".niogit");
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
        ++counter;
    }

    @Test
    public void testListDirectories() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/processes");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection directories = repository.listDirectories("/");
        Assert.assertNotNull((Object)directories);
        Assert.assertEquals((long)3L, (long)directories.size());
        directories = repository.listDirectories("/processes");
        Assert.assertNotNull((Object)directories);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testCreateDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        Assert.assertEquals((Object)"test", (Object)directoryId.getName());
        Assert.assertEquals((Object)"/", (Object)directoryId.getLocation());
        Assert.assertNotNull((Object)directoryId.getUniqueId());
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
    }

    @Test
    public void testDirectoryExists() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        Assert.assertEquals((Object)"test", (Object)directoryId.getName());
        Assert.assertEquals((Object)"/", (Object)directoryId.getLocation());
        Assert.assertNotNull((Object)directoryId.getUniqueId());
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder.content((Object)"simple content".getBytes()).type("png").name("test").location("/test");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        boolean assetPathShouldNotExists = repository.directoryExists("/test/test.png");
        Assert.assertFalse((boolean)assetPathShouldNotExists);
    }

    @Test
    public void testDeleteDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        boolean deleted = repository.deleteDirectory("/test", true);
        Assert.assertTrue((boolean)deleted);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
    }

    @Test
    public void testDeleteNonEmptyDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test/nested");
        Assert.assertNotNull((Object)directoryId);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        rootFolderExists = repository.directoryExists("/test/nested");
        Assert.assertTrue((boolean)rootFolderExists);
        boolean deleted = repository.deleteDirectory("/test", false);
        Assert.assertTrue((boolean)deleted);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
    }

    @Test
    public void testListAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/processes");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/processes");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)2L, (long)assets.size());
    }

    @Test
    public void testListSingleTextAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/processes");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/processes");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)2L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"bpmn2", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"BPMN2-ScriptTask.bpmn2", (Object)asset.getFullName());
        Assert.assertEquals((Object)"BPMN2-ScriptTask", (Object)asset.getName());
        Assert.assertEquals((Object)"/processes", (Object)asset.getAssetLocation());
    }

    @Test
    public void testListSingleBinaryAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/images");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/images");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"png", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"release-process.png", (Object)asset.getFullName());
        Assert.assertEquals((Object)"release-process", (Object)asset.getName());
        Assert.assertEquals((Object)"/images", (Object)asset.getAssetLocation());
    }

    @Test
    public void testListNestedSingleTextAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/processes/nested");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/processes/nested");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"bpmn2", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"BPMN2-UserTask.bpmn2", (Object)asset.getFullName());
        Assert.assertEquals((Object)"BPMN2-UserTask", (Object)asset.getName());
        Assert.assertEquals((Object)"/processes/nested", (Object)asset.getAssetLocation());
    }

    @Test
    public void testLoadAssetFromPath() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Asset asset = repository.loadAssetFromPath("/processes/BPMN2-ScriptTask.bpmn2");
        Assert.assertEquals((Object)"bpmn2", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"BPMN2-ScriptTask", (Object)asset.getName());
        Assert.assertEquals((Object)"BPMN2-ScriptTask.bpmn2", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/processes", (Object)asset.getAssetLocation());
        Assert.assertNotNull((Object)asset.getAssetContent());
        System.out.print(asset.getUniqueId());
    }

    @Test
    public void testStoreSingleBinaryAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder.content((Object)"simple content".getBytes()).type("png").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"png", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.png", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertFalse((((byte[])asset.getAssetContent()).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStoreSingleBinaryAssetSpaceInName() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder.content((Object)"simple content".getBytes()).type("png").name("test asset").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"png", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test asset", (Object)asset.getName());
        Assert.assertEquals((Object)"test asset.png", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertFalse((((byte[])asset.getAssetContent()).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStoreSingleTextAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"txt", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.txt", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertEquals((Object)"simple content", (Object)asset.getAssetContent());
    }

    @Test
    public void testStoreSingleUnicodeTextAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"txt", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.txt", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertEquals((Object)"\u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97", (Object)asset.getAssetContent());
    }

    @Test
    public void testAssetExists() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        for (Asset aset : assets) {
            this.logger.debug(aset.getAssetLocation() + " " + aset.getFullName());
        }
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
    }

    @Test
    public void testListAssetsRecursively() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/1/2/3/4/5/6");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)4L, (long)foundAsset.size());
    }

    @Test
    public void testUpdateAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        builder.content((Object)"updated content").uniqueId(id);
        id = repository.updateAsset(builder.getAsset(), "", "");
        foundAsset = repository.listAssetsRecursively("/", (Filter)new FilterByFileName("process.bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        String content = (String)repository.loadAsset(id).getAssetContent();
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"updated content", (Object)content);
    }

    @Test
    public void testUpdateUnicodeTextAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"\u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("txt"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        builder.content((Object)"\u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97").uniqueId(id);
        id = repository.updateAsset(builder.getAsset(), "", "");
        foundAsset = repository.listAssetsRecursively("/", (Filter)new FilterByFileName("test.txt"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        String content = (String)repository.loadAsset(id).getAssetContent();
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"\u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97 \u7cbe\u7b97", (Object)content);
    }

    @Test
    public void testDeleteAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean deleted = repository.deleteAsset(id);
        Assert.assertTrue((boolean)deleted);
        boolean assetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)assetExists);
    }

    @Test
    public void testDeleteAssetFromPath() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean deleted = repository.deleteAssetFromPath("/process.bpmn2");
        Assert.assertTrue((boolean)deleted);
        boolean assetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)assetExists);
    }

    @Test
    public void testCopyAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.copyAsset(id, "/target");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
    }

    @Test
    public void testMoveAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/target", null);
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testMoveAndRenameAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/target", "renamed.bpmn2");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/renamed.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testRenameAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/source", "renamed.bpmn2");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/source/renamed.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testCopyDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.copyDirectory("/source", "/target");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/source/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        boolean copiedDirectoryExists = repository.directoryExists("/source");
        Assert.assertTrue((boolean)copiedDirectoryExists);
    }

    @Test
    public void testMoveDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.moveDirectory("/source", "/target", null);
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/source/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        boolean movedDirectoryExists = repository.directoryExists("/source");
        Assert.assertFalse((boolean)movedDirectoryExists);
    }

    @Test
    public void testMoveEmptyDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        boolean directoryExists = repository.directoryExists(sourceDir.getLocation() + sourceDir.getName());
        Assert.assertTrue((boolean)directoryExists);
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        boolean copied = repository.moveDirectory("/source", "/", "target");
        Assert.assertTrue((boolean)copied);
        boolean movedDirectoryExists = repository.directoryExists("/source");
        Assert.assertFalse((boolean)movedDirectoryExists);
        movedDirectoryExists = repository.directoryExists("/target");
        Assert.assertTrue((boolean)movedDirectoryExists);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
    }

    @Test
    public void testCreateGlobalDirOnNewProject() throws FileAlreadyExistsException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory testProjectDir = repository.createDirectory("/mytestproject");
        KieProject mockProject = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)mockProject.getRootPath()).thenReturn((Object)Paths.convert((Path)this.producer.getIoService().get(URI.create(this.decodeUniqueId(testProjectDir.getUniqueId())))));
        NewProjectEvent event = (NewProjectEvent)Mockito.mock(NewProjectEvent.class);
        Mockito.when((Object)event.getProject()).thenReturn((Object)mockProject);
        repository.createGlobalDirOnNewProject(event);
        boolean globalDirectoryExists = repository.directoryExists("/mytestproject/global");
        Assert.assertTrue((boolean)globalDirectoryExists);
        Collection foundFormTemplates = repository.listAssets("/mytestproject/global", (Filter)new FilterByExtension("fw"));
        Assert.assertNotNull((Object)foundFormTemplates);
        Assert.assertEquals((long)25L, (long)foundFormTemplates.size());
        Collection foundJSONAssets = repository.listAssets("/mytestproject/global", (Filter)new FilterByExtension("json"));
        Assert.assertNotNull((Object)foundJSONAssets);
        Assert.assertEquals((long)3L, (long)foundJSONAssets.size());
        Collection foundWidAssets = repository.listAssets("/mytestproject", (Filter)new FilterByExtension("wid"));
        Assert.assertNotNull((Object)foundWidAssets);
        Assert.assertEquals((long)0L, (long)foundWidAssets.size());
        repository.createGlobalDirOnNewProject(event);
        boolean globalDirectoryStillExists = repository.directoryExists("/mytestproject/global");
        Assert.assertTrue((boolean)globalDirectoryStillExists);
        Collection foundFormTemplatesAfterSecondCall = repository.listAssets("/mytestproject/global", (Filter)new FilterByExtension("fw"));
        Assert.assertNotNull((Object)foundFormTemplatesAfterSecondCall);
        Assert.assertEquals((long)25L, (long)foundFormTemplatesAfterSecondCall.size());
        Collection foundJSONAssetsAfterSecondCall = repository.listAssets("/mytestproject/global", (Filter)new FilterByExtension("json"));
        Assert.assertNotNull((Object)foundJSONAssetsAfterSecondCall);
        Assert.assertEquals((long)3L, (long)foundJSONAssetsAfterSecondCall.size());
        Collection foundWidAssetsAfterSecondCall = repository.listAssets("/mytestproject", (Filter)new FilterByExtension("wid"));
        Assert.assertNotNull((Object)foundWidAssetsAfterSecondCall);
        Assert.assertEquals((long)0L, (long)foundWidAssetsAfterSecondCall.size());
    }

    private String decodeUniqueId(String uniqueId) {
        if (Base64.isBase64((String)uniqueId)) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                String uri = new String(decoded, "UTF-8");
                return UriUtils.encode((String)uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UriUtils.encode((String)uniqueId);
    }
}

